/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.java2d.Java2DRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;

public class Java2DImageHandlerRenderedImage
implements ImageHandler {
    public int getPriority() {
        return 300;
    }

    public Class getSupportedImageClass() {
        return ImageRendered.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return new ImageFlavor[]{ImageFlavor.BUFFERED_IMAGE, ImageFlavor.RENDERED_IMAGE};
    }

    public void handleImage(RenderingContext context, Image image2, Rectangle pos) throws IOException {
        Java2DRenderingContext java2dContext = (Java2DRenderingContext)context;
        ImageInfo info = image2.getInfo();
        ImageRendered imageRend = (ImageRendered)image2;
        Graphics2D g2d = java2dContext.getGraphics2D();
        AffineTransform at = new AffineTransform();
        at.translate(pos.x, pos.y);
        double sx = pos.getWidth() / (double)info.getSize().getWidthMpt();
        double sy = pos.getHeight() / (double)info.getSize().getHeightMpt();
        float sourceResolution = 72.0f;
        at.scale(sx *= (double)(sourceResolution *= 1000.0f) / info.getSize().getDpiHorizontal(), sy *= (double)sourceResolution / info.getSize().getDpiVertical());
        RenderedImage rend = imageRend.getRenderedImage();
        if (imageRend.getTransparentColor() != null && !rend.getColorModel().hasAlpha()) {
            int transCol = imageRend.getTransparentColor().getRGB();
            BufferedImage bufImage = this.makeTransparentImage(rend);
            WritableRaster alphaRaster = bufImage.getAlphaRaster();
            int[] transparent = new int[]{0};
            int maxy = bufImage.getHeight();
            for (int y = 0; y < maxy; ++y) {
                int maxx = bufImage.getWidth();
                for (int x = 0; x < maxx; ++x) {
                    int col = bufImage.getRGB(x, y);
                    if (col != transCol) continue;
                    alphaRaster.setPixel(x, y, transparent);
                }
            }
            g2d.drawRenderedImage(bufImage, at);
        } else {
            g2d.drawRenderedImage(rend, at);
        }
    }

    private BufferedImage makeTransparentImage(RenderedImage src) {
        BufferedImage bufImage = new BufferedImage(src.getWidth(), src.getHeight(), 2);
        Graphics2D g2d = bufImage.createGraphics();
        g2d.drawRenderedImage(src, new AffineTransform());
        g2d.dispose();
        return bufImage;
    }

    public boolean isCompatible(RenderingContext targetContext, Image image2) {
        return (image2 == null || image2 instanceof ImageRendered) && targetContext instanceof Java2DRenderingContext;
    }
}

