/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.ps.PSImageFormResource;
import org.apache.fop.render.ps.PSImageHandler;
import org.apache.fop.render.ps.PSRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.ps.ImageEncoder;
import org.apache.xmlgraphics.ps.ImageEncodingHelper;
import org.apache.xmlgraphics.ps.ImageFormGenerator;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSImageUtils;

public class PSImageHandlerRenderedImage
implements PSImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.BUFFERED_IMAGE, ImageFlavor.RENDERED_IMAGE};

    public void handleImage(RenderingContext context, Image image2, Rectangle pos) throws IOException {
        PSRenderingContext psContext = (PSRenderingContext)context;
        PSGenerator gen = psContext.getGenerator();
        ImageRendered imageRend = (ImageRendered)image2;
        float x = (float)pos.getX() / 1000.0f;
        float y = (float)pos.getY() / 1000.0f;
        float w = (float)pos.getWidth() / 1000.0f;
        float h = (float)pos.getHeight() / 1000.0f;
        Rectangle2D.Double targetRect = new Rectangle2D.Double(x, y, w, h);
        RenderedImage ri = imageRend.getRenderedImage();
        ImageEncoder encoder2 = ImageEncodingHelper.createRenderedImageEncoder(ri);
        Dimension imgDim = new Dimension(ri.getWidth(), ri.getHeight());
        String imgDescription = ri.getClass().getName();
        ImageEncodingHelper helper = new ImageEncodingHelper(ri);
        ColorModel cm = helper.getEncodedColorModel();
        PSImageUtils.writeImage(encoder2, imgDim, imgDescription, targetRect, cm, gen);
    }

    public void generateForm(RenderingContext context, Image image2, PSImageFormResource form) throws IOException {
        PSRenderingContext psContext = (PSRenderingContext)context;
        PSGenerator gen = psContext.getGenerator();
        ImageRendered imageRend = (ImageRendered)image2;
        ImageInfo info = image2.getInfo();
        String imageDescription = info.getMimeType() + " " + info.getOriginalURI();
        RenderedImage ri = imageRend.getRenderedImage();
        ImageFormGenerator formGen = new ImageFormGenerator(form.getName(), imageDescription, info.getSize().getDimensionPt(), ri, false);
        formGen.generate(gen);
    }

    public int getPriority() {
        return 300;
    }

    public Class getSupportedImageClass() {
        return ImageRendered.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    public boolean isCompatible(RenderingContext targetContext, Image image2) {
        return (image2 == null || image2 instanceof ImageRendered) && targetContext instanceof PSRenderingContext;
    }
}

