/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import org.apache.xalan.processor.ProcessorTemplateElem;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.templates.ElemApplyImport;
import org.apache.xalan.templates.ElemApplyTemplates;
import org.apache.xalan.templates.ElemAttribute;
import org.apache.xalan.templates.ElemCallTemplate;
import org.apache.xalan.templates.ElemComment;
import org.apache.xalan.templates.ElemCopy;
import org.apache.xalan.templates.ElemCopyOf;
import org.apache.xalan.templates.ElemElement;
import org.apache.xalan.templates.ElemExsltFuncResult;
import org.apache.xalan.templates.ElemExsltFunction;
import org.apache.xalan.templates.ElemFallback;
import org.apache.xalan.templates.ElemLiteralResult;
import org.apache.xalan.templates.ElemMessage;
import org.apache.xalan.templates.ElemNumber;
import org.apache.xalan.templates.ElemPI;
import org.apache.xalan.templates.ElemParam;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemText;
import org.apache.xalan.templates.ElemTextLiteral;
import org.apache.xalan.templates.ElemValueOf;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xml.utils.SAXSourceLocator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ProcessorExsltFunction
extends ProcessorTemplateElem {
    public void startElement(StylesheetHandler handler, String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        String msg = "";
        if (!(handler.getElemTemplateElement() instanceof Stylesheet)) {
            msg = "func:function element must be top level.";
            handler.error(msg, new SAXException(msg));
        }
        super.startElement(handler, uri, localName, rawName, attributes);
        String val = attributes.getValue("name");
        int indexOfColon = val.indexOf(":");
        if (indexOfColon > 0) {
            String prefix = val.substring(0, indexOfColon);
            String localVal = val.substring(indexOfColon + 1);
            String ns = handler.getNamespaceSupport().getURI(prefix);
        } else {
            msg = "func:function name must have namespace";
            handler.error(msg, new SAXException(msg));
        }
    }

    protected void appendAndPush(StylesheetHandler handler, ElemTemplateElement elem2) throws SAXException {
        super.appendAndPush(handler, elem2);
        elem2.setDOMBackPointer(handler.getOriginatingNode());
        handler.getStylesheet().setTemplate((ElemTemplate)elem2);
    }

    public void endElement(StylesheetHandler handler, String uri, String localName, String rawName) throws SAXException {
        ElemTemplateElement function = handler.getElemTemplateElement();
        SAXSourceLocator locator = handler.getLocator();
        this.validate(function, handler);
        super.endElement(handler, uri, localName, rawName);
    }

    public void validate(ElemTemplateElement elem2, StylesheetHandler handler) throws SAXException {
        String msg = "";
        while (elem2 != null) {
            if (elem2 instanceof ElemExsltFuncResult && elem2.getNextSiblingElem() != null && !(elem2.getNextSiblingElem() instanceof ElemFallback)) {
                msg = "func:result has an illegal following sibling (only xsl:fallback allowed)";
                handler.error(msg, new SAXException(msg));
            }
            if ((elem2 instanceof ElemApplyImport || elem2 instanceof ElemApplyTemplates || elem2 instanceof ElemAttribute || elem2 instanceof ElemCallTemplate || elem2 instanceof ElemComment || elem2 instanceof ElemCopy || elem2 instanceof ElemCopyOf || elem2 instanceof ElemElement || elem2 instanceof ElemLiteralResult || elem2 instanceof ElemNumber || elem2 instanceof ElemPI || elem2 instanceof ElemText || elem2 instanceof ElemTextLiteral || elem2 instanceof ElemValueOf) && !this.ancestorIsOk(elem2)) {
                msg = "misplaced literal result in a func:function container.";
                handler.error(msg, new SAXException(msg));
            }
            ElemTemplateElement nextElem = elem2.getFirstChildElem();
            while (nextElem == null) {
                nextElem = elem2.getNextSiblingElem();
                if (nextElem == null) {
                    elem2 = elem2.getParentElem();
                }
                if (elem2 != null && !(elem2 instanceof ElemExsltFunction)) continue;
                return;
            }
            elem2 = nextElem;
        }
    }

    boolean ancestorIsOk(ElemTemplateElement child) {
        while (child.getParentElem() != null && !(child.getParentElem() instanceof ElemExsltFunction)) {
            ElemTemplateElement parent = child.getParentElem();
            if (parent instanceof ElemExsltFuncResult || parent instanceof ElemVariable || parent instanceof ElemParam || parent instanceof ElemMessage) {
                return true;
            }
            child = parent;
        }
        return false;
    }
}

