/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.java2d.color.profile;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public final class ColorProfileUtil {
    private ColorProfileUtil() {
    }

    public static String getICCProfileDescription(ICC_Profile profile) {
        byte[] data2 = profile.getData(1684370275);
        if (data2 == null) {
            return null;
        }
        int length = data2[8] << 24 | data2[9] << 16 | data2[10] << 8 | data2[11];
        --length;
        try {
            return new String(data2, 12, length, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("Incompatible VM");
        }
    }

    public static boolean isDefaultsRGB(ICC_Profile profile) {
        ColorSpace sRGB = ColorSpace.getInstance(1000);
        ICC_Profile sRGBProfile = null;
        if (sRGB instanceof ICC_ColorSpace) {
            sRGBProfile = ((ICC_ColorSpace)sRGB).getProfile();
        }
        return profile == sRGBProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICC_Profile getICC_Profile(byte[] data2) {
        Class<ICC_Profile> clazz = ICC_Profile.class;
        synchronized (ICC_Profile.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ICC_Profile.getInstance(data2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICC_Profile getICC_Profile(int colorSpace) {
        Class<ICC_Profile> clazz = ICC_Profile.class;
        synchronized (ICC_Profile.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ICC_Profile.getInstance(colorSpace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICC_Profile getICC_Profile(InputStream in) throws IOException {
        Class<ICC_Profile> clazz = ICC_Profile.class;
        synchronized (ICC_Profile.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ICC_Profile.getInstance(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICC_Profile getICC_Profile(String fileName) throws IOException {
        Class<ICC_Profile> clazz = ICC_Profile.class;
        synchronized (ICC_Profile.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ICC_Profile.getInstance(fileName);
        }
    }
}

