/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gedcom4j.io.AnselMapping;
import org.gedcom4j.io.Encoding;
import org.gedcom4j.io.UnsupportedGedcomCharsetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GedcomFileReader {
    private static final int FIRST_CHUNK_SIZE = 16384;
    private Encoding encoding;
    private boolean byteOrderMarker = false;
    private final byte[] firstChunk = new byte[16384];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Encoding anselAsciiOrUtf8() throws IOException, UnsupportedGedcomCharsetException {
        Encoding result2 = Encoding.ANSEL;
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.firstChunk), "UTF8"));
            String s2 = r.readLine();
            int lineCount = 1;
            while (lineCount < 1000 && s2 != null) {
                if (s2.startsWith("1 CHAR ")) {
                    String e = s2.substring("1 CHAR ".length());
                    if ("ANSEL".equalsIgnoreCase(e)) {
                        result2 = Encoding.ANSEL;
                    } else if ("UTF-8".equalsIgnoreCase(e)) {
                        result2 = Encoding.UTF_8;
                    } else if ("ASCII".equalsIgnoreCase(e)) {
                        result2 = Encoding.ASCII;
                    } else if ("ANSI".equalsIgnoreCase(e)) {
                        result2 = Encoding.ANSEL;
                    } else {
                        throw new UnsupportedGedcomCharsetException("Specified charset " + e + " is not a supported charset encoding for GEDCOMs");
                    }
                }
                s2 = r.readLine();
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
        return result2;
    }

    private void detectEncoding() throws IOException, UnsupportedGedcomCharsetException {
        if (this.firstChunk[0] == -17 && this.firstChunk[1] == -69 && this.firstChunk[2] == -65) {
            this.encoding = Encoding.UTF_8;
            this.byteOrderMarker = true;
            return;
        }
        if (this.firstChunk[0] == 48 && this.firstChunk[1] == 0) {
            this.encoding = Encoding.UNICODE_LITTLE_ENDIAN;
        } else if (this.firstChunk[0] == 0 && this.firstChunk[1] == 48) {
            this.encoding = Encoding.UNICODE_BIG_ENDIAN;
        } else if (this.firstChunk[0] == 48 && this.firstChunk[1] == 32) {
            this.encoding = this.anselAsciiOrUtf8();
        } else {
            throw new IOException("Does not appear to be a valid gedcom file - doesn't begin with a zero in any supported encoding, and does not begin with a BOM marker for UTF-8 encoding");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<? extends String> loadAnselAscii(InputStream byteStream) throws IOException {
        ArrayList<String> result2 = new ArrayList<String>();
        StringBuilder lineBuffer = new StringBuilder();
        int lastChar = -1;
        int b = -1;
        boolean eof = false;
        InputStream fis = byteStream;
        try {
            while (!eof) {
                lastChar = b;
                b = fis.read();
                if (b < 0) {
                    if (lineBuffer.length() > 0) {
                        result2.add(lineBuffer.toString());
                    }
                    eof = true;
                    break;
                }
                if (b == 13) {
                    result2.add(lineBuffer.toString());
                    lineBuffer = new StringBuilder();
                    continue;
                }
                if (b == 10) {
                    if (lastChar == 13) continue;
                    result2.add(lineBuffer.toString());
                    lineBuffer = new StringBuilder();
                    continue;
                }
                if (b < 128) {
                    lineBuffer.append(Character.valueOf((char)b));
                    continue;
                }
                if (this.encoding == Encoding.ASCII) {
                    throw new IOException("Extended characters not supported in ASCII: 0x" + Integer.toHexString(b));
                }
                lineBuffer.append(AnselMapping.decode(b));
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<? extends String> loadUnicodeBigEndian(InputStream byteStream) throws IOException {
        ArrayList<String> result2 = new ArrayList<String>();
        StringBuilder lineBuffer = new StringBuilder();
        boolean eof = false;
        int b1 = -1;
        int b2 = -1;
        InputStream fis = null;
        try {
            fis = byteStream;
            while (!eof) {
                int lastB1 = b1;
                int lastB2 = b2;
                b1 = fis.read();
                b2 = fis.read();
                if (b1 < 0 || b2 < 0) {
                    if (lineBuffer.length() > 0) {
                        result2.add(lineBuffer.toString());
                    }
                    eof = true;
                    break;
                }
                if (b1 == 0 && b2 == 13) {
                    result2.add(lineBuffer.toString());
                    lineBuffer = new StringBuilder();
                    continue;
                }
                if (b1 == 0 && b2 == 10) {
                    if (lastB1 == 0 && lastB2 == 13) continue;
                    result2.add(lineBuffer.toString());
                    lineBuffer = new StringBuilder();
                    continue;
                }
                int unicodeChar = b1 << 8 | b2;
                lineBuffer.append(Character.valueOf((char)unicodeChar));
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<? extends String> loadUnicodeLittleEndian(InputStream byteStream) throws IOException {
        ArrayList<String> result2 = new ArrayList<String>();
        StringBuilder lineBuffer = new StringBuilder();
        boolean eof = false;
        int b1 = -1;
        int b2 = -1;
        InputStream fis = null;
        try {
            fis = byteStream;
            while (!eof) {
                int lastB1 = b1;
                int lastB2 = b2;
                b1 = fis.read();
                b2 = fis.read();
                if (b1 < 0 || b2 < 0) {
                    if (lineBuffer.length() > 0) {
                        result2.add(lineBuffer.toString());
                    }
                    eof = true;
                    break;
                }
                if (b1 == 13 && b2 == 0) {
                    result2.add(lineBuffer.toString());
                    lineBuffer = new StringBuilder();
                    continue;
                }
                if (b1 == 10 && b2 == 0) {
                    if (lastB1 == 13 && lastB2 == 0) continue;
                    result2.add(lineBuffer.toString());
                    lineBuffer = new StringBuilder();
                    continue;
                }
                int unicodeChar = b2 << 8 | b1;
                lineBuffer.append(Character.valueOf((char)unicodeChar));
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<? extends String> loadUtf8(InputStream byteStream) throws IOException {
        ArrayList<String> result2 = new ArrayList<String>();
        InputStreamReader r = null;
        BufferedReader br = null;
        try {
            r = new InputStreamReader(byteStream, "UTF8");
            if (this.byteOrderMarker) {
                r.read();
            }
            br = new BufferedReader(r);
            String s2 = br.readLine();
            while (s2 != null) {
                if (s2.length() != 0) {
                    result2.add(s2);
                }
                s2 = br.readLine();
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (r != null) {
                r.close();
            }
            if (byteStream != null) {
                byteStream.close();
            }
        }
        return result2;
    }

    private void saveFirstChunk(InputStream byteStream) throws IOException {
        byteStream.mark(16384);
        int read = byteStream.read(this.firstChunk);
        if (read < 0) {
            throw new IOException("Unable to read bytes off stream");
        }
        byteStream.reset();
    }

    public List<String> getLines(BufferedInputStream byteStream) throws IOException {
        this.saveFirstChunk(byteStream);
        ArrayList<String> result2 = new ArrayList<String>();
        try {
            this.detectEncoding();
        }
        catch (UnsupportedGedcomCharsetException e) {
            throw new IOException("Unable to parse GEDCOM data - " + e.getMessage());
        }
        switch (this.encoding) {
            case ANSEL: 
            case ASCII: {
                result2.addAll(this.loadAnselAscii(byteStream));
                break;
            }
            case UNICODE_BIG_ENDIAN: {
                result2.addAll(this.loadUnicodeBigEndian(byteStream));
                break;
            }
            case UNICODE_LITTLE_ENDIAN: {
                result2.addAll(this.loadUnicodeLittleEndian(byteStream));
                break;
            }
            case UTF_8: {
                result2.addAll(this.loadUtf8(byteStream));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown encoding " + (Object)((Object)this.encoding));
            }
        }
        return result2;
    }
}

