/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.validate;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.gedcom4j.model.ChangeDate;
import org.gedcom4j.model.Note;
import org.gedcom4j.model.StringWithCustomTags;
import org.gedcom4j.model.UserReference;
import org.gedcom4j.validate.GedcomValidationException;
import org.gedcom4j.validate.GedcomValidationFinding;
import org.gedcom4j.validate.GedcomValidator;
import org.gedcom4j.validate.NotesValidator;
import org.gedcom4j.validate.Severity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidator {
    protected GedcomValidator rootValidator;

    protected void addError(String description) {
        this.rootValidator.findings.add(new GedcomValidationFinding(description, Severity.ERROR, null));
    }

    protected void addError(String description, Object o) {
        this.rootValidator.findings.add(new GedcomValidationFinding(description, Severity.ERROR, o));
    }

    protected void addInfo(String description) {
        this.rootValidator.findings.add(new GedcomValidationFinding(description, Severity.INFO, null));
    }

    protected void addInfo(String description, Object o) {
        this.rootValidator.findings.add(new GedcomValidationFinding(description, Severity.INFO, o));
    }

    protected void addWarning(String description) {
        this.rootValidator.findings.add(new GedcomValidationFinding(description, Severity.WARNING, null));
    }

    protected void addWarning(String description, Object o) {
        this.rootValidator.findings.add(new GedcomValidationFinding(description, Severity.WARNING, o));
    }

    protected void checkChangeDate(ChangeDate changeDate, Object objectWithChangeDate) {
        if (changeDate == null) {
            return;
        }
        this.checkRequiredString(changeDate.date, "change date", objectWithChangeDate);
        this.checkOptionalString(changeDate.time, "change time", objectWithChangeDate);
        if (changeDate.notes == null) {
            if (this.rootValidator.autorepair) {
                changeDate.notes = new ArrayList<Note>();
                this.addInfo("Notes collection was null on " + changeDate.getClass().getSimpleName() + " - autorepaired");
            } else {
                this.addError("Notes collection is null on " + changeDate.getClass().getSimpleName());
            }
        } else {
            this.checkNotes(changeDate.notes, changeDate);
        }
    }

    protected void checkCustomTags(Object o) {
        Field customTagsField = null;
        try {
            customTagsField = o.getClass().getField("customTags");
        }
        catch (NoSuchFieldException e) {
            this.addError("There is no field named 'customTags' on object of type " + o.getClass().getSimpleName() + ".", o);
            return;
        }
        catch (SecurityException e) {
            this.addError("There is no field named 'customTags' on object of type " + o.getClass().getSimpleName() + ".", o);
            return;
        }
        Object fldVal = null;
        try {
            fldVal = customTagsField.get(o);
        }
        catch (IllegalArgumentException e) {
            this.addError("Cannot get value of customTags attribute on object of type " + o.getClass().getSimpleName() + " - " + e.getMessage(), o);
            return;
        }
        catch (IllegalAccessException e) {
            this.addError("Cannot get value of customTags attribute on object of type " + o.getClass().getSimpleName() + " - " + e.getMessage(), o);
            return;
        }
        if (fldVal == null) {
            if (this.rootValidator.autorepair) {
                ArrayList customTags = new ArrayList();
                try {
                    customTagsField.set(o, customTags);
                }
                catch (IllegalArgumentException e) {
                    this.addError("Cannot autorepair value of customTags attribute on object of type " + o.getClass().getSimpleName() + " - " + e.getMessage(), o);
                    return;
                }
                catch (IllegalAccessException e) {
                    this.addError("Cannot autorepair value of customTags attribute on object of type " + o.getClass().getSimpleName() + " - " + e.getMessage(), o);
                    return;
                }
                this.rootValidator.addInfo("Custom tag collection was null - repaired", o);
            } else {
                this.rootValidator.addError("Custom tag collection is null - must be at least an empty collection", o);
            }
        } else if (!(fldVal instanceof List)) {
            this.rootValidator.addError("Custom tag collection is not a List", o);
        }
    }

    protected void checkNotes(List<Note> notes, Object objectWithNotes) {
        new NotesValidator(this.rootValidator, objectWithNotes, notes).validate();
    }

    protected void checkOptionalString(String optionalString, String fieldDescription, Object objectContainingField) {
        if (optionalString != null && optionalString.trim().length() == 0) {
            this.addError(fieldDescription + " on " + objectContainingField.getClass().getSimpleName() + " is specified, but has a blank value", objectContainingField);
        }
    }

    protected void checkOptionalString(StringWithCustomTags optionalString, String fieldDescription, Object objectContainingField) {
        if (optionalString != null && optionalString.value != null && optionalString.value.trim().length() == 0) {
            this.addError(fieldDescription + " on " + objectContainingField.getClass().getSimpleName() + " is specified, but has a blank value", objectContainingField);
        }
        this.checkStringWithCustomTags(optionalString, fieldDescription);
    }

    protected void checkRequiredString(String requiredString, String fieldDescription, Object objectContainingField) {
        if (requiredString == null || requiredString.trim().length() == 0) {
            this.addError(fieldDescription + " on " + objectContainingField.getClass().getSimpleName() + " is required, but is either null or blank", objectContainingField);
        }
    }

    protected void checkRequiredString(StringWithCustomTags requiredString, String fieldDescription, Object objectContainingField) {
        if (requiredString == null || requiredString.value == null || requiredString.value.trim().length() == 0) {
            this.addError(fieldDescription + " on " + objectContainingField.getClass().getSimpleName() + " is required, but is either null or blank", objectContainingField);
        }
        this.checkStringWithCustomTags(requiredString, fieldDescription);
    }

    protected void checkStringList(List<String> stringList, String description, boolean blanksAllowed) {
        for (String a : stringList) {
            if (a == null) {
                this.addError("String list (" + description + ") contains null entry", stringList);
                continue;
            }
            if (blanksAllowed || a.trim().length() != 0) continue;
            this.addError("String list (" + description + ") contains blank entry where none are allowed", stringList);
        }
    }

    protected void checkStringTagList(List<StringWithCustomTags> stringList, String description, boolean blanksAllowed) {
        for (StringWithCustomTags a : stringList) {
            if (a == null || a.value == null) {
                this.addError("String list (" + description + ") contains null entry", stringList);
                continue;
            }
            if (blanksAllowed || a.value.trim().length() != 0) continue;
            this.addError("String list (" + description + ") contains blank entry where none are allowed", stringList);
        }
    }

    protected void checkUserReferences(List<UserReference> userReferences, Object objectWithUserReferences) {
        for (UserReference userReference : userReferences) {
            if (userReference == null) {
                this.addError("Null user reference in collection on " + objectWithUserReferences.getClass().getSimpleName(), objectWithUserReferences);
                continue;
            }
            this.checkRequiredString(userReference.referenceNum, "reference number", (Object)userReference);
            this.checkOptionalString(userReference.type, "reference type", (Object)userReference);
        }
    }

    protected void checkXref(Object objectContainingXref) {
        this.checkXref(objectContainingXref, "xref");
    }

    protected void checkXref(Object objectContainingXref, String xrefFieldName) {
        try {
            Field xrefField = objectContainingXref.getClass().getField(xrefFieldName);
            String xref = (String)xrefField.get(objectContainingXref);
            this.checkRequiredString(xref, xrefFieldName, objectContainingXref);
            if (xref != null) {
                if (xref.length() < 3) {
                    this.addError("xref on " + objectContainingXref.getClass().getSimpleName() + " is too short to be a valid xref", objectContainingXref);
                }
                if (!xref.startsWith("@")) {
                    this.addError("xref on " + objectContainingXref.getClass().getSimpleName() + " is doesn't start with an at-sign (@)", objectContainingXref);
                }
                if (!xref.endsWith("@")) {
                    this.addError("xref on " + objectContainingXref.getClass().getSimpleName() + " is doesn't end with an at-sign (@)", objectContainingXref);
                }
            }
        }
        catch (SecurityException e) {
            throw new GedcomValidationException(objectContainingXref.getClass().getSimpleName() + " doesn't have an xref to validate", e);
        }
        catch (ClassCastException e) {
            throw new GedcomValidationException(objectContainingXref.getClass().getSimpleName() + " doesn't have an xref to validate", e);
        }
        catch (NoSuchFieldException e) {
            throw new GedcomValidationException(objectContainingXref.getClass().getSimpleName() + " doesn't have an xref to validate", e);
        }
        catch (IllegalArgumentException e) {
            throw new GedcomValidationException(objectContainingXref.getClass().getSimpleName() + " doesn't have an xref to validate", e);
        }
        catch (IllegalAccessException e) {
            throw new GedcomValidationException(objectContainingXref.getClass().getSimpleName() + " doesn't have an xref to validate", e);
        }
    }

    protected boolean hasErrors() {
        for (GedcomValidationFinding finding : this.rootValidator.findings) {
            if (finding.severity != Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    protected boolean hasWarnings() {
        for (GedcomValidationFinding finding : this.rootValidator.findings) {
            if (finding.severity != Severity.WARNING) continue;
            return true;
        }
        return false;
    }

    protected abstract void validate();

    private void checkStringWithCustomTags(StringWithCustomTags swct, String fieldDescription) {
        if (swct == null) {
            return;
        }
        if (swct.value == null || swct.value.trim().length() == 0) {
            this.addError("A string with custom tags object (" + fieldDescription + ") was defined with no value", swct);
        }
        this.checkCustomTags(swct);
    }
}

