/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.validate;

import java.util.ArrayList;
import org.gedcom4j.model.AbstractCitation;
import org.gedcom4j.model.PersonalNameVariation;
import org.gedcom4j.validate.CitationValidator;
import org.gedcom4j.validate.GedcomValidator;
import org.gedcom4j.validate.NameVariationValidator;

public class PersonalNameVariationValidator
extends NameVariationValidator {
    public PersonalNameVariationValidator(GedcomValidator rootValidator, PersonalNameVariation pnv) {
        super(rootValidator, pnv);
    }

    protected void validate() {
        super.validate();
        if (this.nv == null) {
            return;
        }
        if (!(this.nv instanceof PersonalNameVariation)) {
            this.addError("Name variation on person is not a PersonalNameVariation");
            return;
        }
        PersonalNameVariation pnv = (PersonalNameVariation)this.nv;
        if (pnv.citations == null) {
            if (this.rootValidator.autorepair) {
                pnv.citations = new ArrayList<AbstractCitation>();
                this.addInfo("citations collection for personal name was null - autorepaired", pnv);
            } else {
                this.addError("citations collection for personal name is null", pnv);
            }
        } else {
            for (AbstractCitation c : pnv.citations) {
                new CitationValidator(this.rootValidator, c).validate();
            }
        }
        this.checkOptionalString(pnv.givenName, "given name", (Object)pnv);
        this.checkOptionalString(pnv.nickname, "nickname", (Object)pnv);
        this.checkOptionalString(pnv.prefix, "prefix", (Object)pnv);
        this.checkOptionalString(pnv.suffix, "suffix", (Object)pnv);
        this.checkOptionalString(pnv.surname, "surname", (Object)pnv);
        this.checkOptionalString(pnv.surnamePrefix, "surname prefix", (Object)pnv);
        this.checkNotes(pnv.notes, pnv);
    }
}

