/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.validate;

import java.util.ArrayList;
import org.gedcom4j.model.EventRecorded;
import org.gedcom4j.model.Multimedia;
import org.gedcom4j.model.RepositoryCitation;
import org.gedcom4j.model.Source;
import org.gedcom4j.model.SourceCallNumber;
import org.gedcom4j.model.SourceData;
import org.gedcom4j.validate.AbstractValidator;
import org.gedcom4j.validate.GedcomValidator;
import org.gedcom4j.validate.MultimediaValidator;

class SourceValidator
extends AbstractValidator {
    private Source source;

    public SourceValidator(GedcomValidator rootValidator, Source source) {
        this.rootValidator = rootValidator;
        this.source = source;
    }

    protected void validate() {
        if (this.source == null) {
            this.addError("Source is null and cannot be validated");
            return;
        }
        this.checkXref(this.source);
        this.checkChangeDate(this.source.changeDate, this.source);
        if (this.source.data != null) {
            SourceData sd = this.source.data;
            this.checkNotes(sd.notes, sd);
            this.checkOptionalString(sd.respAgency, "responsible agency", (Object)sd);
            if (sd.eventsRecorded == null) {
                if (this.rootValidator.autorepair) {
                    sd.eventsRecorded = new ArrayList<EventRecorded>();
                    this.addInfo("Collection of recorded events in source data structure was null - autorepaired", sd);
                } else {
                    this.addError("Collection of recorded events in source data structure is null", sd);
                }
            } else {
                for (EventRecorded er : sd.eventsRecorded) {
                    this.checkOptionalString(er.datePeriod, "date period", (Object)er);
                    this.checkOptionalString(er.eventType, "event type", (Object)er);
                    this.checkOptionalString(er.jurisdiction, "jurisdiction", (Object)er);
                }
            }
        }
        if (this.source.multimedia == null) {
            if (this.rootValidator.autorepair) {
                this.source.multimedia = new ArrayList<Multimedia>();
                this.addInfo("Multimedia collection on source was null - autorepaired", this.source);
            }
            this.addError("Multimedia collection on source is null", this.source);
        } else {
            for (Multimedia multimedia : this.source.multimedia) {
                new MultimediaValidator(this.rootValidator, multimedia).validate();
            }
        }
        this.checkNotes(this.source.notes, this.source);
        this.checkStringList(this.source.originatorsAuthors, "originators/authors", false);
        this.checkStringList(this.source.publicationFacts, "publication facts", false);
        this.checkOptionalString(this.source.recIdNumber, "automated record id", (Object)this.source);
        this.checkStringList(this.source.sourceText, "source text", true);
        this.checkOptionalString(this.source.sourceFiledBy, "source filed by", (Object)this.source);
        this.checkStringList(this.source.title, "title", true);
        this.checkUserReferences(this.source.userReferences, this.source);
        RepositoryCitation c = this.source.repositoryCitation;
        if (c != null) {
            this.checkNotes(c.notes, c);
            this.checkRequiredString(c.repositoryXref, "repository xref", (Object)c);
            this.checkCallNumbers(c);
        }
    }

    private void checkCallNumbers(RepositoryCitation citation) {
        if (citation.callNumbers == null) {
            if (this.rootValidator.autorepair) {
                citation.callNumbers = new ArrayList<SourceCallNumber>();
                this.addInfo("Call numbers collection on repository citation was null - autorepaired", citation);
            } else {
                this.addError("Call numbers collection on repository citation is null", citation);
            }
        } else {
            for (SourceCallNumber scn : citation.callNumbers) {
                this.checkOptionalString(scn.callNumber, "call number", (Object)scn);
                if (scn.callNumber != null) {
                    this.checkOptionalString(scn.mediaType, "media type", (Object)scn);
                    continue;
                }
                if (scn.mediaType == null) continue;
                this.addError("You cannot specify media type without a call number in a SourceCallNumber structure", scn);
            }
        }
    }
}

