/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.DefaultErrorReporter;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;

public class BaseFunction
extends IdScriptableObject
implements Function {
    static final long serialVersionUID = 5311394446546053859L;
    private static final Object FUNCTION_TAG = new Object();
    private static final int Id_length = 1;
    private static final int Id_arity = 2;
    private static final int Id_name = 3;
    private static final int Id_prototype = 4;
    private static final int Id_arguments = 5;
    private static final int MAX_INSTANCE_ID = 5;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int Id_apply = 4;
    private static final int Id_call = 5;
    private static final int MAX_PROTOTYPE_ID = 5;
    private Object prototypeProperty;
    private boolean isPrototypePropertyImmune;

    static void init(Scriptable scriptable, boolean bl) {
        BaseFunction baseFunction = new BaseFunction();
        baseFunction.isPrototypePropertyImmune = true;
        baseFunction.exportAsJSClass(5, scriptable, bl);
    }

    public BaseFunction() {
    }

    public BaseFunction(Scriptable scriptable, Scriptable scriptable2) {
        super(scriptable, scriptable2);
    }

    public String getClassName() {
        return "Function";
    }

    public boolean hasInstance(Scriptable scriptable) {
        Object object = ScriptableObject.getProperty((Scriptable)this, "prototype");
        if (object instanceof Scriptable) {
            return ScriptRuntime.jsDelegatesTo(scriptable, (Scriptable)object);
        }
        throw ScriptRuntime.typeError1("msg.instanceof.bad.prototype", this.getFunctionName());
    }

    protected int getMaxInstanceId() {
        return 5;
    }

    protected int findInstanceIdInfo(String string2) {
        int n;
        int n2 = 0;
        String string3 = null;
        switch (string2.length()) {
            case 4: {
                string3 = "name";
                n2 = 3;
                break;
            }
            case 5: {
                string3 = "arity";
                n2 = 2;
                break;
            }
            case 6: {
                string3 = "length";
                n2 = 1;
                break;
            }
            case 9: {
                char c = string2.charAt(0);
                if (c == 'a') {
                    string3 = "arguments";
                    n2 = 5;
                    break;
                }
                if (c != 'p') break;
                string3 = "prototype";
                n2 = 4;
                break;
            }
        }
        if (string3 != null && string3 != string2 && !string3.equals(string2)) {
            n2 = 0;
        }
        if (n2 == 0) {
            return super.findInstanceIdInfo(string2);
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 3: {
                n = 7;
                break;
            }
            case 4: {
                n = this.isPrototypePropertyImmune ? 7 : 2;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return BaseFunction.instanceIdInfo(n, n2);
    }

    protected String getInstanceIdName(int n) {
        switch (n) {
            case 1: {
                return "length";
            }
            case 2: {
                return "arity";
            }
            case 3: {
                return "name";
            }
            case 4: {
                return "prototype";
            }
            case 5: {
                return "arguments";
            }
        }
        return super.getInstanceIdName(n);
    }

    protected Object getInstanceIdValue(int n) {
        switch (n) {
            case 1: {
                return ScriptRuntime.wrapInt(this.getLength());
            }
            case 2: {
                return ScriptRuntime.wrapInt(this.getArity());
            }
            case 3: {
                return this.getFunctionName();
            }
            case 4: {
                return this.getPrototypeProperty();
            }
            case 5: {
                return this.getArguments();
            }
        }
        return super.getInstanceIdValue(n);
    }

    protected void setInstanceIdValue(int n, Object object) {
        if (n == 4) {
            if (!this.isPrototypePropertyImmune) {
                this.prototypeProperty = object != null ? object : UniqueTag.NULL_VALUE;
            }
            return;
        }
        if (n == 5) {
            if (object == NOT_FOUND) {
                Kit.codeBug();
            }
            this.defaultPut("arguments", object);
        }
        super.setInstanceIdValue(n, object);
    }

    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        idFunctionObject.setPrototype(this);
        super.fillConstructorProperties(idFunctionObject);
    }

    protected void initPrototypeId(int n) {
        String string2;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string2 = "constructor";
                break;
            }
            case 2: {
                n2 = 1;
                string2 = "toString";
                break;
            }
            case 3: {
                n2 = 1;
                string2 = "toSource";
                break;
            }
            case 4: {
                n2 = 2;
                string2 = "apply";
                break;
            }
            case 5: {
                n2 = 1;
                string2 = "call";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(FUNCTION_TAG, n, string2, n2);
    }

    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(FUNCTION_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                return BaseFunction.jsConstructor(context, scriptable, objectArray);
            }
            case 2: {
                BaseFunction baseFunction = this.realFunction(scriptable2, idFunctionObject);
                int n2 = ScriptRuntime.toInt32(objectArray, 0);
                return baseFunction.decompile(n2, 0);
            }
            case 3: {
                BaseFunction baseFunction = this.realFunction(scriptable2, idFunctionObject);
                int n3 = 0;
                int n4 = 2;
                if (objectArray.length != 0) {
                    n3 = ScriptRuntime.toInt32(objectArray[0]);
                    if (n3 >= 0) {
                        n4 = 0;
                    } else {
                        n3 = 0;
                    }
                }
                return baseFunction.decompile(n3, n4);
            }
            case 4: 
            case 5: {
                return ScriptRuntime.applyOrCall(n == 4, context, scriptable, scriptable2, objectArray);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private BaseFunction realFunction(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        Object object = scriptable.getDefaultValue(ScriptRuntime.FunctionClass);
        if (object instanceof BaseFunction) {
            return (BaseFunction)object;
        }
        throw ScriptRuntime.typeError1("msg.incompat.call", idFunctionObject.getFunctionName());
    }

    public void setImmunePrototypeProperty(Object object) {
        if (this.isPrototypePropertyImmune) {
            throw new IllegalStateException();
        }
        this.prototypeProperty = object != null ? object : UniqueTag.NULL_VALUE;
        this.isPrototypePropertyImmune = true;
    }

    protected Scriptable getClassPrototype() {
        Object object = this.getPrototypeProperty();
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return BaseFunction.getClassPrototype(this, "Object");
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return Undefined.instance;
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        Scriptable scriptable2 = this.createObject(context, scriptable);
        if (scriptable2 != null) {
            Object object = this.call(context, scriptable, scriptable2, objectArray);
            if (object instanceof Scriptable) {
                scriptable2 = (Scriptable)object;
            }
        } else {
            Scriptable scriptable3;
            Object object = this.call(context, scriptable, null, objectArray);
            if (!(object instanceof Scriptable)) {
                throw new IllegalStateException("Bad implementaion of call as constructor, name=" + this.getFunctionName() + " in " + this.getClass().getName());
            }
            scriptable2 = (Scriptable)object;
            if (scriptable2.getPrototype() == null) {
                scriptable2.setPrototype(this.getClassPrototype());
            }
            if (scriptable2.getParentScope() == null && scriptable2 != (scriptable3 = this.getParentScope())) {
                scriptable2.setParentScope(scriptable3);
            }
        }
        return scriptable2;
    }

    public Scriptable createObject(Context context, Scriptable scriptable) {
        NativeObject nativeObject = new NativeObject();
        nativeObject.setPrototype(this.getClassPrototype());
        nativeObject.setParentScope(this.getParentScope());
        return nativeObject;
    }

    String decompile(int n, int n2) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = bl = 0 != (n2 & 1);
        if (!bl) {
            stringBuffer.append("function ");
            stringBuffer.append(this.getFunctionName());
            stringBuffer.append("() {\n\t");
        }
        stringBuffer.append("[native code, arity=");
        stringBuffer.append(this.getArity());
        stringBuffer.append("]\n");
        if (!bl) {
            stringBuffer.append("}\n");
        }
        return stringBuffer.toString();
    }

    public int getArity() {
        return 0;
    }

    public int getLength() {
        return 0;
    }

    public String getFunctionName() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object getPrototypeProperty() {
        Object object = this.prototypeProperty;
        if (object == null) {
            BaseFunction baseFunction = this;
            synchronized (baseFunction) {
                object = this.prototypeProperty;
                if (object == null) {
                    this.setupDefaultPrototype();
                    object = this.prototypeProperty;
                }
            }
        } else if (object == UniqueTag.NULL_VALUE) {
            object = null;
        }
        return object;
    }

    private void setupDefaultPrototype() {
        NativeObject nativeObject = new NativeObject();
        nativeObject.defineProperty("constructor", this, 2);
        this.prototypeProperty = nativeObject;
        Scriptable scriptable = BaseFunction.getObjectPrototype(this);
        if (scriptable != nativeObject) {
            nativeObject.setPrototype(scriptable);
        }
    }

    private Object getArguments() {
        Object object = this.defaultGet("arguments");
        if (object != NOT_FOUND) {
            return object;
        }
        Context context = Context.getContext();
        NativeCall nativeCall = ScriptRuntime.findFunctionActivation(context, this);
        return nativeCall == null ? null : nativeCall.get("arguments", (Scriptable)nativeCall);
    }

    private static Object jsConstructor(Context context, Scriptable scriptable, Object[] objectArray) {
        int n = objectArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("function ");
        if (context.getLanguageVersion() != 120) {
            stringBuffer.append("anonymous");
        }
        stringBuffer.append('(');
        for (int i = 0; i < n - 1; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(ScriptRuntime.toString(objectArray[i]));
        }
        stringBuffer.append(") {");
        if (n != 0) {
            String string2 = ScriptRuntime.toString(objectArray[n - 1]);
            stringBuffer.append(string2);
        }
        stringBuffer.append('}');
        String string3 = stringBuffer.toString();
        int[] nArray = new int[1];
        String string4 = Context.getSourcePositionFromStack(nArray);
        if (string4 == null) {
            string4 = "<eval'ed string>";
            nArray[0] = 1;
        }
        String string5 = ScriptRuntime.makeUrlForGeneratedScript(false, string4, nArray[0]);
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        ErrorReporter errorReporter = DefaultErrorReporter.forEval(context.getErrorReporter());
        return context.compileFunction(scriptable2, string3, new Interpreter(), errorReporter, string5, 1, null);
    }

    protected int findPrototypeId(String string2) {
        int n = 0;
        String string3 = null;
        switch (string2.length()) {
            case 4: {
                string3 = "call";
                n = 5;
                break;
            }
            case 5: {
                string3 = "apply";
                n = 4;
                break;
            }
            case 8: {
                char c = string2.charAt(3);
                if (c == 'o') {
                    string3 = "toSource";
                    n = 3;
                    break;
                }
                if (c != 't') break;
                string3 = "toString";
                n = 2;
                break;
            }
            case 11: {
                string3 = "constructor";
                n = 1;
                break;
            }
        }
        if (string3 != null && string3 != string2 && !string3.equals(string2)) {
            n = 0;
        }
        return n;
    }
}

