/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ScriptOrFnNode;

final class OptFunctionNode {
    FunctionNode fnode;
    private boolean[] numberVarFlags;
    private int directTargetIndex = -1;
    private boolean itsParameterNumberContext;
    boolean itsContainsCalls0;
    boolean itsContainsCalls1;

    OptFunctionNode(FunctionNode functionNode) {
        this.fnode = functionNode;
        functionNode.setCompilerData(this);
    }

    static OptFunctionNode get(ScriptOrFnNode scriptOrFnNode, int n) {
        FunctionNode functionNode = scriptOrFnNode.getFunctionNode(n);
        return (OptFunctionNode)functionNode.getCompilerData();
    }

    static OptFunctionNode get(ScriptOrFnNode scriptOrFnNode) {
        return (OptFunctionNode)scriptOrFnNode.getCompilerData();
    }

    boolean isTargetOfDirectCall() {
        return this.directTargetIndex >= 0;
    }

    int getDirectTargetIndex() {
        return this.directTargetIndex;
    }

    void setDirectTargetIndex(int n) {
        if (n < 0 || this.directTargetIndex >= 0) {
            Kit.codeBug();
        }
        this.directTargetIndex = n;
    }

    void setParameterNumberContext(boolean bl) {
        this.itsParameterNumberContext = bl;
    }

    boolean getParameterNumberContext() {
        return this.itsParameterNumberContext;
    }

    int getVarCount() {
        return this.fnode.getParamAndVarCount();
    }

    boolean isParameter(int n) {
        return n < this.fnode.getParamCount();
    }

    boolean isNumberVar(int n) {
        if ((n -= this.fnode.getParamCount()) >= 0 && this.numberVarFlags != null) {
            return this.numberVarFlags[n];
        }
        return false;
    }

    void setIsNumberVar(int n) {
        if ((n -= this.fnode.getParamCount()) < 0) {
            Kit.codeBug();
        }
        if (this.numberVarFlags == null) {
            int n2 = this.fnode.getParamAndVarCount() - this.fnode.getParamCount();
            this.numberVarFlags = new boolean[n2];
        }
        this.numberVarFlags[n] = true;
    }

    int getVarIndex(Node node) {
        int n = node.getIntProp(7, -1);
        if (n == -1) {
            String string2;
            int n2 = node.getType();
            if (n2 == 54) {
                string2 = node.getString();
            } else if (n2 == 55) {
                string2 = node.getFirstChild().getString();
            } else {
                throw Kit.codeBug();
            }
            n = this.fnode.getParamOrVarIndex(string2);
            if (n < 0) {
                throw Kit.codeBug();
            }
            node.putIntProp(7, n);
        }
        return n;
    }
}

