/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.mtp._internal.entity;

import im.actor.api.mtp._internal.entity.ProtoMessage;
import im.actor.api.mtp._internal.entity.ProtoObject;
import im.actor.api.util.StreamingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ProtoPackage
extends ProtoObject {
    private long authId;
    private long sessionId;
    private ProtoMessage payload;

    public ProtoPackage(InputStream stream) throws IOException {
        super(stream);
    }

    public ProtoPackage(long authId, long sessionId, ProtoMessage payload) {
        this.authId = authId;
        this.sessionId = sessionId;
        this.payload = payload;
    }

    public long getAuthId() {
        return this.authId;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public ProtoMessage getPayload() {
        return this.payload;
    }

    @Override
    public void writeObject(OutputStream bs) throws IOException {
        StreamingUtils.writeLong(this.authId, bs);
        StreamingUtils.writeLong(this.sessionId, bs);
        this.payload.writeObject(bs);
    }

    @Override
    public ProtoObject readObject(InputStream bs) throws IOException {
        this.authId = StreamingUtils.readLong(bs);
        this.sessionId = StreamingUtils.readLong(bs);
        this.payload = new ProtoMessage(bs);
        return this;
    }

    @Override
    public int getLength() {
        return 16 + this.payload.getLength();
    }

    public String toString() {
        return "ProtoPackage[" + this.authId + "|" + this.sessionId + "]";
    }
}

