/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.crypto;

import im.actor.api.crypto.Crypto;
import im.actor.api.crypto.DecryptException;
import im.actor.api.crypto.Utils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class RsaDecryptCipher {
    private PrivateKey privateKey;
    private Cipher rsaCipher;
    private Cipher aesCipher;

    public RsaDecryptCipher(PrivateKey privateKey) {
        this.privateKey = privateKey;
        this.rsaCipher = Crypto.createRSACipher();
        try {
            this.rsaCipher.init(2, privateKey);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
        this.aesCipher = Crypto.createAESCipher();
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public byte[] decrypt(byte[] encryptedAesKey, byte[] encrypted) throws DecryptException {
        byte[] res;
        byte[] aesKey;
        try {
            aesKey = this.rsaCipher.doFinal(encryptedAesKey);
        }
        catch (BadPaddingException e) {
            throw new DecryptException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new DecryptException(e);
        }
        if (aesKey.length < 48) {
            throw new DecryptException("Too short aes key");
        }
        byte[] key = Utils.substring(aesKey, aesKey.length - 16 - 32, 32);
        byte[] iv = Utils.substring(aesKey, aesKey.length - 16, 16);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
        try {
            this.aesCipher.init(2, (Key)keySpec, ivSpec);
            res = this.aesCipher.doFinal(encrypted);
        }
        catch (InvalidKeyException e) {
            throw new DecryptException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new DecryptException(e);
        }
        catch (BadPaddingException e) {
            throw new DecryptException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new DecryptException(e);
        }
        int len = Utils.readInt(res, 0);
        if (len <= 0) {
            throw new DecryptException("Incorrect package size");
        }
        if (len >= 65536) {
            throw new DecryptException("Too big package size");
        }
        if (len > res.length - 4) {
            throw new DecryptException("Encrypted size are bigger than size");
        }
        res = Utils.substring(res, 4, len);
        return res;
    }
}

