/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.sql.handler;

import io.bitsensor.lib.entity.proto.Invocation;
import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.handler.Handler;
import io.bitsensor.plugins.java.sql.handler.SQLHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ResultSetHandler
implements SQLHandler {
    private static final Logger logger = LoggerFactory.getLogger(ResultSetHandler.class);

    @Override
    public void handle(Statement statement, Invocation.SQLInvocation.Builder builder) {
        try {
            if (statement.getResultSet() != null) {
                if (statement.getResultSetType() == 1003) {
                    logger.warn("Unable to handle ResultSet for BitSensor because this ResultSet is FORWARD_ONLY.");
                } else {
                    ResultSet rs = statement.getResultSet();
                    int savedRow = rs.getRow();
                    rs.last();
                    Invocation.SQLInvocation newSqlInvocation = builder.putEndpoint("hits", String.valueOf(rs.getRow())).build();
                    BitSensor.apply(b -> BitSensor.addSQLInvocation((Invocation.SQLInvocation)newSqlInvocation));
                    rs.absolute(savedRow);
                    return;
                }
            }
            BitSensor.apply(b -> BitSensor.addSQLInvocation((Invocation.SQLInvocation)builder.build()));
        }
        catch (SQLException e) {
            logger.warn("Unable to handle ResultSet for BitSensor.", (Throwable)e);
        }
    }

    public Handler.ExecutionMoment getExecutionMoment() {
        return Handler.ExecutionMoment.POST_HANDLE;
    }
}

