/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.codetf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.codemodder.codetf.CodeTFPackageAction;
import io.codemodder.codetf.CodeTFParameter;
import io.codemodder.codetf.CodeTFValidator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class CodeTFChange {
    private final int lineNumber;
    private final String description;
    private final String sourceControlUrl;
    private final Map<String, String> properties;
    private final List<CodeTFPackageAction> packageActions;
    private final List<CodeTFParameter> parameters;

    @JsonCreator
    public CodeTFChange(@JsonProperty(value="lineNumber") int lineNumber, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="description") String description, @JsonProperty(value="packageActions") List<CodeTFPackageAction> packageActions, @JsonProperty(value="sourceControlUrl") String sourceControlUrl, @JsonProperty(value="parameters") List<CodeTFParameter> parameters) {
        if (lineNumber < 1) {
            throw new IllegalArgumentException("line number must be positive");
        }
        this.lineNumber = lineNumber;
        this.properties = CodeTFValidator.toImmutableCopyOrEmptyOnNull(properties);
        this.packageActions = CodeTFValidator.toImmutableCopyOrEmptyOnNull(packageActions);
        this.sourceControlUrl = sourceControlUrl;
        this.description = description;
        this.parameters = parameters;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getDescription() {
        return this.description;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getSourceControlUrl() {
        return this.sourceControlUrl;
    }

    public List<CodeTFPackageAction> getPackageActions() {
        return this.packageActions;
    }

    public List<CodeTFParameter> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeTFChange that = (CodeTFChange)o;
        return this.lineNumber == that.lineNumber && Objects.equals(this.description, that.description) && Objects.equals(this.sourceControlUrl, that.sourceControlUrl) && Objects.equals(this.properties, that.properties) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.lineNumber, this.description, this.properties, this.sourceControlUrl, this.parameters);
    }

    public String toString() {
        return "CodeTFChange{lineNumber=" + this.lineNumber + ", description='" + this.description + "', sourceControlUrl='" + this.sourceControlUrl + "', properties=" + this.properties + ", parameters=" + this.parameters + "}";
    }

    public static Builder basedOn(CodeTFChange change) {
        return new Builder(change);
    }

    public static class Builder {
        private final CodeTFChange originalChange;
        private String updatedDescription;
        private Map<String, String> updatedProperties;

        private Builder(CodeTFChange change) {
            this.originalChange = Objects.requireNonNull(change);
            this.updatedProperties = new HashMap<String, String>(change.getProperties());
        }

        public Builder withDescription(String description) {
            Objects.requireNonNull(description);
            this.updatedDescription = description;
            return this;
        }

        public Builder withAdditionalProperties(Map<String, String> newProperties) {
            Objects.requireNonNull(newProperties);
            if (this.updatedProperties == null) {
                this.updatedProperties = new HashMap<String, String>(this.originalChange.properties);
            }
            this.updatedProperties.putAll(newProperties);
            return this;
        }

        public CodeTFChange build() {
            return new CodeTFChange(this.originalChange.getLineNumber(), this.updatedProperties != null ? this.updatedProperties : this.originalChange.getProperties(), this.updatedDescription != null ? this.updatedDescription : this.originalChange.getDescription(), this.originalChange.getPackageActions(), this.originalChange.getSourceControlUrl(), this.originalChange.getParameters());
        }
    }
}

