package io.contextmap.annotations.rest;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation used to document a REST API.
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ContextRestApi {

    /**
     * @return the name of the REST API
     */
    String name();

    /**
     * @return the description of the REST API (optional)
     */
    String description() default "";

}
