package io.contextmap.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * Annotation used to customize the documentation of a type.
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface ContextApi {

    /**
     * @return the description of a type
     */
    String description() default "";

    /**
     *
     * @return an example of a type
     */
    String example() default "";

}
