/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime;

import io.contextmap.spring.runtime.ScanAtStartup;
import io.contextmap.spring.runtime.http.Parameters;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ContextMapAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(ContextMapAutoConfiguration.class);
    @Value(value="${spring.application.name:}")
    private String appName;
    @Value(value="${contextmap.key:}")
    private String key;
    @Value(value="${contextmap.enabled:false}")
    private boolean scanningEnabled;

    @Bean
    public ScanAtStartup scanAtStartup(ApplicationContext applicationContext) {
        ScanApplicationContext scanContext = new ScanApplicationContext(applicationContext, this.getParameters(), this.appName);
        return new ScanAtStartup(scanContext);
    }

    private Parameters getParameters() {
        Parameters params = new Parameters();
        if (!this.scanningEnabled) {
            this.scanningEnabled = Boolean.getBoolean("contextmap.enabled");
        }
        params.setScanningEnabled(this.scanningEnabled);
        if (this.scanningEnabled) {
            if (this.key == null || this.key.isEmpty()) {
                try {
                    this.key = System.getProperty("contextmap.key");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.key == null || this.key.isEmpty()) {
                logger.error("Missing required \"contextmap.key\" configuration parameter");
            } else {
                params.setKey(this.key);
            }
        }
        return params;
    }
}

