/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.events.jms;

import io.contextmap.annotations.ContextEvent;
import io.contextmap.spring.runtime.model.Event;
import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.reflection.AnnotatedTypeScanner;
import io.contextmap.spring.runtime.reflection.AnnotationFunctions;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import io.contextmap.spring.runtime.scanner.events.EventFunctions;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.jms.Queue;
import javax.jms.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.listener.AbstractMessageListenerContainer;

public class ActiveMQJmsScanner
extends AbstractRuntimeScanner {
    private static Logger logger = LoggerFactory.getLogger(ActiveMQJmsScanner.class);
    private final ScanApplicationContext context;

    public ActiveMQJmsScanner(ScanApplicationContext context) {
        this.context = context;
    }

    @Override
    public void scan(Scan data) {
        Set<Event> subscribedEvents = this.getSubscribedQueues();
        data.setSubscribedEvents(subscribedEvents);
        data.getExecution().setScannedSubscribedEvents(true);
        Set<Event> publishedEvents = this.getPublishedQueues();
        data.setPublishedEvents(publishedEvents);
        data.getExecution().setScannedPublishedEvents(true);
    }

    private Set<Event> getSubscribedQueues() {
        HashSet queueNames = new HashSet();
        Map<String, ?> registries = this.context.getBeansOfType("org.springframework.jms.config.JmsListenerEndpointRegistry");
        if (registries.isEmpty()) {
            return Collections.emptySet();
        }
        for (Object registryObj : registries.values()) {
            JmsListenerEndpointRegistry registry = (JmsListenerEndpointRegistry)registryObj;
            registry.getListenerContainers().forEach(listenerContainer -> {
                if (listenerContainer instanceof AbstractMessageListenerContainer) {
                    AbstractMessageListenerContainer abCont = (AbstractMessageListenerContainer)listenerContainer;
                    queueNames.add(abCont.getDestinationName());
                }
            });
        }
        return queueNames.stream().map(Event::new).collect(Collectors.toSet());
    }

    private Set<Event> getPublishedQueues() {
        Set<String> queueNames = this.getDestinationNamesOfType("javax.jms.Queue", q -> {
            try {
                return Optional.ofNullable(((Queue)q).getQueueName());
            }
            catch (Exception e) {
                return Optional.empty();
            }
        });
        Set<String> topicNames = this.getDestinationNamesOfType("javax.jms.Topic", q -> {
            try {
                return Optional.ofNullable(((Queue)q).getQueueName());
            }
            catch (Exception e) {
                return Optional.empty();
            }
        });
        queueNames.addAll(topicNames);
        Map<String, Event> publishedEvents = queueNames.stream().map(Event::new).collect(Collectors.toMap(Event::getName, e -> e));
        AnnotatedTypeScanner contextEventScanner = new AnnotatedTypeScanner(ContextEvent.class);
        Set<Class<?>> typesAnnotatedWithContextEvent = contextEventScanner.findTypes(this.context.getComponentScanPackages());
        HashMap eventClassToPublishers = new HashMap();
        for (Class<?> eventClass : typesAnnotatedWithContextEvent) {
            Optional<Object> publishedByOptional;
            Optional<Annotation> annotation = AnnotationFunctions.getAnnotation(eventClass, ContextEvent.class.getName());
            if (!annotation.isPresent() || !(publishedByOptional = AnnotationFunctions.getAnnotationFieldValue(annotation.get(), "publishedBy")).isPresent()) continue;
            HashSet publishedByExchangeNames = new HashSet();
            eventClassToPublishers.put(eventClass, publishedByExchangeNames);
            String[] publishedBy = (String[])publishedByOptional.get();
            Arrays.stream(publishedBy).filter(Objects::nonNull).filter(n -> !n.isEmpty()).forEach(beanName -> {
                Optional<Object> optionalBean = this.context.getBeanByName((String)beanName);
                if (optionalBean.isPresent()) {
                    try {
                        Object bean = optionalBean.get();
                        String publishedByExchangeName = null;
                        if (bean instanceof Queue) {
                            publishedByExchangeName = ((Queue)bean).getQueueName();
                        } else if (bean instanceof Topic) {
                            publishedByExchangeName = ((Topic)bean).getTopicName();
                        } else {
                            logger.error("Unable to extract name of ContextEvent {} since the bean is not a Queueor Topc, but it's of type {}", (Object)eventClass, bean.getClass());
                        }
                        if (publishedByExchangeName != null && !publishedByExchangeName.isEmpty()) {
                            publishedByExchangeNames.add(publishedByExchangeName);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Unexpected error while scanning ActiveMQ");
                    }
                } else {
                    publishedByExchangeNames.add(beanName);
                }
            });
        }
        EventFunctions.addPayloadsToEvents(eventClassToPublishers, publishedEvents);
        return new HashSet<Event>(publishedEvents.values());
    }

    private Set<String> getDestinationNamesOfType(String fullyQualifiedName, Function<Object, Optional<String>> nameCaller) {
        HashSet<String> queueNames = new HashSet<String>();
        Map<String, ?> queues = this.context.getBeansOfType(fullyQualifiedName);
        if (queues.isEmpty()) {
            return Collections.emptySet();
        }
        queues.values().stream().forEach(q -> ((Optional)nameCaller.apply(q)).ifPresent(queueNames::add));
        return queueNames;
    }
}

