/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.tags;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.tags.requests.DeleteTagRequest;
import com.intercom.api.resources.tags.requests.FindTagRequest;
import com.intercom.api.resources.tags.requests.TagContactRequest;
import com.intercom.api.resources.tags.requests.TagConversationRequest;
import com.intercom.api.resources.tags.requests.TagTicketRequest;
import com.intercom.api.resources.tags.requests.UntagContactRequest;
import com.intercom.api.resources.tags.requests.UntagConversationRequest;
import com.intercom.api.resources.tags.requests.UntagTicketRequest;
import com.intercom.api.resources.tags.types.Tag;
import com.intercom.api.resources.tags.types.TagsCreateRequestBody;
import com.intercom.api.types.TagList;

public class TagsClient {
    protected final ClientOptions clientOptions;

    private final RawTagsClient rawClient;

    public TagsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawTagsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawTagsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can tag a specific contact. This will return a tag object for the tag that was added to the contact.
     */
    public Tag tagContact(TagContactRequest request) {
        return this.rawClient.tagContact(request).body();
    }

    /**
     * You can tag a specific contact. This will return a tag object for the tag that was added to the contact.
     */
    public Tag tagContact(TagContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.tagContact(request, requestOptions).body();
    }

    /**
     * You can remove tag from a specific contact. This will return a tag object for the tag that was removed from the contact.
     */
    public Tag untagContact(UntagContactRequest request) {
        return this.rawClient.untagContact(request).body();
    }

    /**
     * You can remove tag from a specific contact. This will return a tag object for the tag that was removed from the contact.
     */
    public Tag untagContact(UntagContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.untagContact(request, requestOptions).body();
    }

    /**
     * You can tag a specific conversation. This will return a tag object for the tag that was added to the conversation.
     */
    public Tag tagConversation(TagConversationRequest request) {
        return this.rawClient.tagConversation(request).body();
    }

    /**
     * You can tag a specific conversation. This will return a tag object for the tag that was added to the conversation.
     */
    public Tag tagConversation(TagConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.tagConversation(request, requestOptions).body();
    }

    /**
     * You can remove tag from a specific conversation. This will return a tag object for the tag that was removed from the conversation.
     */
    public Tag untagConversation(UntagConversationRequest request) {
        return this.rawClient.untagConversation(request).body();
    }

    /**
     * You can remove tag from a specific conversation. This will return a tag object for the tag that was removed from the conversation.
     */
    public Tag untagConversation(UntagConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.untagConversation(request, requestOptions).body();
    }

    /**
     * You can fetch a list of all tags for a given workspace.
     */
    public TagList list() {
        return this.rawClient.list().body();
    }

    /**
     * You can fetch a list of all tags for a given workspace.
     */
    public TagList list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).body();
    }

    /**
     * You can use this endpoint to perform the following operations:
     * <p><strong>1. Create a new tag:</strong> You can create a new tag by passing in the tag name as specified in &quot;Create or Update Tag Request Payload&quot; described below.</p>
     * <p><strong>2. Update an existing tag:</strong> You can update an existing tag by passing the id of the tag as specified in &quot;Create or Update Tag Request Payload&quot; described below.</p>
     * <p><strong>3. Tag Companies:</strong> You can tag single company or a list of companies. You can tag a company by passing in the tag name and the company details as specified in &quot;Tag Company Request Payload&quot; described below. Also, if the tag doesn't exist then a new one will be created automatically.</p>
     * <p><strong>4. Untag Companies:</strong> You can untag a single company or a list of companies. You can untag a company by passing in the tag id and the company details as specified in &quot;Untag Company Request Payload&quot; described below.</p>
     * <p><strong>5. Tag Multiple Users:</strong> You can tag a list of users. You can tag the users by passing in the tag name and the user details as specified in &quot;Tag Users Request Payload&quot; described below.</p>
     * <p>Each operation will return a tag object.</p>
     */
    public Tag create(TagsCreateRequestBody request) {
        return this.rawClient.create(request).body();
    }

    /**
     * You can use this endpoint to perform the following operations:
     * <p><strong>1. Create a new tag:</strong> You can create a new tag by passing in the tag name as specified in &quot;Create or Update Tag Request Payload&quot; described below.</p>
     * <p><strong>2. Update an existing tag:</strong> You can update an existing tag by passing the id of the tag as specified in &quot;Create or Update Tag Request Payload&quot; described below.</p>
     * <p><strong>3. Tag Companies:</strong> You can tag single company or a list of companies. You can tag a company by passing in the tag name and the company details as specified in &quot;Tag Company Request Payload&quot; described below. Also, if the tag doesn't exist then a new one will be created automatically.</p>
     * <p><strong>4. Untag Companies:</strong> You can untag a single company or a list of companies. You can untag a company by passing in the tag id and the company details as specified in &quot;Untag Company Request Payload&quot; described below.</p>
     * <p><strong>5. Tag Multiple Users:</strong> You can tag a list of users. You can tag the users by passing in the tag name and the user details as specified in &quot;Tag Users Request Payload&quot; described below.</p>
     * <p>Each operation will return a tag object.</p>
     */
    public Tag create(TagsCreateRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    /**
     * You can fetch the details of tags that are on the workspace by their id.
     * This will return a tag object.
     */
    public Tag find(FindTagRequest request) {
        return this.rawClient.find(request).body();
    }

    /**
     * You can fetch the details of tags that are on the workspace by their id.
     * This will return a tag object.
     */
    public Tag find(FindTagRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).body();
    }

    /**
     * You can delete the details of tags that are on the workspace by passing in the id.
     */
    public void delete(DeleteTagRequest request) {
        this.rawClient.delete(request).body();
    }

    /**
     * You can delete the details of tags that are on the workspace by passing in the id.
     */
    public void delete(DeleteTagRequest request, RequestOptions requestOptions) {
        this.rawClient.delete(request, requestOptions).body();
    }

    /**
     * You can tag a specific ticket. This will return a tag object for the tag that was added to the ticket.
     */
    public Tag tagTicket(TagTicketRequest request) {
        return this.rawClient.tagTicket(request).body();
    }

    /**
     * You can tag a specific ticket. This will return a tag object for the tag that was added to the ticket.
     */
    public Tag tagTicket(TagTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.tagTicket(request, requestOptions).body();
    }

    /**
     * You can remove tag from a specific ticket. This will return a tag object for the tag that was removed from the ticket.
     */
    public Tag untagTicket(UntagTicketRequest request) {
        return this.rawClient.untagTicket(request).body();
    }

    /**
     * You can remove tag from a specific ticket. This will return a tag object for the tag that was removed from the ticket.
     */
    public Tag untagTicket(UntagTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.untagTicket(request, requestOptions).body();
    }
}
