/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.tickets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TicketStateDetailed.Builder.class)
public final class TicketStateDetailed {
    private final Optional<String> type;

    private final Optional<String> id;

    private final Optional<Category> category;

    private final Optional<String> internalLabel;

    private final Optional<String> externalLabel;

    private final Optional<Boolean> archived;

    private final Optional<TicketTypes> ticketTypes;

    private final Map<String, Object> additionalProperties;

    private TicketStateDetailed(
            Optional<String> type,
            Optional<String> id,
            Optional<Category> category,
            Optional<String> internalLabel,
            Optional<String> externalLabel,
            Optional<Boolean> archived,
            Optional<TicketTypes> ticketTypes,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.category = category;
        this.internalLabel = internalLabel;
        this.externalLabel = externalLabel;
        this.archived = archived;
        this.ticketTypes = ticketTypes;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return String representing the object's type. Always has the value <code>ticket_state</code>.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The id of the ticket state
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return The category of the ticket state
     */
    @JsonProperty("category")
    public Optional<Category> getCategory() {
        return category;
    }

    /**
     * @return The state the ticket is currently in, in a human readable form - visible in Intercom
     */
    @JsonProperty("internal_label")
    public Optional<String> getInternalLabel() {
        return internalLabel;
    }

    /**
     * @return The state the ticket is currently in, in a human readable form - visible to customers, in the messenger, email and tickets portal.
     */
    @JsonProperty("external_label")
    public Optional<String> getExternalLabel() {
        return externalLabel;
    }

    /**
     * @return Whether the ticket state is archived
     */
    @JsonProperty("archived")
    public Optional<Boolean> getArchived() {
        return archived;
    }

    /**
     * @return A list of ticket types associated with a given ticket state.
     */
    @JsonProperty("ticket_types")
    public Optional<TicketTypes> getTicketTypes() {
        return ticketTypes;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TicketStateDetailed && equalTo((TicketStateDetailed) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketStateDetailed other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && category.equals(other.category)
                && internalLabel.equals(other.internalLabel)
                && externalLabel.equals(other.externalLabel)
                && archived.equals(other.archived)
                && ticketTypes.equals(other.ticketTypes);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.category,
                this.internalLabel,
                this.externalLabel,
                this.archived,
                this.ticketTypes);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<Category> category = Optional.empty();

        private Optional<String> internalLabel = Optional.empty();

        private Optional<String> externalLabel = Optional.empty();

        private Optional<Boolean> archived = Optional.empty();

        private Optional<TicketTypes> ticketTypes = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(TicketStateDetailed other) {
            type(other.getType());
            id(other.getId());
            category(other.getCategory());
            internalLabel(other.getInternalLabel());
            externalLabel(other.getExternalLabel());
            archived(other.getArchived());
            ticketTypes(other.getTicketTypes());
            return this;
        }

        /**
         * <p>String representing the object's type. Always has the value <code>ticket_state</code>.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The id of the ticket state</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The category of the ticket state</p>
         */
        @JsonSetter(value = "category", nulls = Nulls.SKIP)
        public Builder category(Optional<Category> category) {
            this.category = category;
            return this;
        }

        public Builder category(Category category) {
            this.category = Optional.ofNullable(category);
            return this;
        }

        /**
         * <p>The state the ticket is currently in, in a human readable form - visible in Intercom</p>
         */
        @JsonSetter(value = "internal_label", nulls = Nulls.SKIP)
        public Builder internalLabel(Optional<String> internalLabel) {
            this.internalLabel = internalLabel;
            return this;
        }

        public Builder internalLabel(String internalLabel) {
            this.internalLabel = Optional.ofNullable(internalLabel);
            return this;
        }

        /**
         * <p>The state the ticket is currently in, in a human readable form - visible to customers, in the messenger, email and tickets portal.</p>
         */
        @JsonSetter(value = "external_label", nulls = Nulls.SKIP)
        public Builder externalLabel(Optional<String> externalLabel) {
            this.externalLabel = externalLabel;
            return this;
        }

        public Builder externalLabel(String externalLabel) {
            this.externalLabel = Optional.ofNullable(externalLabel);
            return this;
        }

        /**
         * <p>Whether the ticket state is archived</p>
         */
        @JsonSetter(value = "archived", nulls = Nulls.SKIP)
        public Builder archived(Optional<Boolean> archived) {
            this.archived = archived;
            return this;
        }

        public Builder archived(Boolean archived) {
            this.archived = Optional.ofNullable(archived);
            return this;
        }

        /**
         * <p>A list of ticket types associated with a given ticket state.</p>
         */
        @JsonSetter(value = "ticket_types", nulls = Nulls.SKIP)
        public Builder ticketTypes(Optional<TicketTypes> ticketTypes) {
            this.ticketTypes = ticketTypes;
            return this;
        }

        public Builder ticketTypes(TicketTypes ticketTypes) {
            this.ticketTypes = Optional.ofNullable(ticketTypes);
            return this;
        }

        public TicketStateDetailed build() {
            return new TicketStateDetailed(
                    type, id, category, internalLabel, externalLabel, archived, ticketTypes, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = TicketTypes.Builder.class)
    public static final class TicketTypes {
        private final Optional<String> type;

        private final Optional<List<Optional<TicketType>>> data;

        private final Map<String, Object> additionalProperties;

        private TicketTypes(
                Optional<String> type,
                Optional<List<Optional<TicketType>>> data,
                Map<String, Object> additionalProperties) {
            this.type = type;
            this.data = data;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return String representing the object's type. Always has the value <code>list</code>.
         */
        @JsonProperty("type")
        public Optional<String> getType() {
            return type;
        }

        /**
         * @return A list of ticket type attributes associated with a given ticket type.
         */
        @JsonProperty("data")
        public Optional<List<Optional<TicketType>>> getData() {
            return data;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof TicketTypes && equalTo((TicketTypes) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(TicketTypes other) {
            return type.equals(other.type) && data.equals(other.data);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.data);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();

            private Optional<List<Optional<TicketType>>> data = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(TicketTypes other) {
                type(other.getType());
                data(other.getData());
                return this;
            }

            /**
             * <p>String representing the object's type. Always has the value <code>list</code>.</p>
             */
            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            /**
             * <p>A list of ticket type attributes associated with a given ticket type.</p>
             */
            @JsonSetter(value = "data", nulls = Nulls.SKIP)
            public Builder data(Optional<List<Optional<TicketType>>> data) {
                this.data = data;
                return this;
            }

            public Builder data(List<Optional<TicketType>> data) {
                this.data = Optional.ofNullable(data);
                return this;
            }

            public TicketTypes build() {
                return new TicketTypes(type, data, additionalProperties);
            }
        }
    }

    public static final class Category {
        public static final Category IN_PROGRESS = new Category(Value.IN_PROGRESS, "in_progress");

        public static final Category SUBMITTED = new Category(Value.SUBMITTED, "submitted");

        public static final Category RESOLVED = new Category(Value.RESOLVED, "resolved");

        public static final Category WAITING_ON_CUSTOMER =
                new Category(Value.WAITING_ON_CUSTOMER, "waiting_on_customer");

        private final Value value;

        private final String string;

        Category(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Category && this.string.equals(((Category) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case IN_PROGRESS:
                    return visitor.visitInProgress();
                case SUBMITTED:
                    return visitor.visitSubmitted();
                case RESOLVED:
                    return visitor.visitResolved();
                case WAITING_ON_CUSTOMER:
                    return visitor.visitWaitingOnCustomer();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Category valueOf(String value) {
            switch (value) {
                case "in_progress":
                    return IN_PROGRESS;
                case "submitted":
                    return SUBMITTED;
                case "resolved":
                    return RESOLVED;
                case "waiting_on_customer":
                    return WAITING_ON_CUSTOMER;
                default:
                    return new Category(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            SUBMITTED,

            IN_PROGRESS,

            WAITING_ON_CUSTOMER,

            RESOLVED,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitSubmitted();

            T visitInProgress();

            T visitWaitingOnCustomer();

            T visitResolved();

            T visitUnknown(String unknownType);
        }
    }
}
