/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.tags.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AttachTagToContactRequest.Builder.class)
public final class AttachTagToContactRequest {
    private final String contactId;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private AttachTagToContactRequest(String contactId, String id, Map<String, Object> additionalProperties) {
        this.contactId = contactId;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the contact which is given by Intercom
     */
    @JsonProperty("contact_id")
    public String getContactId() {
        return contactId;
    }

    /**
     * @return The unique identifier for the tag which is given by Intercom
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AttachTagToContactRequest && equalTo((AttachTagToContactRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AttachTagToContactRequest other) {
        return contactId.equals(other.contactId) && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.contactId, this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ContactIdStage builder() {
        return new Builder();
    }

    public interface ContactIdStage {
        /**
         * <p>The unique identifier for the contact which is given by Intercom</p>
         */
        IdStage contactId(@NotNull String contactId);

        Builder from(AttachTagToContactRequest other);
    }

    public interface IdStage {
        /**
         * <p>The unique identifier for the tag which is given by Intercom</p>
         */
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        AttachTagToContactRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ContactIdStage, IdStage, _FinalStage {
        private String contactId;

        private String id;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(AttachTagToContactRequest other) {
            contactId(other.getContactId());
            id(other.getId());
            return this;
        }

        /**
         * <p>The unique identifier for the contact which is given by Intercom</p>
         * <p>The unique identifier for the contact which is given by Intercom</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("contact_id")
        public IdStage contactId(@NotNull String contactId) {
            this.contactId = Objects.requireNonNull(contactId, "contactId must not be null");
            return this;
        }

        /**
         * <p>The unique identifier for the tag which is given by Intercom</p>
         * <p>The unique identifier for the tag which is given by Intercom</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public AttachTagToContactRequest build() {
            return new AttachTagToContactRequest(contactId, id, additionalProperties);
        }
    }
}
