/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.companies.types.Company;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ContactAttachedCompanies.Builder.class)
public final class ContactAttachedCompanies {
    private final Optional<String> type;

    private final Optional<List<Company>> companies;

    private final Optional<Integer> totalCount;

    private final Optional<PagesLink> pages;

    private final Map<String, Object> additionalProperties;

    private ContactAttachedCompanies(
            Optional<String> type,
            Optional<List<Company>> companies,
            Optional<Integer> totalCount,
            Optional<PagesLink> pages,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.companies = companies;
        this.totalCount = totalCount;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return An array containing Company Objects
     */
    @JsonProperty("companies")
    public Optional<List<Company>> getCompanies() {
        return companies;
    }

    /**
     * @return The total number of companies associated to this contact
     */
    @JsonProperty("total_count")
    public Optional<Integer> getTotalCount() {
        return totalCount;
    }

    @JsonProperty("pages")
    public Optional<PagesLink> getPages() {
        return pages;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ContactAttachedCompanies && equalTo((ContactAttachedCompanies) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactAttachedCompanies other) {
        return type.equals(other.type)
                && companies.equals(other.companies)
                && totalCount.equals(other.totalCount)
                && pages.equals(other.pages);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.companies, this.totalCount, this.pages);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<List<Company>> companies = Optional.empty();

        private Optional<Integer> totalCount = Optional.empty();

        private Optional<PagesLink> pages = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ContactAttachedCompanies other) {
            type(other.getType());
            companies(other.getCompanies());
            totalCount(other.getTotalCount());
            pages(other.getPages());
            return this;
        }

        /**
         * <p>The type of object</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>An array containing Company Objects</p>
         */
        @JsonSetter(value = "companies", nulls = Nulls.SKIP)
        public Builder companies(Optional<List<Company>> companies) {
            this.companies = companies;
            return this;
        }

        public Builder companies(List<Company> companies) {
            this.companies = Optional.ofNullable(companies);
            return this;
        }

        /**
         * <p>The total number of companies associated to this contact</p>
         */
        @JsonSetter(value = "total_count", nulls = Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        @JsonSetter(value = "pages", nulls = Nulls.SKIP)
        public Builder pages(Optional<PagesLink> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(PagesLink pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        public ContactAttachedCompanies build() {
            return new ContactAttachedCompanies(type, companies, totalCount, pages, additionalProperties);
        }
    }
}
