/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonDeserialize(using = CreateDataEventRequest.Deserializer.class)
public final class CreateDataEventRequest {
    private final Object value;

    private final int type;

    private CreateDataEventRequest(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    @SuppressWarnings("unchecked")
    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((WithId) this.value);
        } else if (this.type == 1) {
            return visitor.visit((WithUserId) this.value);
        } else if (this.type == 2) {
            return visitor.visit((WithEmail) this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateDataEventRequest && equalTo((CreateDataEventRequest) other);
    }

    private boolean equalTo(CreateDataEventRequest other) {
        return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
        return this.value.toString();
    }

    public static CreateDataEventRequest of(WithId value) {
        return new CreateDataEventRequest(value, 0);
    }

    public static CreateDataEventRequest of(WithUserId value) {
        return new CreateDataEventRequest(value, 1);
    }

    public static CreateDataEventRequest of(WithEmail value) {
        return new CreateDataEventRequest(value, 2);
    }

    public interface Visitor<T> {
        T visit(WithId value);

        T visit(WithUserId value);

        T visit(WithEmail value);
    }

    static final class Deserializer extends StdDeserializer<CreateDataEventRequest> {
        Deserializer() {
            super(CreateDataEventRequest.class);
        }

        @java.lang.Override
        public CreateDataEventRequest deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, WithId.class));
            } catch (RuntimeException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, WithUserId.class));
            } catch (RuntimeException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, WithEmail.class));
            } catch (RuntimeException e) {
            }
            throw new JsonParseException(p, "Failed to deserialize");
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = WithUserId.Builder.class)
    public static final class WithUserId {
        private final String userId;

        private final String eventName;

        private final int createdAt;

        private final Optional<Map<String, String>> metadata;

        private final Map<String, Object> additionalProperties;

        private WithUserId(
                String userId,
                String eventName,
                int createdAt,
                Optional<Map<String, String>> metadata,
                Map<String, Object> additionalProperties) {
            this.userId = userId;
            this.eventName = eventName;
            this.createdAt = createdAt;
            this.metadata = metadata;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return Your identifier for the user.
         */
        @JsonProperty("user_id")
        public String getUserId() {
            return userId;
        }

        /**
         * @return The name of the event that occurred. This is presented to your App's admins when filtering and creating segments - a good event name is typically a past tense 'verb-noun' combination, to improve readability, for example <code>updated-plan</code>.
         */
        @JsonProperty("event_name")
        public String getEventName() {
            return eventName;
        }

        /**
         * @return The time the event occurred as a UTC Unix timestamp
         */
        @JsonProperty("created_at")
        public int getCreatedAt() {
            return createdAt;
        }

        /**
         * @return Optional metadata about the event.
         */
        @JsonProperty("metadata")
        public Optional<Map<String, String>> getMetadata() {
            return metadata;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof WithUserId && equalTo((WithUserId) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(WithUserId other) {
            return userId.equals(other.userId)
                    && eventName.equals(other.eventName)
                    && createdAt == other.createdAt
                    && metadata.equals(other.metadata);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.userId, this.eventName, this.createdAt, this.metadata);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static UserIdStage builder() {
            return new Builder();
        }

        public interface UserIdStage {
            /**
             * <p>Your identifier for the user.</p>
             */
            EventNameStage userId(@NotNull String userId);

            Builder from(WithUserId other);
        }

        public interface EventNameStage {
            /**
             * <p>The name of the event that occurred. This is presented to your App's admins when filtering and creating segments - a good event name is typically a past tense 'verb-noun' combination, to improve readability, for example <code>updated-plan</code>.</p>
             */
            CreatedAtStage eventName(@NotNull String eventName);
        }

        public interface CreatedAtStage {
            /**
             * <p>The time the event occurred as a UTC Unix timestamp</p>
             */
            _FinalStage createdAt(int createdAt);
        }

        public interface _FinalStage {
            WithUserId build();

            /**
             * <p>Optional metadata about the event.</p>
             */
            _FinalStage metadata(Optional<Map<String, String>> metadata);

            _FinalStage metadata(Map<String, String> metadata);
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements UserIdStage, EventNameStage, CreatedAtStage, _FinalStage {
            private String userId;

            private String eventName;

            private int createdAt;

            private Optional<Map<String, String>> metadata = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(WithUserId other) {
                userId(other.getUserId());
                eventName(other.getEventName());
                createdAt(other.getCreatedAt());
                metadata(other.getMetadata());
                return this;
            }

            /**
             * <p>Your identifier for the user.</p>
             * <p>Your identifier for the user.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("user_id")
            public EventNameStage userId(@NotNull String userId) {
                this.userId = Objects.requireNonNull(userId, "userId must not be null");
                return this;
            }

            /**
             * <p>The name of the event that occurred. This is presented to your App's admins when filtering and creating segments - a good event name is typically a past tense 'verb-noun' combination, to improve readability, for example <code>updated-plan</code>.</p>
             * <p>The name of the event that occurred. This is presented to your App's admins when filtering and creating segments - a good event name is typically a past tense 'verb-noun' combination, to improve readability, for example <code>updated-plan</code>.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("event_name")
            public CreatedAtStage eventName(@NotNull String eventName) {
                this.eventName = Objects.requireNonNull(eventName, "eventName must not be null");
                return this;
            }

            /**
             * <p>The time the event occurred as a UTC Unix timestamp</p>
             * <p>The time the event occurred as a UTC Unix timestamp</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("created_at")
            public _FinalStage createdAt(int createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            /**
             * <p>Optional metadata about the event.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage metadata(Map<String, String> metadata) {
                this.metadata = Optional.ofNullable(metadata);
                return this;
            }

            /**
             * <p>Optional metadata about the event.</p>
             */
            @java.lang.Override
            @JsonSetter(value = "metadata", nulls = Nulls.SKIP)
            public _FinalStage metadata(Optional<Map<String, String>> metadata) {
                this.metadata = metadata;
                return this;
            }

            @java.lang.Override
            public WithUserId build() {
                return new WithUserId(userId, eventName, createdAt, metadata, additionalProperties);
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = WithEmail.Builder.class)
    public static final class WithEmail {
        private final String email;

        private final String eventName;

        private final int createdAt;

        private final Optional<Map<String, String>> metadata;

        private final Map<String, Object> additionalProperties;

        private WithEmail(
                String email,
                String eventName,
                int createdAt,
                Optional<Map<String, String>> metadata,
                Map<String, Object> additionalProperties) {
            this.email = email;
            this.eventName = eventName;
            this.createdAt = createdAt;
            this.metadata = metadata;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return An email address for your user. An email should only be used where your application uses email to uniquely identify users.
         */
        @JsonProperty("email")
        public String getEmail() {
            return email;
        }

        /**
         * @return The name of the event that occurred. This is presented to your App's admins when filtering and creating segments - a good event name is typically a past tense 'verb-noun' combination, to improve readability, for example <code>updated-plan</code>.
         */
        @JsonProperty("event_name")
        public String getEventName() {
            return eventName;
        }

        /**
         * @return The time the event occurred as a UTC Unix timestamp
         */
        @JsonProperty("created_at")
        public int getCreatedAt() {
            return createdAt;
        }

        /**
         * @return Optional metadata about the event.
         */
        @JsonProperty("metadata")
        public Optional<Map<String, String>> getMetadata() {
            return metadata;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof WithEmail && equalTo((WithEmail) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(WithEmail other) {
            return email.equals(other.email)
                    && eventName.equals(other.eventName)
                    && createdAt == other.createdAt
                    && metadata.equals(other.metadata);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.email, this.eventName, this.createdAt, this.metadata);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static EmailStage builder() {
            return new Builder();
        }

        public interface EmailStage {
            /**
             * <p>An email address for your user. An email should only be used where your application uses email to uniquely identify users.</p>
             */
            EventNameStage email(@NotNull String email);

            Builder from(WithEmail other);
        }

        public interface EventNameStage {
            /**
             * <p>The name of the event that occurred. This is presented to your App's admins when filtering and creating segments - a good event name is typically a past tense 'verb-noun' combination, to improve readability, for example <code>updated-plan</code>.</p>
             */
            CreatedAtStage eventName(@NotNull String eventName);
        }

        public interface CreatedAtStage {
            /**
             * <p>The time the event occurred as a UTC Unix timestamp</p>
             */
            _FinalStage createdAt(int createdAt);
        }

        public interface _FinalStage {
            WithEmail build();

            /**
             * <p>Optional metadata about the event.</p>
             */
            _FinalStage metadata(Optional<Map<String, String>> metadata);

            _FinalStage metadata(Map<String, String> metadata);
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements EmailStage, EventNameStage, CreatedAtStage, _FinalStage {
            private String email;

            private String eventName;

            private int createdAt;

            private Optional<Map<String, String>> metadata = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(WithEmail other) {
                email(other.getEmail());
                eventName(other.getEventName());
                createdAt(other.getCreatedAt());
                metadata(other.getMetadata());
                return this;
            }

            /**
             * <p>An email address for your user. An email should only be used where your application uses email to uniquely identify users.</p>
             * <p>An email address for your user. An email should only be used where your application uses email to uniquely identify users.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("email")
            public EventNameStage email(@NotNull String email) {
                this.email = Objects.requireNonNull(email, "email must not be null");
                return this;
            }

            /**
             * <p>The name of the event that occurred. This is presented to your App's admins when filtering and creating segments - a good event name is typically a past tense 'verb-noun' combination, to improve readability, for example <code>updated-plan</code>.</p>
             * <p>The name of the event that occurred. This is presented to your App's admins when filtering and creating segments - a good event name is typically a past tense 'verb-noun' combination, to improve readability, for example <code>updated-plan</code>.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("event_name")
            public CreatedAtStage eventName(@NotNull String eventName) {
                this.eventName = Objects.requireNonNull(eventName, "eventName must not be null");
                return this;
            }

            /**
             * <p>The time the event occurred as a UTC Unix timestamp</p>
             * <p>The time the event occurred as a UTC Unix timestamp</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("created_at")
            public _FinalStage createdAt(int createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            /**
             * <p>Optional metadata about the event.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage metadata(Map<String, String> metadata) {
                this.metadata = Optional.ofNullable(metadata);
                return this;
            }

            /**
             * <p>Optional metadata about the event.</p>
             */
            @java.lang.Override
            @JsonSetter(value = "metadata", nulls = Nulls.SKIP)
            public _FinalStage metadata(Optional<Map<String, String>> metadata) {
                this.metadata = metadata;
                return this;
            }

            @java.lang.Override
            public WithEmail build() {
                return new WithEmail(email, eventName, createdAt, metadata, additionalProperties);
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = WithId.Builder.class)
    public static final class WithId {
        private final String id;

        private final String eventName;

        private final int createdAt;

        private final Optional<Map<String, String>> metadata;

        private final Map<String, Object> additionalProperties;

        private WithId(
                String id,
                String eventName,
                int createdAt,
                Optional<Map<String, String>> metadata,
                Map<String, Object> additionalProperties) {
            this.id = id;
            this.eventName = eventName;
            this.createdAt = createdAt;
            this.metadata = metadata;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The unique identifier for the contact (lead or user) which is given by Intercom.
         */
        @JsonProperty("id")
        public String getId() {
            return id;
        }

        /**
         * @return The name of the event that occurred. This is presented to your App's admins when filtering and creating segments - a good event name is typically a past tense 'verb-noun' combination, to improve readability, for example <code>updated-plan</code>.
         */
        @JsonProperty("event_name")
        public String getEventName() {
            return eventName;
        }

        /**
         * @return The time the event occurred as a UTC Unix timestamp
         */
        @JsonProperty("created_at")
        public int getCreatedAt() {
            return createdAt;
        }

        /**
         * @return Optional metadata about the event.
         */
        @JsonProperty("metadata")
        public Optional<Map<String, String>> getMetadata() {
            return metadata;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof WithId && equalTo((WithId) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(WithId other) {
            return id.equals(other.id)
                    && eventName.equals(other.eventName)
                    && createdAt == other.createdAt
                    && metadata.equals(other.metadata);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.id, this.eventName, this.createdAt, this.metadata);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static IdStage builder() {
            return new Builder();
        }

        public interface IdStage {
            /**
             * <p>The unique identifier for the contact (lead or user) which is given by Intercom.</p>
             */
            EventNameStage id(@NotNull String id);

            Builder from(WithId other);
        }

        public interface EventNameStage {
            /**
             * <p>The name of the event that occurred. This is presented to your App's admins when filtering and creating segments - a good event name is typically a past tense 'verb-noun' combination, to improve readability, for example <code>updated-plan</code>.</p>
             */
            CreatedAtStage eventName(@NotNull String eventName);
        }

        public interface CreatedAtStage {
            /**
             * <p>The time the event occurred as a UTC Unix timestamp</p>
             */
            _FinalStage createdAt(int createdAt);
        }

        public interface _FinalStage {
            WithId build();

            /**
             * <p>Optional metadata about the event.</p>
             */
            _FinalStage metadata(Optional<Map<String, String>> metadata);

            _FinalStage metadata(Map<String, String> metadata);
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements IdStage, EventNameStage, CreatedAtStage, _FinalStage {
            private String id;

            private String eventName;

            private int createdAt;

            private Optional<Map<String, String>> metadata = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(WithId other) {
                id(other.getId());
                eventName(other.getEventName());
                createdAt(other.getCreatedAt());
                metadata(other.getMetadata());
                return this;
            }

            /**
             * <p>The unique identifier for the contact (lead or user) which is given by Intercom.</p>
             * <p>The unique identifier for the contact (lead or user) which is given by Intercom.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("id")
            public EventNameStage id(@NotNull String id) {
                this.id = Objects.requireNonNull(id, "id must not be null");
                return this;
            }

            /**
             * <p>The name of the event that occurred. This is presented to your App's admins when filtering and creating segments - a good event name is typically a past tense 'verb-noun' combination, to improve readability, for example <code>updated-plan</code>.</p>
             * <p>The name of the event that occurred. This is presented to your App's admins when filtering and creating segments - a good event name is typically a past tense 'verb-noun' combination, to improve readability, for example <code>updated-plan</code>.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("event_name")
            public CreatedAtStage eventName(@NotNull String eventName) {
                this.eventName = Objects.requireNonNull(eventName, "eventName must not be null");
                return this;
            }

            /**
             * <p>The time the event occurred as a UTC Unix timestamp</p>
             * <p>The time the event occurred as a UTC Unix timestamp</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("created_at")
            public _FinalStage createdAt(int createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            /**
             * <p>Optional metadata about the event.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage metadata(Map<String, String> metadata) {
                this.metadata = Optional.ofNullable(metadata);
                return this;
            }

            /**
             * <p>Optional metadata about the event.</p>
             */
            @java.lang.Override
            @JsonSetter(value = "metadata", nulls = Nulls.SKIP)
            public _FinalStage metadata(Optional<Map<String, String>> metadata) {
                this.metadata = metadata;
                return this;
            }

            @java.lang.Override
            public WithId build() {
                return new WithId(id, eventName, createdAt, metadata, additionalProperties);
            }
        }
    }
}
