/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.dataexport.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DownloadReportingDataExportRequest {
    private final String jobIdentifier;
    private final String appId;
    private final Map<String, Object> additionalProperties;

    private DownloadReportingDataExportRequest(String jobIdentifier, String appId, Map<String, Object> additionalProperties) {
        this.jobIdentifier = jobIdentifier;
        this.appId = appId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="job_identifier")
    public String getJobIdentifier() {
        return this.jobIdentifier;
    }

    @JsonIgnore
    public String getAccept() {
        return "application/octet-stream";
    }

    @JsonProperty(value="app_id")
    public String getAppId() {
        return this.appId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DownloadReportingDataExportRequest && this.equalTo((DownloadReportingDataExportRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DownloadReportingDataExportRequest other) {
        return this.jobIdentifier.equals(other.jobIdentifier) && this.appId.equals(other.appId);
    }

    public int hashCode() {
        return Objects.hash(this.jobIdentifier, this.appId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static JobIdentifierStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements JobIdentifierStage,
    AppIdStage,
    _FinalStage {
        private String jobIdentifier;
        private String appId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DownloadReportingDataExportRequest other) {
            this.jobIdentifier(other.getJobIdentifier());
            this.appId(other.getAppId());
            return this;
        }

        @Override
        @JsonSetter(value="job_identifier")
        public AppIdStage jobIdentifier(@NotNull String jobIdentifier) {
            this.jobIdentifier = Objects.requireNonNull(jobIdentifier, "jobIdentifier must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="app_id")
        public _FinalStage appId(@NotNull String appId) {
            this.appId = Objects.requireNonNull(appId, "appId must not be null");
            return this;
        }

        @Override
        public DownloadReportingDataExportRequest build() {
            return new DownloadReportingDataExportRequest(this.jobIdentifier, this.appId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DownloadReportingDataExportRequest build();
    }

    public static interface AppIdStage {
        public _FinalStage appId(@NotNull String var1);
    }

    public static interface JobIdentifierStage {
        public AppIdStage jobIdentifier(@NotNull String var1);

        public Builder from(DownloadReportingDataExportRequest var1);
    }
}

