/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ArticleStatistics {
    private final Optional<String> type;
    private final Optional<Integer> views;
    private final Optional<Integer> conversions;
    private final Optional<Integer> reactions;
    private final Optional<Float> happyReactionPercentage;
    private final Optional<Float> neutralReactionPercentage;
    private final Optional<Float> sadReactionPercentage;
    private final Map<String, Object> additionalProperties;

    private ArticleStatistics(Optional<String> type, Optional<Integer> views, Optional<Integer> conversions, Optional<Integer> reactions, Optional<Float> happyReactionPercentage, Optional<Float> neutralReactionPercentage, Optional<Float> sadReactionPercentage, Map<String, Object> additionalProperties) {
        this.type = type;
        this.views = views;
        this.conversions = conversions;
        this.reactions = reactions;
        this.happyReactionPercentage = happyReactionPercentage;
        this.neutralReactionPercentage = neutralReactionPercentage;
        this.sadReactionPercentage = sadReactionPercentage;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="views")
    public Optional<Integer> getViews() {
        return this.views;
    }

    @JsonProperty(value="conversions")
    public Optional<Integer> getConversions() {
        return this.conversions;
    }

    @JsonProperty(value="reactions")
    public Optional<Integer> getReactions() {
        return this.reactions;
    }

    @JsonProperty(value="happy_reaction_percentage")
    public Optional<Float> getHappyReactionPercentage() {
        return this.happyReactionPercentage;
    }

    @JsonProperty(value="neutral_reaction_percentage")
    public Optional<Float> getNeutralReactionPercentage() {
        return this.neutralReactionPercentage;
    }

    @JsonProperty(value="sad_reaction_percentage")
    public Optional<Float> getSadReactionPercentage() {
        return this.sadReactionPercentage;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ArticleStatistics && this.equalTo((ArticleStatistics)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ArticleStatistics other) {
        return this.type.equals(other.type) && this.views.equals(other.views) && this.conversions.equals(other.conversions) && this.reactions.equals(other.reactions) && this.happyReactionPercentage.equals(other.happyReactionPercentage) && this.neutralReactionPercentage.equals(other.neutralReactionPercentage) && this.sadReactionPercentage.equals(other.sadReactionPercentage);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.views, this.conversions, this.reactions, this.happyReactionPercentage, this.neutralReactionPercentage, this.sadReactionPercentage);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<Integer> views = Optional.empty();
        private Optional<Integer> conversions = Optional.empty();
        private Optional<Integer> reactions = Optional.empty();
        private Optional<Float> happyReactionPercentage = Optional.empty();
        private Optional<Float> neutralReactionPercentage = Optional.empty();
        private Optional<Float> sadReactionPercentage = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ArticleStatistics other) {
            this.type(other.getType());
            this.views(other.getViews());
            this.conversions(other.getConversions());
            this.reactions(other.getReactions());
            this.happyReactionPercentage(other.getHappyReactionPercentage());
            this.neutralReactionPercentage(other.getNeutralReactionPercentage());
            this.sadReactionPercentage(other.getSadReactionPercentage());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="views", nulls=Nulls.SKIP)
        public Builder views(Optional<Integer> views) {
            this.views = views;
            return this;
        }

        public Builder views(Integer views) {
            this.views = Optional.ofNullable(views);
            return this;
        }

        @JsonSetter(value="conversions", nulls=Nulls.SKIP)
        public Builder conversions(Optional<Integer> conversions) {
            this.conversions = conversions;
            return this;
        }

        public Builder conversions(Integer conversions) {
            this.conversions = Optional.ofNullable(conversions);
            return this;
        }

        @JsonSetter(value="reactions", nulls=Nulls.SKIP)
        public Builder reactions(Optional<Integer> reactions) {
            this.reactions = reactions;
            return this;
        }

        public Builder reactions(Integer reactions) {
            this.reactions = Optional.ofNullable(reactions);
            return this;
        }

        @JsonSetter(value="happy_reaction_percentage", nulls=Nulls.SKIP)
        public Builder happyReactionPercentage(Optional<Float> happyReactionPercentage) {
            this.happyReactionPercentage = happyReactionPercentage;
            return this;
        }

        public Builder happyReactionPercentage(Float happyReactionPercentage) {
            this.happyReactionPercentage = Optional.ofNullable(happyReactionPercentage);
            return this;
        }

        @JsonSetter(value="neutral_reaction_percentage", nulls=Nulls.SKIP)
        public Builder neutralReactionPercentage(Optional<Float> neutralReactionPercentage) {
            this.neutralReactionPercentage = neutralReactionPercentage;
            return this;
        }

        public Builder neutralReactionPercentage(Float neutralReactionPercentage) {
            this.neutralReactionPercentage = Optional.ofNullable(neutralReactionPercentage);
            return this;
        }

        @JsonSetter(value="sad_reaction_percentage", nulls=Nulls.SKIP)
        public Builder sadReactionPercentage(Optional<Float> sadReactionPercentage) {
            this.sadReactionPercentage = sadReactionPercentage;
            return this;
        }

        public Builder sadReactionPercentage(Float sadReactionPercentage) {
            this.sadReactionPercentage = Optional.ofNullable(sadReactionPercentage);
            return this;
        }

        public ArticleStatistics build() {
            return new ArticleStatistics(this.type, this.views, this.conversions, this.reactions, this.happyReactionPercentage, this.neutralReactionPercentage, this.sadReactionPercentage, this.additionalProperties);
        }
    }
}

