/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.segments.types.Segment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SegmentList {
    private final Optional<String> type;
    private final Optional<List<Segment>> segments;
    private final Optional<Map<String, Object>> pages;
    private final Map<String, Object> additionalProperties;

    private SegmentList(Optional<String> type, Optional<List<Segment>> segments, Optional<Map<String, Object>> pages, Map<String, Object> additionalProperties) {
        this.type = type;
        this.segments = segments;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="segments")
    public Optional<List<Segment>> getSegments() {
        return this.segments;
    }

    @JsonProperty(value="pages")
    public Optional<Map<String, Object>> getPages() {
        return this.pages;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SegmentList && this.equalTo((SegmentList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SegmentList other) {
        return this.type.equals(other.type) && this.segments.equals(other.segments) && this.pages.equals(other.pages);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.segments, this.pages);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<List<Segment>> segments = Optional.empty();
        private Optional<Map<String, Object>> pages = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SegmentList other) {
            this.type(other.getType());
            this.segments(other.getSegments());
            this.pages(other.getPages());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="segments", nulls=Nulls.SKIP)
        public Builder segments(Optional<List<Segment>> segments) {
            this.segments = segments;
            return this;
        }

        public Builder segments(List<Segment> segments) {
            this.segments = Optional.ofNullable(segments);
            return this;
        }

        @JsonSetter(value="pages", nulls=Nulls.SKIP)
        public Builder pages(Optional<Map<String, Object>> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(Map<String, Object> pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        public SegmentList build() {
            return new SegmentList(this.type, this.segments, this.pages, this.additionalProperties);
        }
    }
}

