/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.split.client.LocalhostSplitFactory;
import io.split.client.SplitClient;
import io.split.client.api.Key;
import java.util.Map;

public final class LocalhostSplitClient
implements SplitClient {
    private LocalhostSplitFactory _container;
    private ImmutableMap<String, String> _featureToTreatmentMap;

    public LocalhostSplitClient(LocalhostSplitFactory container, Map<String, String> featureToTreatmentMap) {
        Preconditions.checkNotNull(featureToTreatmentMap, (Object)"featureToTreatmentMap must not be null");
        this._featureToTreatmentMap = ImmutableMap.copyOf(featureToTreatmentMap);
        this._container = container;
    }

    @Override
    public String getTreatment(String key, String split) {
        if (key == null || split == null) {
            return "control";
        }
        String treatment = (String)this._featureToTreatmentMap.get((Object)split);
        if (treatment == null) {
            return "control";
        }
        return treatment;
    }

    @Override
    public String getTreatment(String key, String split, Map<String, Object> attributes) {
        return this.getTreatment(key, split);
    }

    @Override
    public String getTreatment(Key key, String split, Map<String, Object> attributes) {
        return this.getTreatment(key.matchingKey(), split, attributes);
    }

    @Override
    public void destroy() {
        this._container.destroy();
    }

    @Override
    public boolean track(String key, String trafficType, String eventType) {
        return false;
    }

    @Override
    public boolean track(String key, String trafficType, String eventType, double value) {
        return false;
    }

    void updateFeatureToTreatmentMap(Map<String, String> featureToTreatmentMap) {
        Preconditions.checkNotNull(featureToTreatmentMap, (Object)"featureToTreatmentMap must not be null");
        this._featureToTreatmentMap = ImmutableMap.copyOf(featureToTreatmentMap);
    }

    @VisibleForTesting
    ImmutableMap<String, String> featureToTreatmentMap() {
        return this._featureToTreatmentMap;
    }
}

