/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.behaviors.sensor;

import org.scijava.java3d.Appearance;
import org.scijava.java3d.Geometry;
import org.scijava.java3d.Material;
import org.scijava.java3d.Shape3D;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransparencyAttributes;
import org.scijava.java3d.TriangleArray;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Tuple3f;
import org.scijava.vecmath.Vector3f;

public class SensorGnomonEcho
extends Shape3D {
    public SensorGnomonEcho(Transform3D transform, double baseWidth, double axisLength, boolean enableLighting) {
        int vertexFormat;
        int FRONT = 0;
        int BACK = 1;
        int LEFT = 2;
        int RIGHT = 3;
        int TOP = 4;
        int BOTTOM = 5;
        Point3f[] axes = new Point3f[6];
        float length = (float)axisLength;
        axes[FRONT] = new Point3f(0.0f, 0.0f, length);
        axes[BACK] = new Point3f(0.0f, 0.0f, -length);
        axes[LEFT] = new Point3f(-length, 0.0f, 0.0f);
        axes[RIGHT] = new Point3f(length, 0.0f, 0.0f);
        axes[TOP] = new Point3f(0.0f, length, 0.0f);
        axes[BOTTOM] = new Point3f(0.0f, -length, 0.0f);
        if (transform != null) {
            for (int i = FRONT; i <= BOTTOM; ++i) {
                transform.transform(axes[i]);
            }
        }
        float offset = (float)baseWidth / 2.0f;
        Point3f[][] cube = new Point3f[6][4];
        cube[FRONT][0] = new Point3f(-offset, -offset, offset);
        cube[FRONT][1] = new Point3f(offset, -offset, offset);
        cube[FRONT][2] = new Point3f(offset, offset, offset);
        cube[FRONT][3] = new Point3f(-offset, offset, offset);
        cube[BACK][0] = new Point3f(offset, -offset, -offset);
        cube[BACK][1] = new Point3f(-offset, -offset, -offset);
        cube[BACK][2] = new Point3f(-offset, offset, -offset);
        cube[BACK][3] = new Point3f(offset, offset, -offset);
        if (transform != null) {
            for (int i = FRONT; i <= BACK; ++i) {
                for (int j = 0; j < 4; ++j) {
                    transform.transform(cube[i][j]);
                }
            }
        }
        cube[LEFT][0] = cube[BACK][1];
        cube[LEFT][1] = cube[FRONT][0];
        cube[LEFT][2] = cube[FRONT][3];
        cube[LEFT][3] = cube[BACK][2];
        cube[RIGHT][0] = cube[FRONT][1];
        cube[RIGHT][1] = cube[BACK][0];
        cube[RIGHT][2] = cube[BACK][3];
        cube[RIGHT][3] = cube[FRONT][2];
        cube[TOP][0] = cube[FRONT][3];
        cube[TOP][1] = cube[FRONT][2];
        cube[TOP][2] = cube[BACK][3];
        cube[TOP][3] = cube[BACK][2];
        cube[BOTTOM][0] = cube[BACK][1];
        cube[BOTTOM][1] = cube[BACK][0];
        cube[BOTTOM][2] = cube[FRONT][1];
        cube[BOTTOM][3] = cube[FRONT][0];
        int v = 0;
        Point3f[] vertices = new Point3f[72];
        for (int i = 0; i < 6; ++i) {
            vertices[v++] = cube[i][0];
            vertices[v++] = cube[i][1];
            vertices[v++] = axes[i];
            vertices[v++] = cube[i][1];
            vertices[v++] = cube[i][2];
            vertices[v++] = axes[i];
            vertices[v++] = cube[i][2];
            vertices[v++] = cube[i][3];
            vertices[v++] = axes[i];
            vertices[v++] = cube[i][3];
            vertices[v++] = cube[i][0];
            vertices[v++] = axes[i];
        }
        Material m = new Material();
        m.setCapability(0);
        m.setCapability(1);
        if (enableLighting) {
            vertexFormat = 3;
            m.setLightingEnable(true);
        } else {
            vertexFormat = 1;
            m.setLightingEnable(false);
        }
        TriangleArray ta = new TriangleArray(72, vertexFormat);
        ta.setCoordinates(0, vertices);
        if (enableLighting) {
            Vector3f v0 = new Vector3f();
            Vector3f v1 = new Vector3f();
            Vector3f[] normals = new Vector3f[72];
            for (int i = 0; i < 72; i += 3) {
                v0.sub((Tuple3f)vertices[i + 1], (Tuple3f)vertices[i]);
                v1.sub((Tuple3f)vertices[i + 2], (Tuple3f)vertices[i]);
                Vector3f n = new Vector3f();
                n.cross(v0, v1);
                n.normalize();
                normals[i] = n;
                normals[i + 1] = n;
                normals[i + 2] = n;
            }
            ta.setNormals(0, normals);
        }
        Appearance a = new Appearance();
        a.setMaterial(m);
        a.setCapability(0);
        a.setCapability(1);
        TransparencyAttributes tra = new TransparencyAttributes();
        tra.setCapability(0);
        tra.setCapability(1);
        tra.setCapability(2);
        tra.setCapability(3);
        ta.setCapability(4);
        ta.setCapability(5);
        a.setTransparencyAttributes(tra);
        a.setCapability(10);
        a.setCapability(11);
        this.setGeometry((Geometry)ta);
        this.setAppearance(a);
        this.setCapability(14);
        this.setCapability(15);
    }
}

