/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.geometry;

import org.scijava.java3d.Appearance;
import org.scijava.java3d.Geometry;
import org.scijava.java3d.Node;
import org.scijava.java3d.Shape3D;
import org.scijava.java3d.utils.geometry.GeomBuffer;
import org.scijava.java3d.utils.geometry.Primitive;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.TexCoord2f;
import org.scijava.vecmath.Vector3f;

public class Sphere
extends Primitive {
    public static final int BODY = 0;
    static final int MID_REZ_DIV = 16;
    float radius;
    int divisions;

    public Sphere(float radius) {
        this(radius, 1, 16);
    }

    public Sphere() {
        this(1.0f, 1, 16);
    }

    public Sphere(float radius, Appearance ap) {
        this(radius, 1, 16, ap);
    }

    public Sphere(float radius, int primflags, Appearance ap) {
        this(radius, primflags, 16, ap);
    }

    public Sphere(float radius, int primflags, int divisions) {
        this(radius, primflags, divisions, null);
    }

    @Override
    public Shape3D getShape(int partId) {
        if (partId != 0) {
            return null;
        }
        return (Shape3D)this.getChild(0);
    }

    public Shape3D getShape() {
        return (Shape3D)this.getChild(0);
    }

    @Override
    public void setAppearance(Appearance ap) {
        ((Shape3D)this.getChild(0)).setAppearance(ap);
    }

    @Override
    public Appearance getAppearance(int partId) {
        if (partId != 0) {
            return null;
        }
        return this.getShape(partId).getAppearance();
    }

    public Sphere(float radius, int primflags, int divisions, Appearance ap) {
        Shape3D shape;
        int n;
        int nstep;
        this.radius = radius;
        this.divisions = divisions;
        this.flags = primflags;
        boolean texCoordYUp = (this.flags & 8) != 0;
        int sign = (this.flags & 4) != 0 ? -1 : 1;
        if (divisions < 4) {
            nstep = 1;
            n = 4;
        } else {
            int mod = divisions % 4;
            n = mod == 0 ? divisions : divisions + (4 - mod);
            nstep = n / 4;
        }
        GeomBuffer cache = this.getCachedGeometry(1, radius, 0.0f, 0.0f, divisions, 0, primflags);
        if (cache != null) {
            shape = new Shape3D((Geometry)cache.getComputedGeometry());
            this.numVerts += cache.getNumVerts();
            this.numTris += cache.getNumTris();
        } else {
            TexCoord2f[] texCoords;
            GeomBuffer gbuf = new GeomBuffer(8 * nstep * (nstep + 2));
            for (int i = 0; i < 4; ++i) {
                this.buildQuadrant(gbuf, (double)i * Math.PI / 2.0, (double)(i + 1) * Math.PI / 2.0, sign, nstep, n, true);
                this.buildQuadrant(gbuf, (double)i * Math.PI / 2.0, (double)(i + 1) * Math.PI / 2.0, sign, nstep, n, false);
            }
            if (texCoordYUp && (texCoords = gbuf.getTexCoords()) != null) {
                for (int ii = 0; ii < texCoords.length; ++ii) {
                    texCoords[ii].y = 1.0f - texCoords[ii].y;
                }
            }
            shape = new Shape3D((Geometry)gbuf.getGeom(this.flags));
            this.numVerts = gbuf.getNumVerts();
            this.numTris = gbuf.getNumTris();
            if ((primflags & 0x10) == 0) {
                this.cacheGeometry(1, radius, 0.0f, 0.0f, divisions, 0, primflags, gbuf);
            }
        }
        if ((this.flags & 0x40) != 0) {
            shape.setCapability(14);
            shape.setCapability(15);
        }
        if ((this.flags & 0x20) != 0) {
            shape.setCapability(12);
        }
        this.addChild((Node)shape);
        if (ap == null) {
            this.setAppearance();
        } else {
            this.setAppearance(ap);
        }
    }

    public Node cloneNode(boolean forceDuplicate) {
        Sphere s = new Sphere(this.radius, this.flags, this.divisions, this.getAppearance());
        s.duplicateNode((Node)this, forceDuplicate);
        return s;
    }

    public void duplicateNode(Node originalNode, boolean forceDuplicate) {
        super.duplicateNode(originalNode, forceDuplicate);
    }

    public float getRadius() {
        return this.radius;
    }

    public int getDivisions() {
        return this.divisions;
    }

    void buildQuadrant(GeomBuffer gbuf, double startDelta, double endDelta, int sign, int nstep, int n, boolean upperSphere) {
        boolean leftToRight;
        double starth;
        double theta;
        double dt;
        if (upperSphere) {
            theta = dt = Math.PI / (double)(2 * nstep);
            starth = 1.0;
            leftToRight = sign > 0;
        } else {
            dt = -Math.PI / (double)(2 * nstep);
            theta = Math.PI + dt;
            starth = -1.0;
            leftToRight = sign < 0;
        }
        for (int i = 1; i <= nstep; ++i) {
            TexCoord2f texCoord;
            Vector3f norm;
            Point3f pt;
            int index;
            double vz;
            double vx;
            int j;
            double delta;
            double h = Math.cos(theta);
            double r = Math.sin(theta);
            double t = sign > 0 ? 1.0 - theta / Math.PI : theta / Math.PI;
            int i2 = i << 1;
            double ds = (endDelta - startDelta) / (double)i;
            gbuf.begin(32);
            if (leftToRight) {
                delta = startDelta;
                for (j = 0; j < i; ++j) {
                    vx = r * Math.cos(delta);
                    vz = r * Math.sin(delta);
                    gbuf.normal3d(vx * (double)sign, h * (double)sign, vz * (double)sign);
                    gbuf.texCoord2d(0.75 - delta / (Math.PI * 2), t);
                    gbuf.vertex3d(vx * (double)this.radius, h * (double)this.radius, vz * (double)this.radius);
                    if (i > 1) {
                        index = gbuf.currVertCnt - i2;
                        pt = gbuf.pts[index];
                        norm = gbuf.normals[index];
                        texCoord = gbuf.tcoords[index];
                        gbuf.normal3d(norm.x, norm.y, norm.z);
                        gbuf.texCoord2d(texCoord.x, texCoord.y);
                        gbuf.vertex3d(pt.x, pt.y, pt.z);
                    } else {
                        gbuf.normal3d(0.0, (double)sign * starth, 0.0);
                        if (sign > 0) {
                            gbuf.texCoord2d(0.75 - (startDelta + endDelta) / (Math.PI * 4), 1.0 - (theta - dt) / Math.PI);
                        } else {
                            gbuf.texCoord2d(0.75 - (startDelta + endDelta) / (Math.PI * 4), (theta - dt) / Math.PI);
                        }
                        gbuf.vertex3d(0.0, starth * (double)this.radius, 0.0);
                    }
                    delta += ds;
                }
                delta = endDelta;
                vx = r * Math.cos(delta);
                vz = r * Math.sin(delta);
                gbuf.normal3d(vx * (double)sign, h * (double)sign, vz * (double)sign);
                gbuf.texCoord2d(0.75 - delta / (Math.PI * 2), t);
                gbuf.vertex3d(vx * (double)this.radius, h * (double)this.radius, vz * (double)this.radius);
            } else {
                delta = endDelta;
                for (j = i; j > 0; --j) {
                    vx = r * Math.cos(delta);
                    vz = r * Math.sin(delta);
                    gbuf.normal3d(vx * (double)sign, h * (double)sign, vz * (double)sign);
                    gbuf.texCoord2d(0.75 - delta / (Math.PI * 2), t);
                    gbuf.vertex3d(vx * (double)this.radius, h * (double)this.radius, vz * (double)this.radius);
                    if (i > 1) {
                        index = gbuf.currVertCnt - i2;
                        pt = gbuf.pts[index];
                        norm = gbuf.normals[index];
                        texCoord = gbuf.tcoords[index];
                        gbuf.normal3d(norm.x, norm.y, norm.z);
                        gbuf.texCoord2d(texCoord.x, texCoord.y);
                        gbuf.vertex3d(pt.x, pt.y, pt.z);
                    } else {
                        gbuf.normal3d(0.0, (double)sign * starth, 0.0);
                        if (sign > 0) {
                            gbuf.texCoord2d(0.75 - (startDelta + endDelta) / (Math.PI * 4), 1.0 - (theta - dt) / Math.PI);
                        } else {
                            gbuf.texCoord2d(0.75 - (startDelta + endDelta) / (Math.PI * 4), (theta - dt) / Math.PI);
                        }
                        gbuf.vertex3d(0.0, starth * (double)this.radius, 0.0);
                    }
                    delta -= ds;
                }
                delta = startDelta;
                vx = r * Math.cos(delta);
                vz = r * Math.sin(delta);
                gbuf.normal3d(vx * (double)sign, h * (double)sign, vz * (double)sign);
                gbuf.texCoord2d(0.75 - delta / (Math.PI * 2), t);
                gbuf.vertex3d(vx * (double)this.radius, h * (double)this.radius, vz * (double)this.radius);
            }
            gbuf.end();
            if (i < nstep) {
                theta += dt;
                continue;
            }
            theta = 1.5707963267948966;
        }
    }
}

