/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.retained;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ListIterator;
import org.scijava.java3d.Alpha;
import org.scijava.java3d.Appearance;
import org.scijava.java3d.Billboard;
import org.scijava.java3d.BoundingBox;
import org.scijava.java3d.BoundingPolytope;
import org.scijava.java3d.BoundingSphere;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.BranchGroup;
import org.scijava.java3d.Canvas3D;
import org.scijava.java3d.CapabilityNotSetException;
import org.scijava.java3d.ColoringAttributes;
import org.scijava.java3d.ConeSound;
import org.scijava.java3d.DecalGroup;
import org.scijava.java3d.DirectionalLight;
import org.scijava.java3d.DistanceLOD;
import org.scijava.java3d.ExponentialFog;
import org.scijava.java3d.Font3D;
import org.scijava.java3d.Group;
import org.scijava.java3d.ImageComponent2D;
import org.scijava.java3d.ImageComponent3D;
import org.scijava.java3d.IndexedLineArray;
import org.scijava.java3d.IndexedLineStripArray;
import org.scijava.java3d.IndexedPointArray;
import org.scijava.java3d.IndexedQuadArray;
import org.scijava.java3d.IndexedTriangleArray;
import org.scijava.java3d.IndexedTriangleFanArray;
import org.scijava.java3d.IndexedTriangleStripArray;
import org.scijava.java3d.LineArray;
import org.scijava.java3d.LineAttributes;
import org.scijava.java3d.LineStripArray;
import org.scijava.java3d.LinearFog;
import org.scijava.java3d.Link;
import org.scijava.java3d.Material;
import org.scijava.java3d.Morph;
import org.scijava.java3d.OrderedGroup;
import org.scijava.java3d.OrientedShape3D;
import org.scijava.java3d.PathInterpolator;
import org.scijava.java3d.PointArray;
import org.scijava.java3d.PointAttributes;
import org.scijava.java3d.PositionInterpolator;
import org.scijava.java3d.PositionPathInterpolator;
import org.scijava.java3d.QuadArray;
import org.scijava.java3d.RenderingAttributes;
import org.scijava.java3d.RotPosPathInterpolator;
import org.scijava.java3d.RotPosScalePathInterpolator;
import org.scijava.java3d.RotationInterpolator;
import org.scijava.java3d.RotationPathInterpolator;
import org.scijava.java3d.ScaleInterpolator;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.java3d.Shape3D;
import org.scijava.java3d.SharedGroup;
import org.scijava.java3d.Soundscape;
import org.scijava.java3d.SpotLight;
import org.scijava.java3d.Switch;
import org.scijava.java3d.SwitchValueInterpolator;
import org.scijava.java3d.Text3D;
import org.scijava.java3d.Texture2D;
import org.scijava.java3d.Texture3D;
import org.scijava.java3d.TextureAttributes;
import org.scijava.java3d.TextureCubeMap;
import org.scijava.java3d.TextureUnitState;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.TransformInterpolator;
import org.scijava.java3d.TransparencyAttributes;
import org.scijava.java3d.TransparencyInterpolator;
import org.scijava.java3d.TriangleArray;
import org.scijava.java3d.TriangleFanArray;
import org.scijava.java3d.TriangleStripArray;
import org.scijava.java3d.ViewPlatform;
import org.scijava.java3d.utils.scenegraph.io.NamedObjectException;
import org.scijava.java3d.utils.scenegraph.io.ObjectNotLoadedException;
import org.scijava.java3d.utils.scenegraph.io.SceneGraphIO;
import org.scijava.java3d.utils.scenegraph.io.SceneGraphStateProvider;
import org.scijava.java3d.utils.scenegraph.io.UnsupportedUniverseException;
import org.scijava.java3d.utils.scenegraph.io.retained.SGIORuntimeException;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTable;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.NullSceneGraphObjectState;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.SceneGraphObjectState;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.utils.universe.SimpleUniverseState;
import org.scijava.java3d.utils.universe.ConfiguredUniverse;
import org.scijava.java3d.utils.universe.SimpleUniverse;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Color4f;
import org.scijava.vecmath.Matrix4d;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Quat4f;
import org.scijava.vecmath.Tuple3d;
import org.scijava.vecmath.Tuple3f;
import org.scijava.vecmath.Tuple4d;
import org.scijava.vecmath.Tuple4f;
import org.scijava.vecmath.Vector3f;
import org.scijava.vecmath.Vector4d;
import org.scijava.vecmath.Vector4f;

public abstract class Controller {
    protected static final long SYMBOL_TABLE_PTR = 30L;
    protected static final long BG_DIR_PTR = 38L;
    protected static final long NAMES_OBJECTS_TABLE_PTR = 46L;
    protected static final long NODE_TYPES_PTR = 52L;
    protected static final long UNIVERSE_CONFIG_PTR = 60L;
    protected static final long BRANCH_GRAPH_COUNT = 68L;
    protected static final long FILE_DESCRIPTION = 72L;
    protected SymbolTable symbolTable;
    protected NullSceneGraphObjectState nullObject = new NullSceneGraphObjectState(null, this);
    protected int currentFileVersion;
    protected int outputFileVersion = 5;
    protected ClassLoader classLoader = ClassLoader.getSystemClassLoader();
    private boolean useSuperClass = false;
    private int imageCompression = 0;
    Class[] j3dClasses = new Class[]{Alpha.class, Appearance.class, Billboard.class, BranchGroup.class, ColoringAttributes.class, ConeSound.class, DecalGroup.class, DirectionalLight.class, DistanceLOD.class, ExponentialFog.class, Font3D.class, Group.class, ImageComponent2D.class, ImageComponent3D.class, IndexedLineArray.class, IndexedLineStripArray.class, IndexedPointArray.class, IndexedQuadArray.class, IndexedTriangleArray.class, IndexedTriangleFanArray.class, IndexedTriangleStripArray.class, LinearFog.class, LineArray.class, LineAttributes.class, LineStripArray.class, Link.class, Material.class, Morph.class, OrderedGroup.class, OrientedShape3D.class, PathInterpolator.class, PointArray.class, PointAttributes.class, PositionInterpolator.class, PositionPathInterpolator.class, QuadArray.class, RenderingAttributes.class, RotationInterpolator.class, RotationPathInterpolator.class, RotPosPathInterpolator.class, RotPosScalePathInterpolator.class, ScaleInterpolator.class, Shape3D.class, SharedGroup.class, Soundscape.class, SpotLight.class, Switch.class, SwitchValueInterpolator.class, Text3D.class, Texture2D.class, Texture3D.class, TextureAttributes.class, TextureCubeMap.class, TextureUnitState.class, TransformGroup.class, TransformInterpolator.class, TransparencyAttributes.class, TransparencyInterpolator.class, TriangleArray.class, TriangleFanArray.class, TriangleStripArray.class, ViewPlatform.class};

    public Controller() {
        try {
            String imageC;
            if (System.getProperty("j3d.io.UseSuperClassIfNoChildClass") != null) {
                this.useSuperClass = true;
            }
            if ((imageC = System.getProperty("j3d.io.ImageCompression")) != null) {
                if (imageC.equalsIgnoreCase("None")) {
                    this.imageCompression = 0;
                } else if (imageC.equalsIgnoreCase("GZIP")) {
                    this.imageCompression = 1;
                } else if (imageC.equalsIgnoreCase("JPEG")) {
                    this.imageCompression = 2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public int getOutputFileVersion() {
        return this.outputFileVersion;
    }

    public int getCurrentFileVersion() {
        return this.currentFileVersion;
    }

    public SceneGraphObjectState createState(SceneGraphObject obj) {
        return this.createState(obj, this.symbolTable.getSymbol(obj));
    }

    public SceneGraphObjectState createState(SceneGraphObject obj, SymbolTableData symbol) {
        if (obj == null) {
            return this.nullObject;
        }
        if (symbol != null) {
            symbol.incrementReferenceCount();
            this.symbolTable.setBranchGraphID(symbol);
            if (symbol.getNodeState() != null) {
                return symbol.getNodeState();
            }
        } else {
            symbol = this.symbolTable.createSymbol(obj);
        }
        return this.createState(symbol);
    }

    public SceneGraphObjectState createState(SymbolTableData symbol) {
        SceneGraphObjectState ret;
        block4: {
            SceneGraphObject obj = symbol.getJ3dNode();
            if (obj == null) {
                return this.nullObject;
            }
            String name = obj.getClass().getName();
            try {
                Class<SceneGraphObjectState> state = obj instanceof SceneGraphStateProvider ? ((SceneGraphStateProvider)obj).getStateClass() : Class.forName("org.scijava.java3d.utils.scenegraph.io.state." + name + "State");
                ret = this.constructStateObj(symbol, state, obj.getClass());
            }
            catch (ClassNotFoundException e) {
                ret = this.checkSuperClasses(symbol);
                if (!(obj instanceof SceneGraphIO)) {
                    System.out.println("Could not find org.scijava.java3d.utils.scenegraph.io.state." + name + "State, using superclass " + ret.getClass().getName());
                }
                if (ret != null) break block4;
                throw new SGIORuntimeException("No State class for " + obj.getClass().getName());
            }
        }
        symbol.nodeState = ret;
        return ret;
    }

    private SceneGraphObjectState constructStateObj(SymbolTableData symbol, Class state, Class objClass) {
        SceneGraphObjectState ret = null;
        try {
            Constructor construct = state.getConstructor(SymbolTableData.class, Controller.class);
            ret = (SceneGraphObjectState)construct.newInstance(symbol, this);
        }
        catch (NoSuchMethodException ex) {
            System.out.println("Looking for Constructor (" + symbol.j3dNode.getClass().getName() + ", Controller )");
            throw new SGIORuntimeException("1 Broken State class for " + state.getName());
        }
        catch (InvocationTargetException exc) {
            exc.printStackTrace();
            throw new SGIORuntimeException("2 Broken State class for " + state.getName());
        }
        catch (IllegalAccessException exce) {
            throw new SGIORuntimeException("3 Broken State class for " + state.getName());
        }
        catch (InstantiationException excep) {
            throw new SGIORuntimeException("4 Broken State class for " + state.getName());
        }
        return ret;
    }

    private SceneGraphObjectState checkSuperClasses(SymbolTableData symbol) {
        Class<?> cl = symbol.j3dNode.getClass().getSuperclass();
        Class<?> state = null;
        boolean finished = false;
        while (cl != null & !finished) {
            String name = cl.getName();
            try {
                state = Class.forName("org.scijava.java3d.utils.scenegraph.io.state." + name + "State");
            }
            catch (ClassNotFoundException e) {
                state = null;
            }
            if (state != null) {
                finished = true;
                continue;
            }
            cl = cl.getSuperclass();
        }
        if (cl == null) {
            throw new SGIORuntimeException("Unsupported class " + symbol.j3dNode.getClass().getName());
        }
        return this.constructStateObj(symbol, state, cl);
    }

    public void writeObject(DataOutput out, SceneGraphObjectState obj) throws IOException {
        int classID = this.getStateID(obj);
        out.writeInt(classID);
        if (classID == 0) {
            out.writeUTF(obj.getClass().getName());
        }
        obj.writeObject(out);
    }

    public SceneGraphObjectState readObject(DataInput in) throws IOException {
        int classID = in.readInt();
        SceneGraphObjectState state = null;
        if (classID == -1) {
            return this.nullObject;
        }
        if (classID == 0) {
            String stateClassName = in.readUTF();
            try {
                Class<?> cl = Class.forName(stateClassName, true, this.classLoader);
                Constructor<?> construct = cl.getConstructor(SymbolTableData.class, Controller.class);
                state = (SceneGraphObjectState)construct.newInstance(null, this);
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Error Loading State Class " + stateClassName + "  " + e.getMessage());
            }
            catch (NoSuchMethodException ex) {
                throw new IOException("1 Broken State class for " + stateClassName + "  " + ex.getMessage());
            }
            catch (InvocationTargetException exc) {
                exc.printStackTrace();
                throw new IOException("2 Broken State class for " + stateClassName);
            }
            catch (IllegalAccessException exce) {
                throw new IOException("3 Broken State class for " + stateClassName);
            }
            catch (InstantiationException excep) {
                throw new IOException("4 Broken State class for " + stateClassName);
            }
        } else {
            state = this.createCoreState(classID);
        }
        state.readObject(in);
        return state;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected void writeNodeComponents(DataOutput out) throws IOException {
        ListIterator list = this.symbolTable.getUnsavedNodeComponents();
        out.writeInt(this.symbolTable.getUnsavedNodeComponentsSize());
        while (list.hasNext()) {
            SymbolTableData symbol = (SymbolTableData)list.next();
            out.writeInt(symbol.nodeID);
            out.writeLong(0L);
            this.writeObject(out, symbol.getNodeState());
        }
    }

    protected void readNodeComponents(DataInput in) throws IOException {
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            int nodeID = in.readInt();
            long nextNC = in.readLong();
            SceneGraphObjectState nodeComponent = this.readObject(in);
        }
    }

    public void writeSharedGroup(DataOutput out, SharedGroup sharedGroup, SymbolTableData symbol) throws IOException {
        SceneGraphObjectState state = this.createState((SceneGraphObject)sharedGroup, symbol);
        this.symbolTable.startUnsavedNodeComponentFrame();
        this.writeObject(out, state);
        this.writeNodeComponents(out);
        this.symbolTable.endUnsavedNodeComponentFrame();
    }

    public int readSharedGroup(DataInput in) throws IOException {
        SceneGraphObjectState state = this.readObject(in);
        this.readNodeComponents(in);
        return state.getNodeID();
    }

    public void writeUniverse(DataOutput out, SimpleUniverse universe, boolean writeUniverseContent) throws IOException, UnsupportedUniverseException, CapabilityNotSetException {
        if (universe == null) {
            out.writeUTF("null");
        } else if (universe instanceof SimpleUniverse) {
            out.writeUTF(((Object)((Object)universe)).getClass().getName());
            SimpleUniverseState state = new SimpleUniverseState(universe, this);
            state.writeObject(out);
            if (writeUniverseContent) {
                state.detachAllGraphs();
                int[] graphs = state.getAllGraphIDs();
                for (int i = 0; i < graphs.length; ++i) {
                    SymbolTableData symbol = this.symbolTable.getBranchGraphRoot(graphs[i]);
                    System.out.println("Writing " + graphs[i] + "  " + symbol.j3dNode);
                    this.writeBranchGraph((BranchGroup)symbol.j3dNode, null);
                }
                state.attachAllGraphs();
            }
        } else {
            throw new UnsupportedUniverseException("Current Implementation only support SimpleUniverse/ConfiguredUniverse.");
        }
    }

    public ConfiguredUniverse readUniverse(DataInput in, boolean attachBranchGraphs, Canvas3D canvas) throws IOException {
        String universeClass = in.readUTF();
        if (universeClass.equals("null")) {
            return null;
        }
        if (universeClass.equals("org.scijava.java3d.utils.universe.SimpleUniverse") || universeClass.equals("org.scijava.java3d.utils.universe.ConfiguredUniverse")) {
            SimpleUniverseState state = new SimpleUniverseState(this);
            state.readObject(in, canvas);
            if (attachBranchGraphs) {
                int[] graphs = state.getAllGraphIDs();
                this.readBranchGraphs(graphs);
                state.buildGraph();
            }
            return state.getNode();
        }
        throw new IOException("Unrecognized universe class " + universeClass);
    }

    protected abstract void readBranchGraphs(int[] var1) throws IOException;

    public abstract void writeBranchGraph(BranchGroup var1, Serializable var2) throws IOException;

    public void reset() {
        this.symbolTable.clear();
    }

    private SceneGraphObjectState createCoreState(int classID) {
        if (classID == -1) {
            return this.nullObject;
        }
        if (classID == 0) {
            return null;
        }
        Class j3dClass = this.getNodeClassFromID(classID - 1);
        String j3dClassName = j3dClass.getName();
        String stateClassName = "org.scijava.java3d.utils.scenegraph.io.state." + j3dClassName + "State";
        SceneGraphObjectState stateObj = null;
        try {
            Class<?> stateClass = Class.forName(stateClassName);
            Constructor<?> stateConstructor = stateClass.getConstructor(SymbolTableData.class, Controller.class);
            stateObj = (SceneGraphObjectState)stateConstructor.newInstance(null, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stateObj;
    }

    private int getStateID(SceneGraphObjectState state) {
        if (state instanceof NullSceneGraphObjectState) {
            return -1;
        }
        return this.getNodeClassID(state.getNode()) + 1;
    }

    public Class getNodeClassFromID(int classID) {
        if (classID < 0) {
            return null;
        }
        return this.j3dClasses[classID];
    }

    public int getNodeClassID(SceneGraphObject node) {
        int ret = -1;
        Class<?> cl = node.getClass();
        for (int i = 0; i < this.j3dClasses.length && ret == -1; ++i) {
            if (this.j3dClasses[i] != cl) continue;
            ret = i;
        }
        return ret;
    }

    public void addNamedObject(String name, SceneGraphObject object) {
        this.symbolTable.addNamedObject(name, object);
    }

    public SceneGraphObject getNamedObject(String name) throws NamedObjectException, ObjectNotLoadedException {
        return this.symbolTable.getNamedObject(name);
    }

    public String[] getNames() {
        return this.symbolTable.getNames();
    }

    public void writeSerializedData(DataOutput dataOutput, Serializable userData) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(out);
        objOut.writeObject(userData);
        out.close();
        byte[] bytes = out.toByteArray();
        dataOutput.writeInt(bytes.length);
        if (bytes.length != 0) {
            dataOutput.write(bytes);
        }
    }

    public Object readSerializedData(DataInput dataInput) throws IOException {
        int size = dataInput.readInt();
        Object userData = null;
        if (size != 0) {
            byte[] bytes = new byte[size];
            dataInput.readFully(bytes);
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            J3dIOObjectInputStream objIn = new J3dIOObjectInputStream(in);
            try {
                userData = objIn.readObject();
                objIn.close();
            }
            catch (ClassNotFoundException e) {
                System.out.println("WARNING: Unable to load UserData");
                System.out.println("Class missing " + e);
                objIn.close();
            }
        }
        return userData;
    }

    public void skipUserData(DataInput dataInput) throws IOException {
        int size = dataInput.readInt();
        dataInput.skipBytes(size);
    }

    public void writeColor3f(DataOutput out, Color3f color) throws IOException {
        out.writeFloat(color.x);
        out.writeFloat(color.y);
        out.writeFloat(color.z);
    }

    public Color3f readColor3f(DataInput in) throws IOException {
        return new Color3f(in.readFloat(), in.readFloat(), in.readFloat());
    }

    public void writeColor4f(DataOutput out, Color4f vec) throws IOException {
        this.writeTuple4f(out, (Tuple4f)vec);
    }

    public Color4f readColor4f(DataInput in) throws IOException {
        return (Color4f)this.readTuple4f(in, (Tuple4f)new Color4f());
    }

    public void writePoint3f(DataOutput out, Point3f pt) throws IOException {
        this.writeTuple3f(out, (Tuple3f)pt);
    }

    public Point3f readPoint3f(DataInput in) throws IOException {
        return (Point3f)this.readTuple3f(in, (Tuple3f)new Point3f());
    }

    public void writePoint3d(DataOutput out, Point3d pt) throws IOException {
        this.writeTuple3d(out, (Tuple3d)pt);
    }

    public Point3d readPoint3d(DataInput in) throws IOException {
        return (Point3d)this.readTuple3d(in, (Tuple3d)new Point3d());
    }

    public void writeVector3f(DataOutput out, Vector3f vec) throws IOException {
        this.writeTuple3f(out, (Tuple3f)vec);
    }

    public Vector3f readVector3f(DataInput in) throws IOException {
        return (Vector3f)this.readTuple3f(in, (Tuple3f)new Vector3f());
    }

    public void writeVector4d(DataOutput out, Vector4d vec) throws IOException {
        this.writeTuple4d(out, (Tuple4d)vec);
    }

    public Vector4d readVector4d(DataInput in) throws IOException {
        return (Vector4d)this.readTuple4d(in, (Tuple4d)new Vector4d());
    }

    public void writeVector4f(DataOutput out, Vector4f vec) throws IOException {
        this.writeTuple4f(out, (Tuple4f)vec);
    }

    public Vector4f readVector4f(DataInput in) throws IOException {
        return (Vector4f)this.readTuple4f(in, (Tuple4f)new Vector4f());
    }

    public void writeQuat4f(DataOutput out, Quat4f vec) throws IOException {
        this.writeTuple4f(out, (Tuple4f)vec);
    }

    public Quat4f readQuat4f(DataInput in) throws IOException {
        return (Quat4f)this.readTuple4f(in, (Tuple4f)new Quat4f());
    }

    public void writeMatrix4d(DataOutput out, Matrix4d m) throws IOException {
        for (int r = 0; r < 4; ++r) {
            for (int c = 0; c < 4; ++c) {
                out.writeDouble(m.getElement(r, c));
            }
        }
    }

    public Matrix4d readMatrix4d(DataInput in) throws IOException {
        double[] elements = new double[16];
        for (int c = 0; c < 16; ++c) {
            elements[c] = in.readDouble();
        }
        return new Matrix4d(elements);
    }

    public void writeTuple3f(DataOutput out, Tuple3f tuple) throws IOException {
        out.writeFloat(tuple.x);
        out.writeFloat(tuple.y);
        out.writeFloat(tuple.z);
    }

    public Tuple3f readTuple3f(DataInput in, Tuple3f tuple) throws IOException {
        tuple.x = in.readFloat();
        tuple.y = in.readFloat();
        tuple.z = in.readFloat();
        return tuple;
    }

    public void writeTuple3d(DataOutput out, Tuple3d tuple) throws IOException {
        out.writeDouble(tuple.x);
        out.writeDouble(tuple.y);
        out.writeDouble(tuple.z);
    }

    public Tuple3d readTuple3d(DataInput in, Tuple3d tuple) throws IOException {
        tuple.x = in.readDouble();
        tuple.y = in.readDouble();
        tuple.z = in.readDouble();
        return tuple;
    }

    public void writeTuple4d(DataOutput out, Tuple4d tuple) throws IOException {
        out.writeDouble(tuple.x);
        out.writeDouble(tuple.y);
        out.writeDouble(tuple.z);
        out.writeDouble(tuple.w);
    }

    public Tuple4d readTuple4d(DataInput in, Tuple4d tuple) throws IOException {
        tuple.x = in.readDouble();
        tuple.y = in.readDouble();
        tuple.z = in.readDouble();
        tuple.w = in.readDouble();
        return tuple;
    }

    public void writeTuple4f(DataOutput out, Tuple4f tuple) throws IOException {
        out.writeFloat(tuple.x);
        out.writeFloat(tuple.y);
        out.writeFloat(tuple.z);
        out.writeFloat(tuple.w);
    }

    public Tuple4f readTuple4f(DataInput in, Tuple4f tuple) throws IOException {
        tuple.x = in.readFloat();
        tuple.y = in.readFloat();
        tuple.z = in.readFloat();
        tuple.w = in.readFloat();
        return tuple;
    }

    public void writeTransform3D(DataOutput out, Transform3D tran) throws IOException {
        Matrix4d matrix = new Matrix4d();
        tran.get(matrix);
        this.writeMatrix4d(out, matrix);
    }

    public Transform3D readTransform3D(DataInput in) throws IOException {
        Transform3D ret = new Transform3D();
        ret.set(this.readMatrix4d(in));
        return ret;
    }

    public void writeBounds(DataOutput out, Bounds bounds) throws IOException {
        if (bounds == null) {
            out.writeInt(0);
        } else if (bounds instanceof BoundingBox) {
            out.writeInt(1);
            Point3d p = new Point3d();
            ((BoundingBox)bounds).getLower(p);
            this.writePoint3d(out, p);
            ((BoundingBox)bounds).getUpper(p);
            this.writePoint3d(out, p);
        } else if (bounds instanceof BoundingSphere) {
            out.writeInt(2);
            Point3d p = new Point3d();
            ((BoundingSphere)bounds).getCenter(p);
            this.writePoint3d(out, p);
            out.writeDouble(((BoundingSphere)bounds).getRadius());
        } else if (bounds instanceof BoundingPolytope) {
            out.writeInt(3);
            Vector4d[] planes = new Vector4d[((BoundingPolytope)bounds).getNumPlanes()];
            ((BoundingPolytope)bounds).getPlanes(planes);
            out.writeInt(planes.length);
            for (int i = 0; i < planes.length; ++i) {
                this.writeVector4d(out, planes[i]);
            }
        } else {
            throw new IOException("Unsupported bounds class " + bounds.getClass().getName());
        }
    }

    public Bounds readBounds(DataInput in) throws IOException {
        BoundingSphere bounds;
        switch (in.readInt()) {
            case 0: {
                bounds = null;
                break;
            }
            case 1: {
                bounds = new BoundingBox(this.readPoint3d(in), this.readPoint3d(in));
                break;
            }
            case 2: {
                bounds = new BoundingSphere(this.readPoint3d(in), in.readDouble());
                break;
            }
            case 3: {
                Vector4d[] planes = new Vector4d[in.readInt()];
                for (int i = 0; i < planes.length; ++i) {
                    planes[i] = this.readVector4d(in);
                }
                bounds = new BoundingPolytope(planes);
                break;
            }
            default: {
                throw new SGIORuntimeException("Unrecognised bounds class");
            }
        }
        return bounds;
    }

    public abstract long getFilePointer();

    public abstract void close() throws IOException;

    public boolean useSuperClassIfNoChildClass() {
        return this.useSuperClass;
    }

    public int getImageCompression() {
        return this.imageCompression;
    }

    class J3dIOObjectInputStream
    extends ObjectInputStream {
        public J3dIOObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            this.getClass();
            return Class.forName(desc.getName(), true, Controller.this.classLoader);
        }
    }
}

