/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d;

import java.awt.Dimension;
import java.awt.Point;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.scijava.java3d.DepthComponent;
import org.scijava.java3d.ImageComponent2D;
import org.scijava.java3d.Raster;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.GeometryState;
import org.scijava.vecmath.Point3f;

public class RasterState
extends GeometryState {
    int image;
    int depthComponent;

    public RasterState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            this.image = control.getSymbolTable().addReference((SceneGraphObject)((Raster)this.node).getImage());
            this.depthComponent = control.getSymbolTable().addReference((SceneGraphObject)((Raster)this.node).getDepthComponent());
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeInt(this.image);
        out.writeInt(this.depthComponent);
        Point3f pos = new Point3f();
        ((Raster)this.node).getPosition(pos);
        this.control.writePoint3f(out, pos);
        out.writeInt(((Raster)this.node).getType());
        out.writeInt(((Raster)this.node).getClipMode());
        Point offset = new Point();
        ((Raster)this.node).getSrcOffset(offset);
        out.writeInt(offset.x);
        out.writeInt(offset.y);
        Dimension size = new Dimension();
        ((Raster)this.node).getSize(size);
        out.writeInt(size.width);
        out.writeInt(size.height);
        ((Raster)this.node).getDstOffset(offset);
        out.writeInt(offset.x);
        out.writeInt(offset.y);
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        this.image = in.readInt();
        this.depthComponent = in.readInt();
        ((Raster)this.node).setPosition(this.control.readPoint3f(in));
        ((Raster)this.node).setType(in.readInt());
        ((Raster)this.node).setClipMode(in.readInt());
        ((Raster)this.node).setSrcOffset(new Point(in.readInt(), in.readInt()));
        ((Raster)this.node).setSize(new Dimension(in.readInt(), in.readInt()));
        ((Raster)this.node).setDstOffset(new Point(in.readInt(), in.readInt()));
    }

    @Override
    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.image);
        this.control.getSymbolTable().incNodeComponentRefCount(this.depthComponent);
    }

    @Override
    public void buildGraph() {
        ((Raster)this.node).setImage((ImageComponent2D)this.control.getSymbolTable().getJ3dNode(this.image));
        ((Raster)this.node).setDepthComponent((DepthComponent)this.control.getSymbolTable().getJ3dNode(this.depthComponent));
        super.buildGraph();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Raster();
    }
}

