/*-
 * #%L
 * Functional interfaces for SciJava-based libraries.
 * %%
 * Copyright (C) 2021 - 2024 SciJava developers.
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */
/*
 * This is autogenerated source code -- DO NOT EDIT. Instead, edit the
 * corresponding template in templates/ and rerun bin/generate.groovy.
 */

package org.scijava.function;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

/**
 * Container class for
 * higher-<a href="https://en.wikipedia.org/wiki/Arity">arity</a>
 * {@link Consumer}-style functional interfaces&mdash;i.e. with functional
 * method {@code accept} with a number of arguments corresponding to the arity.
 * <ul>
 * <li>For 1-arity (unary) consumers, use {@link Consumer}.</li>
 * <li>For 2-arity (binary) consumers, use {@link BiConsumer}.</li>
 * </ul>
 *
 * @author Curtis Rueden
 * @author Gabriel Selzer
 */
public final class Consumers {

	private Consumers() {
		// NB: Prevent instantiation of container class.
	}

	/**
	 * Represents an operation that accepts no input arguments and returns no
	 * result. This is the zero-arity specialization of {@link Consumer}. Unlike
	 * most other functional interfaces, this interface is expected to operate via
	 * side-effects.
	 * <p>
	 * This is a functional interface whose functional method is
	 * {@link #accept()}.
	 * </p>
	 *
	 * @see Consumer
	 */
	@FunctionalInterface
	public interface Arity0 extends Runnable {

		/**
		 * Performs the operation.
		 */
		void accept();

		@Override
		default void run() {
			accept();
		}

		/**
		 * Returns a composed {@code Consumer.Arity0} that performs, in sequence,
		 * this operation followed by the {@code after} operation. If performing
		 * either operation throws an exception, it is relayed to the caller of the
		 * composed operation. If performing this operation throws an exception, the
		 * {@code after} operation will not be performed.
		 *
		 * @param after the operation to perform after this operation
		 * @return a composed {@code Consumer.Arity0} that performs in sequence this
		 *         operation followed by the {@code after} operation
		 * @throws NullPointerException if {@code after} is null
		 */
		default Arity0 andThen(Arity0 after) {
			Objects.requireNonNull(after);

			return () -> {
				accept();
				after.accept();
			};
		}
	}

	/**
	 * Represents an operation that accepts 3 input arguments and returns no
	 * result. This is the 3-arity specialization of {@link Consumer}. Unlike most
	 * other functional interfaces, this interface is expected to operate via
	 * side-effects.
	 * <p>
	 * This is a functional interface whose functional method is
	 * {@link #accept(Object, Object, Object)}.
	 * </p>
	 *
	 * @param <I1> the type of argument 1.
	 * @param <I2> the type of argument 2.
	 * @param <I3> the type of argument 3.
	 * @see Consumer
	 */
	@FunctionalInterface
	public interface Arity3<I1, I2, I3> {

		/**
		 * Performs this operation on the given arguments.
		 *
		 * @param in1 input argument 1.
		 * @param in2 input argument 2.
		 * @param in3 input argument 3.
		 */
		void accept(final I1 in1, final I2 in2, final I3 in3);

		/**
		 * Returns a composed {@code Consumer.Arity3} that performs, in sequence,
		 * this operation followed by the {@code after} operation. If performing
		 * either operation throws an exception, it is relayed to the caller of the
		 * composed operation. If performing this operation throws an exception, the
		 * {@code after} operation will not be performed.
		 *
		 * @param after the operation to perform after this operation
		 * @return a composed {@code Consumer.Arity3} that performs in sequence this
		 *         operation followed by the {@code after} operation
		 * @throws NullPointerException if {@code after} is null
		 */
		default Arity3<I1, I2, I3> andThen(Arity3<? super I1, ? super I2, ? super I3> after)
		{
			Objects.requireNonNull(after);

			return (in1, in2, in3) -> {
				accept(in1, in2, in3);
				after.accept(in1, in2, in3);
			};
		}
	}

	/**
	 * Represents an operation that accepts 4 input arguments and returns no
	 * result. This is the 4-arity specialization of {@link Consumer}. Unlike most
	 * other functional interfaces, this interface is expected to operate via
	 * side-effects.
	 * <p>
	 * This is a functional interface whose functional method is
	 * {@link #accept(Object, Object, Object, Object)}.
	 * </p>
	 *
	 * @param <I1> the type of argument 1.
	 * @param <I2> the type of argument 2.
	 * @param <I3> the type of argument 3.
	 * @param <I4> the type of argument 4.
	 * @see Consumer
	 */
	@FunctionalInterface
	public interface Arity4<I1, I2, I3, I4> {

		/**
		 * Performs this operation on the given arguments.
		 *
		 * @param in1 input argument 1.
		 * @param in2 input argument 2.
		 * @param in3 input argument 3.
		 * @param in4 input argument 4.
		 */
		void accept(final I1 in1, final I2 in2, final I3 in3, final I4 in4);

		/**
		 * Returns a composed {@code Consumer.Arity4} that performs, in sequence,
		 * this operation followed by the {@code after} operation. If performing
		 * either operation throws an exception, it is relayed to the caller of the
		 * composed operation. If performing this operation throws an exception, the
		 * {@code after} operation will not be performed.
		 *
		 * @param after the operation to perform after this operation
		 * @return a composed {@code Consumer.Arity4} that performs in sequence this
		 *         operation followed by the {@code after} operation
		 * @throws NullPointerException if {@code after} is null
		 */
		default Arity4<I1, I2, I3, I4> andThen(Arity4<? super I1, ? super I2, ? super I3, ? super I4> after)
		{
			Objects.requireNonNull(after);

			return (in1, in2, in3, in4) -> {
				accept(in1, in2, in3, in4);
				after.accept(in1, in2, in3, in4);
			};
		}
	}

	/**
	 * Represents an operation that accepts 5 input arguments and returns no
	 * result. This is the 5-arity specialization of {@link Consumer}. Unlike most
	 * other functional interfaces, this interface is expected to operate via
	 * side-effects.
	 * <p>
	 * This is a functional interface whose functional method is
	 * {@link #accept(Object, Object, Object, Object, Object)}.
	 * </p>
	 *
	 * @param <I1> the type of argument 1.
	 * @param <I2> the type of argument 2.
	 * @param <I3> the type of argument 3.
	 * @param <I4> the type of argument 4.
	 * @param <I5> the type of argument 5.
	 * @see Consumer
	 */
	@FunctionalInterface
	public interface Arity5<I1, I2, I3, I4, I5> {

		/**
		 * Performs this operation on the given arguments.
		 *
		 * @param in1 input argument 1.
		 * @param in2 input argument 2.
		 * @param in3 input argument 3.
		 * @param in4 input argument 4.
		 * @param in5 input argument 5.
		 */
		void accept(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5);

		/**
		 * Returns a composed {@code Consumer.Arity5} that performs, in sequence,
		 * this operation followed by the {@code after} operation. If performing
		 * either operation throws an exception, it is relayed to the caller of the
		 * composed operation. If performing this operation throws an exception, the
		 * {@code after} operation will not be performed.
		 *
		 * @param after the operation to perform after this operation
		 * @return a composed {@code Consumer.Arity5} that performs in sequence this
		 *         operation followed by the {@code after} operation
		 * @throws NullPointerException if {@code after} is null
		 */
		default Arity5<I1, I2, I3, I4, I5> andThen(Arity5<? super I1, ? super I2, ? super I3, ? super I4, ? super I5> after)
		{
			Objects.requireNonNull(after);

			return (in1, in2, in3, in4, in5) -> {
				accept(in1, in2, in3, in4, in5);
				after.accept(in1, in2, in3, in4, in5);
			};
		}
	}

	/**
	 * Represents an operation that accepts 6 input arguments and returns no
	 * result. This is the 6-arity specialization of {@link Consumer}. Unlike most
	 * other functional interfaces, this interface is expected to operate via
	 * side-effects.
	 * <p>
	 * This is a functional interface whose functional method is
	 * {@link #accept(Object, Object, Object, Object, Object, Object)}.
	 * </p>
	 *
	 * @param <I1> the type of argument 1.
	 * @param <I2> the type of argument 2.
	 * @param <I3> the type of argument 3.
	 * @param <I4> the type of argument 4.
	 * @param <I5> the type of argument 5.
	 * @param <I6> the type of argument 6.
	 * @see Consumer
	 */
	@FunctionalInterface
	public interface Arity6<I1, I2, I3, I4, I5, I6> {

		/**
		 * Performs this operation on the given arguments.
		 *
		 * @param in1 input argument 1.
		 * @param in2 input argument 2.
		 * @param in3 input argument 3.
		 * @param in4 input argument 4.
		 * @param in5 input argument 5.
		 * @param in6 input argument 6.
		 */
		void accept(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6);

		/**
		 * Returns a composed {@code Consumer.Arity6} that performs, in sequence,
		 * this operation followed by the {@code after} operation. If performing
		 * either operation throws an exception, it is relayed to the caller of the
		 * composed operation. If performing this operation throws an exception, the
		 * {@code after} operation will not be performed.
		 *
		 * @param after the operation to perform after this operation
		 * @return a composed {@code Consumer.Arity6} that performs in sequence this
		 *         operation followed by the {@code after} operation
		 * @throws NullPointerException if {@code after} is null
		 */
		default Arity6<I1, I2, I3, I4, I5, I6> andThen(Arity6<? super I1, ? super I2, ? super I3, ? super I4, ? super I5, ? super I6> after)
		{
			Objects.requireNonNull(after);

			return (in1, in2, in3, in4, in5, in6) -> {
				accept(in1, in2, in3, in4, in5, in6);
				after.accept(in1, in2, in3, in4, in5, in6);
			};
		}
	}

	/**
	 * Represents an operation that accepts 7 input arguments and returns no
	 * result. This is the 7-arity specialization of {@link Consumer}. Unlike most
	 * other functional interfaces, this interface is expected to operate via
	 * side-effects.
	 * <p>
	 * This is a functional interface whose functional method is
	 * {@link #accept(Object, Object, Object, Object, Object, Object, Object)}.
	 * </p>
	 *
	 * @param <I1> the type of argument 1.
	 * @param <I2> the type of argument 2.
	 * @param <I3> the type of argument 3.
	 * @param <I4> the type of argument 4.
	 * @param <I5> the type of argument 5.
	 * @param <I6> the type of argument 6.
	 * @param <I7> the type of argument 7.
	 * @see Consumer
	 */
	@FunctionalInterface
	public interface Arity7<I1, I2, I3, I4, I5, I6, I7> {

		/**
		 * Performs this operation on the given arguments.
		 *
		 * @param in1 input argument 1.
		 * @param in2 input argument 2.
		 * @param in3 input argument 3.
		 * @param in4 input argument 4.
		 * @param in5 input argument 5.
		 * @param in6 input argument 6.
		 * @param in7 input argument 7.
		 */
		void accept(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7);

		/**
		 * Returns a composed {@code Consumer.Arity7} that performs, in sequence,
		 * this operation followed by the {@code after} operation. If performing
		 * either operation throws an exception, it is relayed to the caller of the
		 * composed operation. If performing this operation throws an exception, the
		 * {@code after} operation will not be performed.
		 *
		 * @param after the operation to perform after this operation
		 * @return a composed {@code Consumer.Arity7} that performs in sequence this
		 *         operation followed by the {@code after} operation
		 * @throws NullPointerException if {@code after} is null
		 */
		default Arity7<I1, I2, I3, I4, I5, I6, I7> andThen(Arity7<? super I1, ? super I2, ? super I3, ? super I4, ? super I5, ? super I6, ? super I7> after)
		{
			Objects.requireNonNull(after);

			return (in1, in2, in3, in4, in5, in6, in7) -> {
				accept(in1, in2, in3, in4, in5, in6, in7);
				after.accept(in1, in2, in3, in4, in5, in6, in7);
			};
		}
	}

	/**
	 * Represents an operation that accepts 8 input arguments and returns no
	 * result. This is the 8-arity specialization of {@link Consumer}. Unlike most
	 * other functional interfaces, this interface is expected to operate via
	 * side-effects.
	 * <p>
	 * This is a functional interface whose functional method is
	 * {@link #accept(Object, Object, Object, Object, Object, Object, Object, Object)}.
	 * </p>
	 *
	 * @param <I1> the type of argument 1.
	 * @param <I2> the type of argument 2.
	 * @param <I3> the type of argument 3.
	 * @param <I4> the type of argument 4.
	 * @param <I5> the type of argument 5.
	 * @param <I6> the type of argument 6.
	 * @param <I7> the type of argument 7.
	 * @param <I8> the type of argument 8.
	 * @see Consumer
	 */
	@FunctionalInterface
	public interface Arity8<I1, I2, I3, I4, I5, I6, I7, I8> {

		/**
		 * Performs this operation on the given arguments.
		 *
		 * @param in1 input argument 1.
		 * @param in2 input argument 2.
		 * @param in3 input argument 3.
		 * @param in4 input argument 4.
		 * @param in5 input argument 5.
		 * @param in6 input argument 6.
		 * @param in7 input argument 7.
		 * @param in8 input argument 8.
		 */
		void accept(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8);

		/**
		 * Returns a composed {@code Consumer.Arity8} that performs, in sequence,
		 * this operation followed by the {@code after} operation. If performing
		 * either operation throws an exception, it is relayed to the caller of the
		 * composed operation. If performing this operation throws an exception, the
		 * {@code after} operation will not be performed.
		 *
		 * @param after the operation to perform after this operation
		 * @return a composed {@code Consumer.Arity8} that performs in sequence this
		 *         operation followed by the {@code after} operation
		 * @throws NullPointerException if {@code after} is null
		 */
		default Arity8<I1, I2, I3, I4, I5, I6, I7, I8> andThen(Arity8<? super I1, ? super I2, ? super I3, ? super I4, ? super I5, ? super I6, ? super I7, ? super I8> after)
		{
			Objects.requireNonNull(after);

			return (in1, in2, in3, in4, in5, in6, in7, in8) -> {
				accept(in1, in2, in3, in4, in5, in6, in7, in8);
				after.accept(in1, in2, in3, in4, in5, in6, in7, in8);
			};
		}
	}

	/**
	 * Represents an operation that accepts 9 input arguments and returns no
	 * result. This is the 9-arity specialization of {@link Consumer}. Unlike most
	 * other functional interfaces, this interface is expected to operate via
	 * side-effects.
	 * <p>
	 * This is a functional interface whose functional method is
	 * {@link #accept(Object, Object, Object, Object, Object, Object, Object, Object, Object)}.
	 * </p>
	 *
	 * @param <I1> the type of argument 1.
	 * @param <I2> the type of argument 2.
	 * @param <I3> the type of argument 3.
	 * @param <I4> the type of argument 4.
	 * @param <I5> the type of argument 5.
	 * @param <I6> the type of argument 6.
	 * @param <I7> the type of argument 7.
	 * @param <I8> the type of argument 8.
	 * @param <I9> the type of argument 9.
	 * @see Consumer
	 */
	@FunctionalInterface
	public interface Arity9<I1, I2, I3, I4, I5, I6, I7, I8, I9> {

		/**
		 * Performs this operation on the given arguments.
		 *
		 * @param in1 input argument 1.
		 * @param in2 input argument 2.
		 * @param in3 input argument 3.
		 * @param in4 input argument 4.
		 * @param in5 input argument 5.
		 * @param in6 input argument 6.
		 * @param in7 input argument 7.
		 * @param in8 input argument 8.
		 * @param in9 input argument 9.
		 */
		void accept(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9);

		/**
		 * Returns a composed {@code Consumer.Arity9} that performs, in sequence,
		 * this operation followed by the {@code after} operation. If performing
		 * either operation throws an exception, it is relayed to the caller of the
		 * composed operation. If performing this operation throws an exception, the
		 * {@code after} operation will not be performed.
		 *
		 * @param after the operation to perform after this operation
		 * @return a composed {@code Consumer.Arity9} that performs in sequence this
		 *         operation followed by the {@code after} operation
		 * @throws NullPointerException if {@code after} is null
		 */
		default Arity9<I1, I2, I3, I4, I5, I6, I7, I8, I9> andThen(Arity9<? super I1, ? super I2, ? super I3, ? super I4, ? super I5, ? super I6, ? super I7, ? super I8, ? super I9> after)
		{
			Objects.requireNonNull(after);

			return (in1, in2, in3, in4, in5, in6, in7, in8, in9) -> {
				accept(in1, in2, in3, in4, in5, in6, in7, in8, in9);
				after.accept(in1, in2, in3, in4, in5, in6, in7, in8, in9);
			};
		}
	}

	/**
	 * Represents an operation that accepts 10 input arguments and returns no
	 * result. This is the 10-arity specialization of {@link Consumer}. Unlike most
	 * other functional interfaces, this interface is expected to operate via
	 * side-effects.
	 * <p>
	 * This is a functional interface whose functional method is
	 * {@link #accept(Object, Object, Object, Object, Object, Object, Object, Object, Object, Object)}.
	 * </p>
	 *
	 * @param <I1> the type of argument 1.
	 * @param <I2> the type of argument 2.
	 * @param <I3> the type of argument 3.
	 * @param <I4> the type of argument 4.
	 * @param <I5> the type of argument 5.
	 * @param <I6> the type of argument 6.
	 * @param <I7> the type of argument 7.
	 * @param <I8> the type of argument 8.
	 * @param <I9> the type of argument 9.
	 * @param <I10> the type of argument 10.
	 * @see Consumer
	 */
	@FunctionalInterface
	public interface Arity10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> {

		/**
		 * Performs this operation on the given arguments.
		 *
		 * @param in1 input argument 1.
		 * @param in2 input argument 2.
		 * @param in3 input argument 3.
		 * @param in4 input argument 4.
		 * @param in5 input argument 5.
		 * @param in6 input argument 6.
		 * @param in7 input argument 7.
		 * @param in8 input argument 8.
		 * @param in9 input argument 9.
		 * @param in10 input argument 10.
		 */
		void accept(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10);

		/**
		 * Returns a composed {@code Consumer.Arity10} that performs, in sequence,
		 * this operation followed by the {@code after} operation. If performing
		 * either operation throws an exception, it is relayed to the caller of the
		 * composed operation. If performing this operation throws an exception, the
		 * {@code after} operation will not be performed.
		 *
		 * @param after the operation to perform after this operation
		 * @return a composed {@code Consumer.Arity10} that performs in sequence this
		 *         operation followed by the {@code after} operation
		 * @throws NullPointerException if {@code after} is null
		 */
		default Arity10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> andThen(Arity10<? super I1, ? super I2, ? super I3, ? super I4, ? super I5, ? super I6, ? super I7, ? super I8, ? super I9, ? super I10> after)
		{
			Objects.requireNonNull(after);

			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10) -> {
				accept(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
				after.accept(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
			};
		}
	}

	/**
	 * Represents an operation that accepts 11 input arguments and returns no
	 * result. This is the 11-arity specialization of {@link Consumer}. Unlike most
	 * other functional interfaces, this interface is expected to operate via
	 * side-effects.
	 * <p>
	 * This is a functional interface whose functional method is
	 * {@link #accept(Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object)}.
	 * </p>
	 *
	 * @param <I1> the type of argument 1.
	 * @param <I2> the type of argument 2.
	 * @param <I3> the type of argument 3.
	 * @param <I4> the type of argument 4.
	 * @param <I5> the type of argument 5.
	 * @param <I6> the type of argument 6.
	 * @param <I7> the type of argument 7.
	 * @param <I8> the type of argument 8.
	 * @param <I9> the type of argument 9.
	 * @param <I10> the type of argument 10.
	 * @param <I11> the type of argument 11.
	 * @see Consumer
	 */
	@FunctionalInterface
	public interface Arity11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> {

		/**
		 * Performs this operation on the given arguments.
		 *
		 * @param in1 input argument 1.
		 * @param in2 input argument 2.
		 * @param in3 input argument 3.
		 * @param in4 input argument 4.
		 * @param in5 input argument 5.
		 * @param in6 input argument 6.
		 * @param in7 input argument 7.
		 * @param in8 input argument 8.
		 * @param in9 input argument 9.
		 * @param in10 input argument 10.
		 * @param in11 input argument 11.
		 */
		void accept(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11);

		/**
		 * Returns a composed {@code Consumer.Arity11} that performs, in sequence,
		 * this operation followed by the {@code after} operation. If performing
		 * either operation throws an exception, it is relayed to the caller of the
		 * composed operation. If performing this operation throws an exception, the
		 * {@code after} operation will not be performed.
		 *
		 * @param after the operation to perform after this operation
		 * @return a composed {@code Consumer.Arity11} that performs in sequence this
		 *         operation followed by the {@code after} operation
		 * @throws NullPointerException if {@code after} is null
		 */
		default Arity11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> andThen(Arity11<? super I1, ? super I2, ? super I3, ? super I4, ? super I5, ? super I6, ? super I7, ? super I8, ? super I9, ? super I10, ? super I11> after)
		{
			Objects.requireNonNull(after);

			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11) -> {
				accept(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
				after.accept(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
			};
		}
	}

	/**
	 * Represents an operation that accepts 12 input arguments and returns no
	 * result. This is the 12-arity specialization of {@link Consumer}. Unlike most
	 * other functional interfaces, this interface is expected to operate via
	 * side-effects.
	 * <p>
	 * This is a functional interface whose functional method is
	 * {@link #accept(Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object)}.
	 * </p>
	 *
	 * @param <I1> the type of argument 1.
	 * @param <I2> the type of argument 2.
	 * @param <I3> the type of argument 3.
	 * @param <I4> the type of argument 4.
	 * @param <I5> the type of argument 5.
	 * @param <I6> the type of argument 6.
	 * @param <I7> the type of argument 7.
	 * @param <I8> the type of argument 8.
	 * @param <I9> the type of argument 9.
	 * @param <I10> the type of argument 10.
	 * @param <I11> the type of argument 11.
	 * @param <I12> the type of argument 12.
	 * @see Consumer
	 */
	@FunctionalInterface
	public interface Arity12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> {

		/**
		 * Performs this operation on the given arguments.
		 *
		 * @param in1 input argument 1.
		 * @param in2 input argument 2.
		 * @param in3 input argument 3.
		 * @param in4 input argument 4.
		 * @param in5 input argument 5.
		 * @param in6 input argument 6.
		 * @param in7 input argument 7.
		 * @param in8 input argument 8.
		 * @param in9 input argument 9.
		 * @param in10 input argument 10.
		 * @param in11 input argument 11.
		 * @param in12 input argument 12.
		 */
		void accept(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12);

		/**
		 * Returns a composed {@code Consumer.Arity12} that performs, in sequence,
		 * this operation followed by the {@code after} operation. If performing
		 * either operation throws an exception, it is relayed to the caller of the
		 * composed operation. If performing this operation throws an exception, the
		 * {@code after} operation will not be performed.
		 *
		 * @param after the operation to perform after this operation
		 * @return a composed {@code Consumer.Arity12} that performs in sequence this
		 *         operation followed by the {@code after} operation
		 * @throws NullPointerException if {@code after} is null
		 */
		default Arity12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> andThen(Arity12<? super I1, ? super I2, ? super I3, ? super I4, ? super I5, ? super I6, ? super I7, ? super I8, ? super I9, ? super I10, ? super I11, ? super I12> after)
		{
			Objects.requireNonNull(after);

			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12) -> {
				accept(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
				after.accept(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
			};
		}
	}

	/**
	 * Represents an operation that accepts 13 input arguments and returns no
	 * result. This is the 13-arity specialization of {@link Consumer}. Unlike most
	 * other functional interfaces, this interface is expected to operate via
	 * side-effects.
	 * <p>
	 * This is a functional interface whose functional method is
	 * {@link #accept(Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object)}.
	 * </p>
	 *
	 * @param <I1> the type of argument 1.
	 * @param <I2> the type of argument 2.
	 * @param <I3> the type of argument 3.
	 * @param <I4> the type of argument 4.
	 * @param <I5> the type of argument 5.
	 * @param <I6> the type of argument 6.
	 * @param <I7> the type of argument 7.
	 * @param <I8> the type of argument 8.
	 * @param <I9> the type of argument 9.
	 * @param <I10> the type of argument 10.
	 * @param <I11> the type of argument 11.
	 * @param <I12> the type of argument 12.
	 * @param <I13> the type of argument 13.
	 * @see Consumer
	 */
	@FunctionalInterface
	public interface Arity13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> {

		/**
		 * Performs this operation on the given arguments.
		 *
		 * @param in1 input argument 1.
		 * @param in2 input argument 2.
		 * @param in3 input argument 3.
		 * @param in4 input argument 4.
		 * @param in5 input argument 5.
		 * @param in6 input argument 6.
		 * @param in7 input argument 7.
		 * @param in8 input argument 8.
		 * @param in9 input argument 9.
		 * @param in10 input argument 10.
		 * @param in11 input argument 11.
		 * @param in12 input argument 12.
		 * @param in13 input argument 13.
		 */
		void accept(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13);

		/**
		 * Returns a composed {@code Consumer.Arity13} that performs, in sequence,
		 * this operation followed by the {@code after} operation. If performing
		 * either operation throws an exception, it is relayed to the caller of the
		 * composed operation. If performing this operation throws an exception, the
		 * {@code after} operation will not be performed.
		 *
		 * @param after the operation to perform after this operation
		 * @return a composed {@code Consumer.Arity13} that performs in sequence this
		 *         operation followed by the {@code after} operation
		 * @throws NullPointerException if {@code after} is null
		 */
		default Arity13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> andThen(Arity13<? super I1, ? super I2, ? super I3, ? super I4, ? super I5, ? super I6, ? super I7, ? super I8, ? super I9, ? super I10, ? super I11, ? super I12, ? super I13> after)
		{
			Objects.requireNonNull(after);

			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13) -> {
				accept(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
				after.accept(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
			};
		}
	}

	/**
	 * Represents an operation that accepts 14 input arguments and returns no
	 * result. This is the 14-arity specialization of {@link Consumer}. Unlike most
	 * other functional interfaces, this interface is expected to operate via
	 * side-effects.
	 * <p>
	 * This is a functional interface whose functional method is
	 * {@link #accept(Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object)}.
	 * </p>
	 *
	 * @param <I1> the type of argument 1.
	 * @param <I2> the type of argument 2.
	 * @param <I3> the type of argument 3.
	 * @param <I4> the type of argument 4.
	 * @param <I5> the type of argument 5.
	 * @param <I6> the type of argument 6.
	 * @param <I7> the type of argument 7.
	 * @param <I8> the type of argument 8.
	 * @param <I9> the type of argument 9.
	 * @param <I10> the type of argument 10.
	 * @param <I11> the type of argument 11.
	 * @param <I12> the type of argument 12.
	 * @param <I13> the type of argument 13.
	 * @param <I14> the type of argument 14.
	 * @see Consumer
	 */
	@FunctionalInterface
	public interface Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> {

		/**
		 * Performs this operation on the given arguments.
		 *
		 * @param in1 input argument 1.
		 * @param in2 input argument 2.
		 * @param in3 input argument 3.
		 * @param in4 input argument 4.
		 * @param in5 input argument 5.
		 * @param in6 input argument 6.
		 * @param in7 input argument 7.
		 * @param in8 input argument 8.
		 * @param in9 input argument 9.
		 * @param in10 input argument 10.
		 * @param in11 input argument 11.
		 * @param in12 input argument 12.
		 * @param in13 input argument 13.
		 * @param in14 input argument 14.
		 */
		void accept(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13, final I14 in14);

		/**
		 * Returns a composed {@code Consumer.Arity14} that performs, in sequence,
		 * this operation followed by the {@code after} operation. If performing
		 * either operation throws an exception, it is relayed to the caller of the
		 * composed operation. If performing this operation throws an exception, the
		 * {@code after} operation will not be performed.
		 *
		 * @param after the operation to perform after this operation
		 * @return a composed {@code Consumer.Arity14} that performs in sequence this
		 *         operation followed by the {@code after} operation
		 * @throws NullPointerException if {@code after} is null
		 */
		default Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> andThen(Arity14<? super I1, ? super I2, ? super I3, ? super I4, ? super I5, ? super I6, ? super I7, ? super I8, ? super I9, ? super I10, ? super I11, ? super I12, ? super I13, ? super I14> after)
		{
			Objects.requireNonNull(after);

			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14) -> {
				accept(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
				after.accept(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
			};
		}
	}

	/**
	 * Represents an operation that accepts 15 input arguments and returns no
	 * result. This is the 15-arity specialization of {@link Consumer}. Unlike most
	 * other functional interfaces, this interface is expected to operate via
	 * side-effects.
	 * <p>
	 * This is a functional interface whose functional method is
	 * {@link #accept(Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object)}.
	 * </p>
	 *
	 * @param <I1> the type of argument 1.
	 * @param <I2> the type of argument 2.
	 * @param <I3> the type of argument 3.
	 * @param <I4> the type of argument 4.
	 * @param <I5> the type of argument 5.
	 * @param <I6> the type of argument 6.
	 * @param <I7> the type of argument 7.
	 * @param <I8> the type of argument 8.
	 * @param <I9> the type of argument 9.
	 * @param <I10> the type of argument 10.
	 * @param <I11> the type of argument 11.
	 * @param <I12> the type of argument 12.
	 * @param <I13> the type of argument 13.
	 * @param <I14> the type of argument 14.
	 * @param <I15> the type of argument 15.
	 * @see Consumer
	 */
	@FunctionalInterface
	public interface Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> {

		/**
		 * Performs this operation on the given arguments.
		 *
		 * @param in1 input argument 1.
		 * @param in2 input argument 2.
		 * @param in3 input argument 3.
		 * @param in4 input argument 4.
		 * @param in5 input argument 5.
		 * @param in6 input argument 6.
		 * @param in7 input argument 7.
		 * @param in8 input argument 8.
		 * @param in9 input argument 9.
		 * @param in10 input argument 10.
		 * @param in11 input argument 11.
		 * @param in12 input argument 12.
		 * @param in13 input argument 13.
		 * @param in14 input argument 14.
		 * @param in15 input argument 15.
		 */
		void accept(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13, final I14 in14, final I15 in15);

		/**
		 * Returns a composed {@code Consumer.Arity15} that performs, in sequence,
		 * this operation followed by the {@code after} operation. If performing
		 * either operation throws an exception, it is relayed to the caller of the
		 * composed operation. If performing this operation throws an exception, the
		 * {@code after} operation will not be performed.
		 *
		 * @param after the operation to perform after this operation
		 * @return a composed {@code Consumer.Arity15} that performs in sequence this
		 *         operation followed by the {@code after} operation
		 * @throws NullPointerException if {@code after} is null
		 */
		default Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> andThen(Arity15<? super I1, ? super I2, ? super I3, ? super I4, ? super I5, ? super I6, ? super I7, ? super I8, ? super I9, ? super I10, ? super I11, ? super I12, ? super I13, ? super I14, ? super I15> after)
		{
			Objects.requireNonNull(after);

			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15) -> {
				accept(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
				after.accept(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
			};
		}
	}

	/**
	 * Represents an operation that accepts 16 input arguments and returns no
	 * result. This is the 16-arity specialization of {@link Consumer}. Unlike most
	 * other functional interfaces, this interface is expected to operate via
	 * side-effects.
	 * <p>
	 * This is a functional interface whose functional method is
	 * {@link #accept(Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object)}.
	 * </p>
	 *
	 * @param <I1> the type of argument 1.
	 * @param <I2> the type of argument 2.
	 * @param <I3> the type of argument 3.
	 * @param <I4> the type of argument 4.
	 * @param <I5> the type of argument 5.
	 * @param <I6> the type of argument 6.
	 * @param <I7> the type of argument 7.
	 * @param <I8> the type of argument 8.
	 * @param <I9> the type of argument 9.
	 * @param <I10> the type of argument 10.
	 * @param <I11> the type of argument 11.
	 * @param <I12> the type of argument 12.
	 * @param <I13> the type of argument 13.
	 * @param <I14> the type of argument 14.
	 * @param <I15> the type of argument 15.
	 * @param <I16> the type of argument 16.
	 * @see Consumer
	 */
	@FunctionalInterface
	public interface Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> {

		/**
		 * Performs this operation on the given arguments.
		 *
		 * @param in1 input argument 1.
		 * @param in2 input argument 2.
		 * @param in3 input argument 3.
		 * @param in4 input argument 4.
		 * @param in5 input argument 5.
		 * @param in6 input argument 6.
		 * @param in7 input argument 7.
		 * @param in8 input argument 8.
		 * @param in9 input argument 9.
		 * @param in10 input argument 10.
		 * @param in11 input argument 11.
		 * @param in12 input argument 12.
		 * @param in13 input argument 13.
		 * @param in14 input argument 14.
		 * @param in15 input argument 15.
		 * @param in16 input argument 16.
		 */
		void accept(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13, final I14 in14, final I15 in15, final I16 in16);

		/**
		 * Returns a composed {@code Consumer.Arity16} that performs, in sequence,
		 * this operation followed by the {@code after} operation. If performing
		 * either operation throws an exception, it is relayed to the caller of the
		 * composed operation. If performing this operation throws an exception, the
		 * {@code after} operation will not be performed.
		 *
		 * @param after the operation to perform after this operation
		 * @return a composed {@code Consumer.Arity16} that performs in sequence this
		 *         operation followed by the {@code after} operation
		 * @throws NullPointerException if {@code after} is null
		 */
		default Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> andThen(Arity16<? super I1, ? super I2, ? super I3, ? super I4, ? super I5, ? super I6, ? super I7, ? super I8, ? super I9, ? super I10, ? super I11, ? super I12, ? super I13, ? super I14, ? super I15, ? super I16> after)
		{
			Objects.requireNonNull(after);

			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16) -> {
				accept(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
				after.accept(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
			};
		}
	}

	/**
	 * Represents an operation that accepts 17 input arguments and returns no
	 * result. This is the 17-arity specialization of {@link Consumer}. Unlike most
	 * other functional interfaces, this interface is expected to operate via
	 * side-effects.
	 * <p>
	 * This is a functional interface whose functional method is
	 * {@link #accept(Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object)}.
	 * </p>
	 *
	 * @param <I1> the type of argument 1.
	 * @param <I2> the type of argument 2.
	 * @param <I3> the type of argument 3.
	 * @param <I4> the type of argument 4.
	 * @param <I5> the type of argument 5.
	 * @param <I6> the type of argument 6.
	 * @param <I7> the type of argument 7.
	 * @param <I8> the type of argument 8.
	 * @param <I9> the type of argument 9.
	 * @param <I10> the type of argument 10.
	 * @param <I11> the type of argument 11.
	 * @param <I12> the type of argument 12.
	 * @param <I13> the type of argument 13.
	 * @param <I14> the type of argument 14.
	 * @param <I15> the type of argument 15.
	 * @param <I16> the type of argument 16.
	 * @param <I17> the type of argument 17.
	 * @see Consumer
	 */
	@FunctionalInterface
	public interface Arity17<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17> {

		/**
		 * Performs this operation on the given arguments.
		 *
		 * @param in1 input argument 1.
		 * @param in2 input argument 2.
		 * @param in3 input argument 3.
		 * @param in4 input argument 4.
		 * @param in5 input argument 5.
		 * @param in6 input argument 6.
		 * @param in7 input argument 7.
		 * @param in8 input argument 8.
		 * @param in9 input argument 9.
		 * @param in10 input argument 10.
		 * @param in11 input argument 11.
		 * @param in12 input argument 12.
		 * @param in13 input argument 13.
		 * @param in14 input argument 14.
		 * @param in15 input argument 15.
		 * @param in16 input argument 16.
		 * @param in17 input argument 17.
		 */
		void accept(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13, final I14 in14, final I15 in15, final I16 in16, final I17 in17);

		/**
		 * Returns a composed {@code Consumer.Arity17} that performs, in sequence,
		 * this operation followed by the {@code after} operation. If performing
		 * either operation throws an exception, it is relayed to the caller of the
		 * composed operation. If performing this operation throws an exception, the
		 * {@code after} operation will not be performed.
		 *
		 * @param after the operation to perform after this operation
		 * @return a composed {@code Consumer.Arity17} that performs in sequence this
		 *         operation followed by the {@code after} operation
		 * @throws NullPointerException if {@code after} is null
		 */
		default Arity17<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17> andThen(Arity17<? super I1, ? super I2, ? super I3, ? super I4, ? super I5, ? super I6, ? super I7, ? super I8, ? super I9, ? super I10, ? super I11, ? super I12, ? super I13, ? super I14, ? super I15, ? super I16, ? super I17> after)
		{
			Objects.requireNonNull(after);

			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16, in17) -> {
				accept(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16, in17);
				after.accept(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16, in17);
			};
		}
	}

}
