/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.api.OpMatchingException;
import org.scijava.ops.api.OpRequest;
import org.scijava.ops.engine.MatchingConditions;
import org.scijava.ops.engine.matcher.MatchingRoutine;
import org.scijava.ops.engine.matcher.OpCandidate;
import org.scijava.ops.engine.matcher.OpMatcher;

public class DefaultOpMatcher
implements OpMatcher {
    private final List<MatchingRoutine> matchers;

    public DefaultOpMatcher(Collection<? extends MatchingRoutine> matchers) {
        this.matchers = new ArrayList<MatchingRoutine>(matchers);
        Collections.sort(this.matchers, Collections.reverseOrder());
    }

    @Override
    public OpCandidate match(MatchingConditions conditions, OpEnvironment env) {
        ArrayList<OpMatchingException> exceptions = new ArrayList<OpMatchingException>(this.matchers.size());
        for (MatchingRoutine r : this.matchers) {
            try {
                return r.match(conditions, this, env);
            }
            catch (OpMatchingException e) {
                exceptions.add(e);
            }
        }
        throw this.agglomeratedException(conditions.request(), exceptions, env);
    }

    private OpMatchingException agglomeratedException(OpRequest request, List<OpMatchingException> list, OpEnvironment env) {
        OpMatchingException agglomerated = new OpMatchingException("No match found");
        list.forEach(agglomerated::addSuppressed);
        return agglomerated;
    }
}

