/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import org.scijava.common3.Types;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.api.OpRequest;
import org.scijava.types.Nil;
import org.scijava.types.infer.GenericAssignability;

public class InfoMatchingOpRequest
implements OpRequest {
    private final String name;
    private final Type type;
    private final Type outType;
    private final Type[] args;
    private final Map<TypeVariable<?>, Type> map = new HashMap();

    public InfoMatchingOpRequest(OpInfo info, Nil<?> specialType) {
        this.name = (String)info.names().get(0);
        Type from = specialType.type();
        Type to = info.opType();
        this.type = Types.superTypeOf((Type)to, (Class)Types.raw((Type)from));
        if (this.type instanceof ParameterizedType ? !GenericAssignability.checkGenericAssignability((Type)from, (ParameterizedType)((ParameterizedType)this.type), this.map, (boolean)true) : !Types.isAssignable((Type)from, (Type)this.type, this.map)) {
            throw new IllegalArgumentException();
        }
        this.args = (Type[])info.inputs().stream().map(m -> this.mappedType(m.type(), this.map)).toArray(Type[]::new);
        this.outType = this.mappedType(info.outputType(), this.map);
    }

    private Type mappedType(Type t, Map<TypeVariable<?>, Type> map) {
        try {
            return Types.unroll((Type)t, map);
        }
        catch (Exception e) {
            return t;
        }
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public Type outType() {
        return this.outType;
    }

    public Type[] argTypes() {
        return this.args;
    }

    public String label() {
        StringBuilder sb = new StringBuilder();
        OpRequest.append((StringBuilder)sb, (String)this.name);
        if (this.type != null) {
            OpRequest.append((StringBuilder)sb, (String)Types.name((Type)this.type));
        }
        return sb.toString();
    }

    public boolean typesMatch(Type opType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (this.type == null) {
            return true;
        }
        return !(this.type instanceof ParameterizedType ? !GenericAssignability.checkGenericAssignability((Type)opType, (ParameterizedType)((ParameterizedType)this.type), typeVarAssigns, (boolean)true) : !Types.isAssignable((Type)opType, (Type)this.type));
    }

    public String toString() {
        return this.requestString();
    }

    public boolean equals(Object obj) {
        return this.requestEquals(obj);
    }

    public int hashCode() {
        return this.requestHashCode();
    }
}

