/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.scijava.common3.Types;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.api.OpMatchingException;
import org.scijava.ops.api.OpRequest;
import org.scijava.ops.engine.MatchingConditions;
import org.scijava.ops.engine.matcher.MatchingResult;
import org.scijava.ops.engine.matcher.MatchingRoutine;
import org.scijava.ops.engine.matcher.OpCandidate;
import org.scijava.ops.engine.matcher.OpMatcher;
import org.scijava.ops.engine.matcher.impl.MatchingUtils;
import org.scijava.struct.Member;
import org.scijava.types.infer.GenericAssignability;

public class RuntimeSafeMatchingRoutine
implements MatchingRoutine {
    @Override
    public void checkSuitability(MatchingConditions conditions) throws OpMatchingException {
    }

    @Override
    public OpCandidate findMatch(MatchingConditions conditions, OpMatcher matcher, OpEnvironment env) {
        ArrayList<OpCandidate> candidates = new ArrayList<OpCandidate>();
        for (OpInfo info : this.getInfos(env, conditions)) {
            HashMap typeVarAssigns = new HashMap();
            if (!this.typesMatch(info.opType(), conditions.request().type(), typeVarAssigns)) continue;
            OpCandidate candidate = new OpCandidate(env, conditions.request(), info, typeVarAssigns);
            candidates.add(candidate);
        }
        List<OpRequest> reqs = Collections.singletonList(conditions.request());
        if (candidates.isEmpty()) {
            return MatchingResult.empty(reqs).singleMatch();
        }
        List<OpCandidate> matches = this.filterMatches(candidates);
        return new MatchingResult(candidates, matches, reqs).singleMatch();
    }

    private List<OpCandidate> checkCandidates(List<OpCandidate> candidates) {
        ArrayList<OpCandidate> validCandidates = new ArrayList<OpCandidate>();
        for (OpCandidate candidate : candidates) {
            Type[] args = candidate.paddedArgs();
            if (args == null || this.missArgs(candidate, args)) continue;
            validCandidates.add(candidate);
        }
        return validCandidates;
    }

    protected List<OpCandidate> filterMatches(List<OpCandidate> candidates) {
        List<OpCandidate> validCandidates = this.checkCandidates(candidates);
        validCandidates.sort((c1, c2) -> Double.compare(c2.priority(), c1.priority()));
        List<OpCandidate> matches = this.filterMatches(validCandidates, this::typesPerfectMatch);
        if (!matches.isEmpty()) {
            return matches;
        }
        matches = this.filterMatches(validCandidates, this::typesMatch);
        return matches;
    }

    private List<OpCandidate> filterMatches(List<OpCandidate> candidates, Predicate<OpCandidate> filter) {
        OpCandidate candidate;
        double p;
        ArrayList<OpCandidate> matches = new ArrayList<OpCandidate>();
        double priority = Double.NaN;
        Iterator<OpCandidate> iterator = candidates.iterator();
        while (iterator.hasNext() && ((p = (candidate = iterator.next()).priority()) == priority || matches.isEmpty())) {
            priority = p;
            if (!filter.test(candidate)) continue;
            matches.add(candidate);
        }
        return matches;
    }

    private Iterable<OpInfo> getInfos(OpEnvironment env, MatchingConditions conditions) {
        return env.infos(conditions.request().name(), conditions.hints());
    }

    private boolean inputsMatch(OpCandidate candidate, HashMap<TypeVariable<?>, MatchingUtils.TypeVarInfo> typeBounds) {
        if (this.checkCandidates(Collections.singletonList(candidate)).isEmpty()) {
            return false;
        }
        Type[] reqArgTypes = candidate.paddedArgs();
        Type reqType = candidate.getRequest().type();
        Type infoType = candidate.opInfo().opType();
        Type implementedInfoType = Types.superTypeOf((Type)infoType, (Class)Types.raw((Type)reqType));
        if (!(implementedInfoType instanceof ParameterizedType)) {
            throw new UnsupportedOperationException("Op type is not a ParameterizedType; we don't know how to deal with these yet.");
        }
        Type[] implTypeParams = ((ParameterizedType)implementedInfoType).getActualTypeArguments();
        Type[] candidateArgTypes = (Type[])candidate.opInfo().struct().members().stream().map(member -> member.isInput() ? member.type() : null).toArray(Type[]::new);
        for (int i = 0; i < implTypeParams.length; ++i) {
            if (candidateArgTypes[i] != null) continue;
            implTypeParams[i] = null;
        }
        candidateArgTypes = (Type[])Arrays.stream(implTypeParams).filter(Objects::nonNull).toArray(Type[]::new);
        if (reqArgTypes == null) {
            return true;
        }
        if (candidateArgTypes.length < reqArgTypes.length) {
            candidate.setStatus(OpCandidate.StatusCode.TOO_FEW_ARGS);
            return false;
        }
        if (candidateArgTypes.length > reqArgTypes.length) {
            candidate.setStatus(OpCandidate.StatusCode.TOO_MANY_ARGS);
            return false;
        }
        int conflictingIndex = MatchingUtils.isApplicable(reqArgTypes, candidateArgTypes, typeBounds);
        if (conflictingIndex != -1) {
            Type to = reqArgTypes[conflictingIndex];
            Type from = candidateArgTypes[conflictingIndex];
            candidate.setStatus(OpCandidate.StatusCode.ARG_TYPES_DO_NOT_MATCH, "request=" + to.getTypeName() + ", actual=" + from.getTypeName());
            return false;
        }
        return true;
    }

    private boolean missArgs(OpCandidate candidate, Type[] paddedArgs) {
        int i = 0;
        for (Member member : candidate.opInfo().inputs()) {
            if (paddedArgs[i++] != null || !member.isRequired()) continue;
            candidate.setStatus(OpCandidate.StatusCode.REQUIRED_ARG_IS_NULL, null, member);
            return true;
        }
        return false;
    }

    private boolean outputsMatch(OpCandidate candidate, HashMap<TypeVariable<?>, MatchingUtils.TypeVarInfo> typeBounds) {
        Type reqOutType = candidate.getRequest().outType();
        if (reqOutType == null) {
            return true;
        }
        if (candidate.opInfo().output().isInput()) {
            return true;
        }
        Type candidateOutType = candidate.opInfo().outputType();
        int conflictingIndex = MatchingUtils.checkGenericOutputsAssignability(new Type[]{candidateOutType}, new Type[]{reqOutType}, typeBounds);
        if (conflictingIndex != -1) {
            candidate.setStatus(OpCandidate.StatusCode.OUTPUT_TYPES_DO_NOT_MATCH, "request=" + reqOutType.getTypeName() + ", actual=" + candidateOutType.getTypeName());
            return false;
        }
        return true;
    }

    private boolean typesMatch(OpCandidate candidate) {
        HashMap typeBounds = new HashMap();
        if (!this.inputsMatch(candidate, typeBounds)) {
            return false;
        }
        if (!this.outputsMatch(candidate, typeBounds)) {
            return false;
        }
        candidate.setStatus(OpCandidate.StatusCode.MATCH);
        return true;
    }

    protected boolean typesMatch(Type opType, Type reqType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (reqType == null) {
            return true;
        }
        try {
            if (reqType instanceof ParameterizedType ? !GenericAssignability.checkGenericAssignability((Type)opType, (ParameterizedType)((ParameterizedType)reqType), typeVarAssigns, (boolean)true) : !Types.isAssignable((Type)opType, (Type)reqType)) {
                return false;
            }
        }
        catch (IllegalStateException e) {
            return false;
        }
        return true;
    }

    private boolean typesPerfectMatch(OpCandidate candidate) {
        int i = 0;
        Type[] paddedArgs = candidate.paddedArgs();
        for (Type t : candidate.opInfo().inputTypes()) {
            if (paddedArgs[i] != null && !t.equals(paddedArgs[i])) {
                return false;
            }
            ++i;
        }
        Type outputType = candidate.getRequest().outType();
        if (!Objects.equals(outputType, candidate.opInfo().outputType())) {
            return false;
        }
        candidate.setStatus(OpCandidate.StatusCode.MATCH);
        return true;
    }

    @Override
    public double priority() {
        return 100.0;
    }
}

