/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.types.extract;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import org.scijava.common3.Types;
import org.scijava.types.extract.TypeExtractor;
import org.scijava.types.extract.TypeReifier;

public abstract class SubTypeExtractor<T>
implements TypeExtractor {
    protected abstract Type[] getTypeParameters(TypeReifier var1, T var2);

    @Override
    public Type reify(TypeReifier r, Object object) {
        if (!this.baseClass().isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException(this.getClass().getName() + " can only reify Objects of Class " + this.baseClass().getSimpleName() + "!");
        }
        Type[] typeVars = this.getTypeParameters(r, object);
        return SubTypeExtractor.parameterizeViaSuperType(object.getClass(), this.baseClass(), typeVars);
    }

    private static Type parameterizeViaSuperType(Class<?> cls, Class<?> superCls, Type ... superClsTypeVars) {
        ParameterizedType t = Types.parameterize(cls, (Type[])new Type[0]);
        Object[] typeVars = Types.typeParamsOf((Type)t, superCls);
        if (typeVars.length != superClsTypeVars.length) {
            throw new IllegalArgumentException("Type variables " + Arrays.toString(typeVars) + " of class " + cls + " did not match the expected type variables " + Arrays.toString(superClsTypeVars) + " of superclass " + superCls);
        }
        HashMap<TypeVariable, Type> map = new HashMap<TypeVariable, Type>();
        for (int i = 0; i < typeVars.length; ++i) {
            if (!(typeVars[i] instanceof TypeVariable)) continue;
            map.put((TypeVariable)typeVars[i], superClsTypeVars[i]);
        }
        return Types.unroll((Type)t, map);
    }
}

