/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.types.infer;

import com.google.common.base.Objects;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.scijava.common3.Any;
import org.scijava.common3.Types;
import org.scijava.types.infer.TypeInferenceException;

class TypeMapping {
    protected final TypeVariable<?> typeVar;
    protected Type mappedType;
    boolean malleable;

    TypeMapping(TypeVariable<?> typeVar, Type mappedType, boolean malleable) {
        this.typeVar = typeVar;
        this.mappedType = mappedType;
        this.malleable = malleable;
    }

    public void refine(Type otherType, boolean newTypeMalleability) {
        if (Any.is((Object)this.mappedType)) {
            this.mappedType = otherType;
            return;
        }
        if (Any.is((Object)otherType)) {
            return;
        }
        if (otherType instanceof WildcardType) {
            this.malleable &= newTypeMalleability;
            WildcardType wType = (WildcardType)otherType;
            if (wType.getLowerBounds().length == 0 && wType.getUpperBounds().length == 1 && wType.getUpperBounds()[0].equals(this.mappedType)) {
                return;
            }
        }
        if (this.malleable && Types.isAssignable((Type)this.mappedType, (Type)otherType)) {
            this.malleable &= newTypeMalleability;
            this.mappedType = otherType;
            return;
        }
        if (Objects.equal((Object)this.mappedType, (Object)otherType)) {
            this.malleable &= newTypeMalleability;
            return;
        }
        throw new TypeInferenceException(this.typeVar + " cannot simultaneously be mapped to " + otherType + " and " + this.mappedType);
    }

    public Type getType() {
        return this.mappedType;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.typeVar, this.mappedType, this.malleable});
    }

    public boolean equals(Object o) {
        if (!(o instanceof TypeMapping)) {
            return false;
        }
        TypeMapping that = (TypeMapping)o;
        return Objects.equal(this.typeVar, that.typeVar) && Objects.equal((Object)this.mappedType, (Object)that.mappedType) && Objects.equal((Object)this.malleable, (Object)that.malleable);
    }

    public String toString() {
        return this.mappedType.toString();
    }
}

