package software.amazon.awsconstructs.services.s3lambda;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-02-24T15:23:46.044Z")
@software.amazon.jsii.Jsii(module = software.amazon.awsconstructs.services.s3lambda.$Module.class, fqn = "@aws-solutions-constructs/aws-s3-lambda.S3ToLambdaProps")
@software.amazon.jsii.Jsii.Proxy(S3ToLambdaProps.Jsii$Proxy.class)
public interface S3ToLambdaProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Optional user provided props to override the default props for the S3 Bucket.
     * <p>
     * Default: - Default props are used
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketProps getBucketProps() {
        return null;
    }

    /**
     * Existing instance of S3 Bucket object, providing both this and `bucketProps` will cause an error.
     * <p>
     * Default: - None
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.Bucket getExistingBucketObj() {
        return null;
    }

    /**
     * Existing instance of Lambda Function object, providing both this and `lambdaFunctionProps` will cause an error.
     * <p>
     * Default: - None
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.Function getExistingLambdaObj() {
        return null;
    }

    /**
     * Optional user provided props to override the default props for the Lambda function.
     * <p>
     * Default: - Default props are used
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.FunctionProps getLambdaFunctionProps() {
        return null;
    }

    /**
     * Optional user provided props to override the default props for the S3 Logging Bucket.
     * <p>
     * Default: - Default props are used
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketProps getLoggingBucketProps() {
        return null;
    }

    /**
     * Whether to turn on Access Logs for the S3 bucket with the associated storage costs.
     * <p>
     * Enabling Access Logging is a best practice.
     * <p>
     * Default: - true
     */
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getLogS3AccessLogs() {
        return null;
    }

    /**
     * Optional user provided props to override the default props.
     * <p>
     * Default: - Default props are used
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.eventsources.S3EventSourceProps getS3EventSourceProps() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link S3ToLambdaProps}
     */
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3ToLambdaProps}
     */
    public static final class Builder implements software.amazon.jsii.Builder<S3ToLambdaProps> {
        software.amazon.awscdk.services.s3.BucketProps bucketProps;
        software.amazon.awscdk.services.s3.Bucket existingBucketObj;
        software.amazon.awscdk.services.lambda.Function existingLambdaObj;
        software.amazon.awscdk.services.lambda.FunctionProps lambdaFunctionProps;
        software.amazon.awscdk.services.s3.BucketProps loggingBucketProps;
        java.lang.Boolean logS3AccessLogs;
        software.amazon.awscdk.services.lambda.eventsources.S3EventSourceProps s3EventSourceProps;

        /**
         * Sets the value of {@link S3ToLambdaProps#getBucketProps}
         * @param bucketProps Optional user provided props to override the default props for the S3 Bucket.
         * @return {@code this}
         */
        public Builder bucketProps(software.amazon.awscdk.services.s3.BucketProps bucketProps) {
            this.bucketProps = bucketProps;
            return this;
        }

        /**
         * Sets the value of {@link S3ToLambdaProps#getExistingBucketObj}
         * @param existingBucketObj Existing instance of S3 Bucket object, providing both this and `bucketProps` will cause an error.
         * @return {@code this}
         */
        public Builder existingBucketObj(software.amazon.awscdk.services.s3.Bucket existingBucketObj) {
            this.existingBucketObj = existingBucketObj;
            return this;
        }

        /**
         * Sets the value of {@link S3ToLambdaProps#getExistingLambdaObj}
         * @param existingLambdaObj Existing instance of Lambda Function object, providing both this and `lambdaFunctionProps` will cause an error.
         * @return {@code this}
         */
        public Builder existingLambdaObj(software.amazon.awscdk.services.lambda.Function existingLambdaObj) {
            this.existingLambdaObj = existingLambdaObj;
            return this;
        }

        /**
         * Sets the value of {@link S3ToLambdaProps#getLambdaFunctionProps}
         * @param lambdaFunctionProps Optional user provided props to override the default props for the Lambda function.
         * @return {@code this}
         */
        public Builder lambdaFunctionProps(software.amazon.awscdk.services.lambda.FunctionProps lambdaFunctionProps) {
            this.lambdaFunctionProps = lambdaFunctionProps;
            return this;
        }

        /**
         * Sets the value of {@link S3ToLambdaProps#getLoggingBucketProps}
         * @param loggingBucketProps Optional user provided props to override the default props for the S3 Logging Bucket.
         * @return {@code this}
         */
        public Builder loggingBucketProps(software.amazon.awscdk.services.s3.BucketProps loggingBucketProps) {
            this.loggingBucketProps = loggingBucketProps;
            return this;
        }

        /**
         * Sets the value of {@link S3ToLambdaProps#getLogS3AccessLogs}
         * @param logS3AccessLogs Whether to turn on Access Logs for the S3 bucket with the associated storage costs.
         *                        Enabling Access Logging is a best practice.
         * @return {@code this}
         */
        public Builder logS3AccessLogs(java.lang.Boolean logS3AccessLogs) {
            this.logS3AccessLogs = logS3AccessLogs;
            return this;
        }

        /**
         * Sets the value of {@link S3ToLambdaProps#getS3EventSourceProps}
         * @param s3EventSourceProps Optional user provided props to override the default props.
         * @return {@code this}
         */
        public Builder s3EventSourceProps(software.amazon.awscdk.services.lambda.eventsources.S3EventSourceProps s3EventSourceProps) {
            this.s3EventSourceProps = s3EventSourceProps;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3ToLambdaProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @Override
        public S3ToLambdaProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link S3ToLambdaProps}
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ToLambdaProps {
        private final software.amazon.awscdk.services.s3.BucketProps bucketProps;
        private final software.amazon.awscdk.services.s3.Bucket existingBucketObj;
        private final software.amazon.awscdk.services.lambda.Function existingLambdaObj;
        private final software.amazon.awscdk.services.lambda.FunctionProps lambdaFunctionProps;
        private final software.amazon.awscdk.services.s3.BucketProps loggingBucketProps;
        private final java.lang.Boolean logS3AccessLogs;
        private final software.amazon.awscdk.services.lambda.eventsources.S3EventSourceProps s3EventSourceProps;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucketProps = software.amazon.jsii.Kernel.get(this, "bucketProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.BucketProps.class));
            this.existingBucketObj = software.amazon.jsii.Kernel.get(this, "existingBucketObj", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.Bucket.class));
            this.existingLambdaObj = software.amazon.jsii.Kernel.get(this, "existingLambdaObj", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Function.class));
            this.lambdaFunctionProps = software.amazon.jsii.Kernel.get(this, "lambdaFunctionProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.FunctionProps.class));
            this.loggingBucketProps = software.amazon.jsii.Kernel.get(this, "loggingBucketProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.BucketProps.class));
            this.logS3AccessLogs = software.amazon.jsii.Kernel.get(this, "logS3AccessLogs", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.s3EventSourceProps = software.amazon.jsii.Kernel.get(this, "s3EventSourceProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.eventsources.S3EventSourceProps.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucketProps = builder.bucketProps;
            this.existingBucketObj = builder.existingBucketObj;
            this.existingLambdaObj = builder.existingLambdaObj;
            this.lambdaFunctionProps = builder.lambdaFunctionProps;
            this.loggingBucketProps = builder.loggingBucketProps;
            this.logS3AccessLogs = builder.logS3AccessLogs;
            this.s3EventSourceProps = builder.s3EventSourceProps;
        }

        @Override
        public final software.amazon.awscdk.services.s3.BucketProps getBucketProps() {
            return this.bucketProps;
        }

        @Override
        public final software.amazon.awscdk.services.s3.Bucket getExistingBucketObj() {
            return this.existingBucketObj;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.Function getExistingLambdaObj() {
            return this.existingLambdaObj;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.FunctionProps getLambdaFunctionProps() {
            return this.lambdaFunctionProps;
        }

        @Override
        public final software.amazon.awscdk.services.s3.BucketProps getLoggingBucketProps() {
            return this.loggingBucketProps;
        }

        @Override
        public final java.lang.Boolean getLogS3AccessLogs() {
            return this.logS3AccessLogs;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.eventsources.S3EventSourceProps getS3EventSourceProps() {
            return this.s3EventSourceProps;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBucketProps() != null) {
                data.set("bucketProps", om.valueToTree(this.getBucketProps()));
            }
            if (this.getExistingBucketObj() != null) {
                data.set("existingBucketObj", om.valueToTree(this.getExistingBucketObj()));
            }
            if (this.getExistingLambdaObj() != null) {
                data.set("existingLambdaObj", om.valueToTree(this.getExistingLambdaObj()));
            }
            if (this.getLambdaFunctionProps() != null) {
                data.set("lambdaFunctionProps", om.valueToTree(this.getLambdaFunctionProps()));
            }
            if (this.getLoggingBucketProps() != null) {
                data.set("loggingBucketProps", om.valueToTree(this.getLoggingBucketProps()));
            }
            if (this.getLogS3AccessLogs() != null) {
                data.set("logS3AccessLogs", om.valueToTree(this.getLogS3AccessLogs()));
            }
            if (this.getS3EventSourceProps() != null) {
                data.set("s3EventSourceProps", om.valueToTree(this.getS3EventSourceProps()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-solutions-constructs/aws-s3-lambda.S3ToLambdaProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3ToLambdaProps.Jsii$Proxy that = (S3ToLambdaProps.Jsii$Proxy) o;

            if (this.bucketProps != null ? !this.bucketProps.equals(that.bucketProps) : that.bucketProps != null) return false;
            if (this.existingBucketObj != null ? !this.existingBucketObj.equals(that.existingBucketObj) : that.existingBucketObj != null) return false;
            if (this.existingLambdaObj != null ? !this.existingLambdaObj.equals(that.existingLambdaObj) : that.existingLambdaObj != null) return false;
            if (this.lambdaFunctionProps != null ? !this.lambdaFunctionProps.equals(that.lambdaFunctionProps) : that.lambdaFunctionProps != null) return false;
            if (this.loggingBucketProps != null ? !this.loggingBucketProps.equals(that.loggingBucketProps) : that.loggingBucketProps != null) return false;
            if (this.logS3AccessLogs != null ? !this.logS3AccessLogs.equals(that.logS3AccessLogs) : that.logS3AccessLogs != null) return false;
            return this.s3EventSourceProps != null ? this.s3EventSourceProps.equals(that.s3EventSourceProps) : that.s3EventSourceProps == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucketProps != null ? this.bucketProps.hashCode() : 0;
            result = 31 * result + (this.existingBucketObj != null ? this.existingBucketObj.hashCode() : 0);
            result = 31 * result + (this.existingLambdaObj != null ? this.existingLambdaObj.hashCode() : 0);
            result = 31 * result + (this.lambdaFunctionProps != null ? this.lambdaFunctionProps.hashCode() : 0);
            result = 31 * result + (this.loggingBucketProps != null ? this.loggingBucketProps.hashCode() : 0);
            result = 31 * result + (this.logS3AccessLogs != null ? this.logS3AccessLogs.hashCode() : 0);
            result = 31 * result + (this.s3EventSourceProps != null ? this.s3EventSourceProps.hashCode() : 0);
            return result;
        }
    }
}
