/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.framework.knowledge;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import software.amazon.smithy.framework.traits.ImplicitErrorsTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;

public final class ImplicitErrorIndex
implements KnowledgeIndex {
    private final Map<ShapeId, Set<ShapeId>> serviceImplicitErrorMap;
    private final Set<ShapeId> implicitErrors;

    private ImplicitErrorIndex(Model model) {
        HashMap<ShapeId, Set> serviceImplicitError = new HashMap<ShapeId, Set>();
        TreeSet<ShapeId> allImplicitErrors = new TreeSet<ShapeId>();
        for (ServiceShape service : model.getServiceShapes()) {
            for (Map.Entry traitEntry : service.getAllTraits().entrySet()) {
                Shape traitShape;
                Optional traitShapeOptional = model.getShape((ShapeId)traitEntry.getKey());
                if (traitShapeOptional.isEmpty() || !(traitShape = (Shape)traitShapeOptional.get()).hasTrait(ImplicitErrorsTrait.class)) continue;
                ImplicitErrorsTrait implicitErrorsTrait = (ImplicitErrorsTrait)traitShape.expectTrait(ImplicitErrorsTrait.class);
                Set implicitErrorList = serviceImplicitError.computeIfAbsent(service.toShapeId(), k -> new TreeSet());
                implicitErrorList.addAll(implicitErrorsTrait.getValues());
                allImplicitErrors.addAll(implicitErrorsTrait.getValues());
            }
        }
        HashMap immutableServiceMap = new HashMap();
        for (Map.Entry entry : serviceImplicitError.entrySet()) {
            immutableServiceMap.put((ShapeId)entry.getKey(), Collections.unmodifiableSet((Set)entry.getValue()));
        }
        this.serviceImplicitErrorMap = Collections.unmodifiableMap(immutableServiceMap);
        this.implicitErrors = Collections.unmodifiableSet(allImplicitErrors);
    }

    public static ImplicitErrorIndex of(Model model) {
        return (ImplicitErrorIndex)model.getKnowledge(ImplicitErrorIndex.class, ImplicitErrorIndex::new);
    }

    public Set<ShapeId> getImplicitErrorsForService(ToShapeId toShapeId) {
        return this.serviceImplicitErrorMap.getOrDefault(toShapeId.toShapeId(), Collections.emptySet());
    }

    public boolean isImplicitError(ShapeId shapeId) {
        return this.implicitErrors.contains(shapeId);
    }
}

