/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.java.framework.model;

import software.amazon.smithy.java.core.schema.PreludeSchemas;
import software.amazon.smithy.java.core.schema.Schema;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.DocumentationTrait;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.model.traits.HttpErrorTrait;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.traits.RetryableTrait;
import software.amazon.smithy.model.traits.Trait;

final class Schemas {
    static final Schema ACCESS_DENIED_EXCEPTION = Schema.structureBuilder((ShapeId)ShapeId.from((String)"smithy.framework#AccessDeniedException"), (Trait[])new Trait[]{new ErrorTrait("client"), new DocumentationTrait("AccessDeniedException is thrown to indicate that the client was denied access\nto a route or resource. Unlike NotAuthorizedException, this exception does not\nindicate that credentials are missing from the request."), new HttpErrorTrait(403)}).putMember("info", PreludeSchemas.DOCUMENT, new Trait[0]).putMember("message", PreludeSchemas.STRING, new Trait[0]).build();
    static final Schema INTERNAL_FAILURE_EXCEPTION = Schema.structureBuilder((ShapeId)ShapeId.from((String)"smithy.framework#InternalFailureException"), (Trait[])new Trait[]{new ErrorTrait("server"), new DocumentationTrait("InternalFailureException is the catch-all exception for unexpected errors.\nIt indicates either a bug in the framework or an exception being thrown that\nis not modeled. The service SDK will never include any details about internal\nfailures, such as a meaningful exception message, to the caller, in order to\nprevent unintended information disclosure."), new HttpErrorTrait(500)}).putMember("message", PreludeSchemas.STRING, new Trait[]{new DefaultTrait((Node)Node.from((String)"Internal Service Exception"))}).build();
    static final Schema MALFORMED_REQUEST_EXCEPTION = Schema.structureBuilder((ShapeId)ShapeId.from((String)"smithy.framework#MalformedRequestException"), (Trait[])new Trait[]{new ErrorTrait("client"), new DocumentationTrait("MalformedRequestException is thrown by the server when a request is unparseable,\nor if there is a type mismatch between a member in the serialized request and\nthe member in the Smithy model. Since these failures occur during the\ndeserialization process, server developers have no ability to customize these\nmessages, and they will short-circuit request processing before validation\noccurs."), new HttpErrorTrait(400)}).putMember("info", PreludeSchemas.DOCUMENT, new Trait[0]).putMember("message", PreludeSchemas.STRING, new Trait[0]).build();
    static final Schema NOT_AUTHORIZED_EXCEPTION = Schema.structureBuilder((ShapeId)ShapeId.from((String)"smithy.framework#NotAuthorizedException"), (Trait[])new Trait[]{new ErrorTrait("client"), new DocumentationTrait("NotAuthorizedException is thrown when a client calls a route that requires\nauthentication, but does not provide credentials for authorization. This is distinct\nfrom AccessDeniedException that indicates that credentials were provided but\ndid not have acceptable permissions for the requested operation."), new HttpErrorTrait(401)}).putMember("info", PreludeSchemas.DOCUMENT, new Trait[0]).putMember("message", PreludeSchemas.STRING, new Trait[0]).build();
    static final Schema THROTTLING_EXCEPTION = Schema.structureBuilder((ShapeId)ShapeId.from((String)"smithy.framework#ThrottlingException"), (Trait[])new Trait[]{new ErrorTrait("client"), new DocumentationTrait("ThrottlingException is thrown when the service wants a client to reduce its request\nrate. The most common source of throttling errors is a client exceeding either\nan overall API rate limit or a specific route rate limit. Throttling exception are\nretryable. If a `retryAt` Timestamp is provided, clients should retry their request at\nthat time, otherwise they should fall back to their default retry strategy."), new HttpErrorTrait(429), RetryableTrait.builder().throttling(true).build()}).putMember("info", PreludeSchemas.DOCUMENT, new Trait[0]).putMember("message", PreludeSchemas.STRING, new Trait[0]).putMember("retryAt", PreludeSchemas.TIMESTAMP, new Trait[0]).build();
    static final Schema UNKNOWN_OPERATION_EXCEPTION = Schema.structureBuilder((ShapeId)ShapeId.from((String)"smithy.framework#UnknownOperationException"), (Trait[])new Trait[]{new ErrorTrait("client"), new DocumentationTrait("UnknownOperationException is returned when the request cannot be matched to a\nservice and operation known to the server. This can happen either because the\nservice does not recognize the request protocol, which is common for\ninternet-facing endpoints that receive robotic traffic, or if the request is in\na known protocol but for an operation that is unknown to the handler. The latter\ncase can indicate a misconfiguration, such as an operation-level handler being used\nincorrectly."), new HttpErrorTrait(404)}).putMember("info", PreludeSchemas.DOCUMENT, new Trait[0]).putMember("message", PreludeSchemas.STRING, new Trait[0]).build();
    static final Schema VALIDATION_EXCEPTION_FIELD = Schema.structureBuilder((ShapeId)ShapeId.from((String)"smithy.framework#ValidationExceptionField"), (Trait[])new Trait[]{new DocumentationTrait("Describes one specific validation failure for an input member.")}).putMember("path", PreludeSchemas.STRING, new Trait[]{new DocumentationTrait("A JSONPointer expression to the structure member whose value failed to satisfy the modeled constraints."), new RequiredTrait()}).putMember("message", PreludeSchemas.STRING, new Trait[]{new DocumentationTrait("A detailed description of the validation failure."), new RequiredTrait()}).build();
    static final Schema VALIDATION_EXCEPTION_FIELD_LIST = Schema.listBuilder((ShapeId)ShapeId.from((String)"smithy.framework#ValidationExceptionFieldList"), (Trait[])new Trait[0]).putMember("member", VALIDATION_EXCEPTION_FIELD, new Trait[0]).build();
    static final Schema VALIDATION_EXCEPTION = Schema.structureBuilder((ShapeId)ShapeId.from((String)"smithy.framework#ValidationException"), (Trait[])new Trait[]{new ErrorTrait("client"), new DocumentationTrait("A standard error for input validation failures.\nThis should be thrown by services when a member of the input structure\nfalls outside of the modeled or documented constraints.")}).putMember("message", PreludeSchemas.STRING, new Trait[]{new DocumentationTrait("A summary of the validation failure."), new RequiredTrait()}).putMember("fieldList", VALIDATION_EXCEPTION_FIELD_LIST, new Trait[]{new DocumentationTrait("A list of specific failures encountered while validating the input.\nA member can appear in this list more than once if it failed to satisfy multiple constraints.")}).build();

    private Schemas() {
    }
}

