/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.java.codegen.server;

import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.java.codegen.CodegenUtils;
import software.amazon.smithy.java.codegen.JavaSymbolProvider;
import software.amazon.smithy.java.codegen.SymbolProperties;
import software.amazon.smithy.java.codegen.server.ServerSymbolProperties;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.utils.SmithyInternalApi;
import software.amazon.smithy.utils.StringUtils;

@SmithyInternalApi
public final class ServiceJavaSymbolProvider
extends JavaSymbolProvider {
    private final String serviceName;

    public ServiceJavaSymbolProvider(Model model, ServiceShape service, String packageNamespace, String serviceName) {
        super(model, service, packageNamespace);
        this.serviceName = serviceName;
    }

    public Symbol operationShape(OperationShape operationShape) {
        Symbol baseSymbol = super.operationShape(operationShape);
        String stubName = baseSymbol.getName() + "Operation";
        String asyncStubName = stubName + "Async";
        String operationFieldName = StringUtils.uncapitalize((String)baseSymbol.getName());
        Symbol stubSymbol = ((Symbol.Builder)Symbol.builder().name(stubName).putProperty(SymbolProperties.IS_PRIMITIVE, (Object)false)).namespace(String.format("%s.service", this.packageNamespace()), ".").declarationFile(String.format("./%s/service/%s.java", this.packageNamespace().replace(".", "/"), stubName)).build();
        Symbol asyncStubSymbol = ((Symbol.Builder)Symbol.builder().name(asyncStubName).putProperty(SymbolProperties.IS_PRIMITIVE, (Object)false)).namespace(String.format("%s.service", this.packageNamespace()), ".").declarationFile(String.format("./%s/service/%s.java", this.packageNamespace().replace(".", "/"), asyncStubName)).build();
        Symbol apiOperationSymbol = super.operationShape(operationShape);
        return ((Symbol.Builder)((Symbol.Builder)((Symbol.Builder)((Symbol.Builder)((Symbol.Builder)baseSymbol.toBuilder().putProperty(SymbolProperties.IS_PRIMITIVE, (Object)false)).putProperty(ServerSymbolProperties.OPERATION_FIELD_NAME, (Object)operationFieldName)).putProperty(ServerSymbolProperties.ASYNC_STUB_OPERATION, (Object)asyncStubSymbol)).putProperty(ServerSymbolProperties.STUB_OPERATION, (Object)stubSymbol)).putProperty(ServerSymbolProperties.API_OPERATION, (Object)apiOperationSymbol)).build();
    }

    public Symbol serviceShape(ServiceShape serviceShape) {
        return this.getServerJavaClassSymbol();
    }

    private Symbol getServerJavaClassSymbol() {
        return ((Symbol.Builder)((Symbol.Builder)((Symbol.Builder)Symbol.builder().name(this.serviceName).putProperty(SymbolProperties.IS_PRIMITIVE, (Object)false)).putProperty(SymbolProperties.SERVICE_EXCEPTION, (Object)CodegenUtils.getServiceExceptionSymbol((String)this.packageNamespace(), (String)this.serviceName))).putProperty(SymbolProperties.SERVICE_API_SERVICE, (Object)CodegenUtils.getServiceApiSymbol((String)this.packageNamespace(), (String)this.serviceName))).namespace(String.format("%s.service", this.packageNamespace()), ".").declarationFile(String.format("./%s/service/%s.java", this.packageNamespace().replace(".", "/"), this.serviceName)).build();
    }
}

