/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.java.codegen.server.generators;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.directed.GenerateOperationDirective;
import software.amazon.smithy.java.codegen.CodeGenerationContext;
import software.amazon.smithy.java.codegen.CodegenUtils;
import software.amazon.smithy.java.codegen.JavaCodegenSettings;
import software.amazon.smithy.java.codegen.sections.ClassSection;
import software.amazon.smithy.java.codegen.server.ServerSymbolProperties;
import software.amazon.smithy.java.server.RequestContext;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.utils.CodeSection;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class OperationInterfaceGenerator
implements Consumer<GenerateOperationDirective<CodeGenerationContext, JavaCodegenSettings>> {
    @Override
    public void accept(GenerateOperationDirective<CodeGenerationContext, JavaCodegenSettings> directive) {
        OperationShape shape = (OperationShape)directive.shape();
        Symbol input = directive.symbolProvider().toSymbol(directive.model().expectShape(shape.getInputShape()));
        Symbol output = directive.symbolProvider().toSymbol(directive.model().expectShape(shape.getOutputShape()));
        Optional operationMethodName = directive.symbol().getProperty(ServerSymbolProperties.OPERATION_FIELD_NAME);
        Symbol stubSymbol = (Symbol)directive.symbol().expectProperty(ServerSymbolProperties.STUB_OPERATION);
        Symbol asyncStubSymbol = (Symbol)directive.symbol().expectProperty(ServerSymbolProperties.ASYNC_STUB_OPERATION);
        for (Symbol symbol : List.of(stubSymbol, asyncStubSymbol)) {
            ((CodeGenerationContext)directive.context()).writerDelegator().useFileWriter(symbol.getDeclarationFile(), symbol.getNamespace(), writer -> {
                writer.pushState((CodeSection)new ClassSection((Shape)shape));
                String template = "@${functionalInterface:T}\npublic interface ${interface:T} {\n    ${output:T} ${methodName:L}(${input:T} input, ${requestContext:T} context);\n}\n";
                writer.putContext("functionalInterface", FunctionalInterface.class);
                writer.putContext("interface", (Object)symbol);
                writer.putContext("requestContext", RequestContext.class);
                Symbol outputSymbol = symbol == stubSymbol ? output : CodegenUtils.fromClass(CompletableFuture.class).toBuilder().addReference(output).build();
                writer.putContext("output", (Object)outputSymbol);
                writer.putContext("methodName", (Object)operationMethodName);
                writer.putContext("input", (Object)input);
                writer.write((Object)template, new Object[0]);
                writer.popState();
            });
        }
    }
}

