/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.java.codegen.server.generators;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.codegen.core.directed.ContextualDirective;
import software.amazon.smithy.codegen.core.directed.GenerateServiceDirective;
import software.amazon.smithy.framework.knowledge.ImplicitErrorIndex;
import software.amazon.smithy.java.codegen.CodeGenerationContext;
import software.amazon.smithy.java.codegen.JavaCodegenSettings;
import software.amazon.smithy.java.codegen.generators.IdStringGenerator;
import software.amazon.smithy.java.codegen.generators.SchemaFieldGenerator;
import software.amazon.smithy.java.codegen.generators.TypeRegistryGenerator;
import software.amazon.smithy.java.codegen.sections.ClassSection;
import software.amazon.smithy.java.codegen.server.ServerSymbolProperties;
import software.amazon.smithy.java.codegen.writer.JavaWriter;
import software.amazon.smithy.java.core.schema.Schema;
import software.amazon.smithy.java.core.schema.SerializableStruct;
import software.amazon.smithy.java.core.serde.TypeRegistry;
import software.amazon.smithy.java.framework.model.UnknownOperationException;
import software.amazon.smithy.java.server.Operation;
import software.amazon.smithy.java.server.Service;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.CodeSection;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class ServiceGenerator
implements Consumer<GenerateServiceDirective<CodeGenerationContext, JavaCodegenSettings>> {
    @Override
    public void accept(GenerateServiceDirective<CodeGenerationContext, JavaCodegenSettings> directive) {
        ServiceShape shape = (ServiceShape)directive.shape();
        TopDownIndex index = TopDownIndex.of((Model)directive.model());
        List<OperationInfo> operationsInfo = index.getContainedOperations((ToShapeId)shape).stream().map(o -> {
            Symbol inputSymbol = directive.symbolProvider().toSymbol(directive.model().expectShape(o.getInputShape()));
            Symbol outputSymbol = directive.symbolProvider().toSymbol(directive.model().expectShape(o.getOutputShape()));
            return new OperationInfo(directive.symbolProvider().toSymbol((Shape)o), (OperationShape)o, inputSymbol, outputSymbol);
        }).toList();
        List<Symbol> operations = operationsInfo.stream().map(OperationInfo::symbol).toList();
        ((CodeGenerationContext)directive.context()).writerDelegator().useShapeWriter((Shape)shape, writer -> {
            writer.pushState((CodeSection)new ClassSection((Shape)shape));
            String template = "public final class ${service:T} implements ${serviceType:T} {\n\n    ${schema:C}\n\n    ${id:C|}\n\n    ${typeRegistry:C|}\n\n    ${properties:C|}\n\n    ${constructor:C|}\n\n    ${builder:C|}\n\n    @Override\n    @SuppressWarnings(\"unchecked\")\n    public <I extends ${serializableStruct:T}, O extends ${serializableStruct:T}> ${operationHolder:T}<I, O> getOperation(String operationName) {\n        ${getOperation:C|}\n    }\n\n    @Override\n    public ${operationList:T}<${operationHolder:T}<? extends ${serializableStruct:T}, ? extends ${serializableStruct:T}>> getAllOperations() {\n         return allOperations;\n    }\n\n    @Override\n    public ${schemaClass:T} schema() {\n         return $$SCHEMA;\n    }\n\n    @Override\n    public ${typeRegistryClass:T} typeRegistry() {\n        return TYPE_REGISTRY;\n    }\n}\n";
            writer.putContext("operationHolder", Operation.class);
            writer.putContext("serviceType", Service.class);
            writer.putContext("serializableStruct", SerializableStruct.class);
            writer.putContext("schemaClass", Schema.class);
            writer.putContext("service", (Object)directive.symbol());
            writer.putContext("id", (Object)new IdStringGenerator(writer, (Shape)shape));
            writer.putContext("typeRegistryClass", TypeRegistry.class);
            List<Symbol> errorSymbols = ServiceGenerator.getImplicitErrorSymbols(directive.symbolProvider(), directive.model(), directive.service());
            writer.putContext("typeRegistry", (Object)new TypeRegistryGenerator(writer, errorSymbols));
            writer.putContext("properties", (Object)new PropertyGenerator((JavaWriter)writer, shape, directive.symbolProvider(), operationsInfo, false));
            writer.putContext("constructor", (Object)new ConstructorGenerator((JavaWriter)writer, shape, directive.symbolProvider(), operations));
            writer.putContext("builder", (Object)new BuilderGenerator((JavaWriter)writer, shape, directive.symbolProvider(), operationsInfo));
            writer.putContext("getOperation", (Object)new GetOperationGenerator((JavaWriter)writer, shape, directive.symbolProvider(), operations));
            writer.putContext("schema", (Object)new SchemaFieldGenerator((ContextualDirective)directive, writer, (Shape)shape));
            writer.putContext("operationList", List.class);
            writer.write((Object)template, new Object[0]);
            writer.popState();
        });
    }

    private static List<Symbol> getImplicitErrorSymbols(SymbolProvider symbolProvider, Model model, ServiceShape service) {
        ImplicitErrorIndex implicitIndex = ImplicitErrorIndex.of((Model)model);
        ArrayList<Symbol> symbols = new ArrayList<Symbol>();
        for (ShapeId errorId : implicitIndex.getImplicitErrorsForService((ToShapeId)service)) {
            Shape shape = model.expectShape(errorId);
            symbols.add(symbolProvider.toSymbol(shape));
        }
        return symbols;
    }

    private record PropertyGenerator(JavaWriter writer, ServiceShape serviceShape, SymbolProvider symbolProvider, List<OperationInfo> operations, boolean forBuilder) implements Runnable
    {
        @Override
        public void run() {
            for (OperationInfo operation : this.operations) {
                Optional operationName = operation.symbol.getProperty(ServerSymbolProperties.OPERATION_FIELD_NAME);
                this.writer.pushState();
                this.writer.putContext("forBuilder", (Object)this.forBuilder);
                this.writer.putContext("input", (Object)operation.inputSymbol);
                this.writer.putContext("output", (Object)operation.outputSymbol);
                this.writer.putContext("fn", Function.class);
                this.writer.putContext("serviceType", Service.class);
                if (this.forBuilder) {
                    this.writer.write((Object)"private ${fn:T}<${serviceType:T}, ${operationHolder:T}<${input:T}, ${output:T}>> $L;", new Object[]{operationName});
                } else {
                    this.writer.write((Object)"private final ${operationHolder:T}<${input:T}, ${output:T}> $L;", new Object[]{operationName});
                }
                this.writer.popState();
            }
            if (!this.forBuilder) {
                this.writer.write((Object)"private final $T<$T<? extends ${serializableStruct:T}, ? extends ${serializableStruct:T}>> allOperations;", new Object[]{List.class, Operation.class});
            }
        }
    }

    private record ConstructorGenerator(JavaWriter writer, ServiceShape serviceShape, SymbolProvider symbolProvider, List<Symbol> operations) implements Runnable
    {
        @Override
        public void run() {
            this.writer.write((Object)"private ${service:T}(Builder builder) {\n    ${C|}\n}\n", new Object[]{this.writer.consumer(w -> {
                ArrayList<String> operationNames = new ArrayList<String>();
                for (Symbol operation : this.operations) {
                    String operationName = (String)operation.expectProperty(ServerSymbolProperties.OPERATION_FIELD_NAME);
                    w.write((Object)"this.$1L = builder.$1L.apply(this);", new Object[]{operationName});
                    operationNames.add(operationName);
                }
                this.writer.pushState();
                this.writer.putContext("operations", operationNames);
                w.write((Object)"this.allOperations = $T.of(${#operations}${value:L}${^key.last}, ${/key.last}${/operations});", new Object[]{List.class});
                this.writer.popState();
            })});
        }
    }

    private record BuilderGenerator(JavaWriter writer, ServiceShape serviceShape, SymbolProvider symbolProvider, List<OperationInfo> operations) implements Runnable
    {
        @Override
        public void run() {
            List stages = this.operations.stream().map(OperationInfo::symbol).map(symbol -> symbol.getName() + "Stage").collect(Collectors.toList());
            stages.add("BuildStage");
            this.writer.pushState();
            this.writer.putContext("stages", stages);
            for (int i = 0; i < stages.size() - 1; ++i) {
                this.writer.pushState();
                this.writer.putContext("curStage", stages.get(i));
                this.writer.putContext("nextStage", stages.get(i + 1));
                Symbol operation = this.operations.get((int)i).symbol;
                Symbol syncOperation = (Symbol)operation.expectProperty(ServerSymbolProperties.STUB_OPERATION);
                Symbol asyncOperation = (Symbol)operation.expectProperty(ServerSymbolProperties.ASYNC_STUB_OPERATION);
                this.writer.putContext("operation", (Object)operation);
                this.writer.write((Object)"public interface ${curStage:L} {\n    ${nextStage:L} add${operation:T}Operation($T operation);\n    ${nextStage:L} add${operation:T}Operation($T operation);\n}\n", new Object[]{syncOperation, asyncOperation});
                this.writer.popState();
            }
            String template = "public interface BuildStage {\n    ${service:T} build();\n}\n\npublic static ${lastStage:L} builder() {\n    return new Builder();\n}\n\nprivate final static class Builder implements ${#stages}${value:L}${^key.last}, ${/key.last}${/stages} {\n\n    ${builderProperties:C|}\n\n    ${builderStages:C|}\n\n    public ${service:T} build() {\n        return new ${service:T}(this);\n    }\n}\n";
            this.writer.putContext("lastStage", stages.get(0));
            this.writer.putContext("builderProperties", (Object)new PropertyGenerator(this.writer, this.serviceShape, this.symbolProvider, this.operations, true));
            this.writer.putContext("builderStages", (Object)this.writer.consumer(w -> this.generateStages((JavaWriter)w, stages)));
            this.writer.write((Object)template, new Object[0]);
            this.writer.popState();
        }

        private void generateStages(JavaWriter writer, List<String> stages) {
            for (int i = 0; i < this.operations.size(); ++i) {
                Symbol operation = this.operations.get((int)i).symbol;
                String operationFieldName = (String)operation.expectProperty(ServerSymbolProperties.OPERATION_FIELD_NAME);
                String nextStage = stages.get(i + 1);
                Symbol syncOperation = (Symbol)operation.expectProperty(ServerSymbolProperties.STUB_OPERATION);
                Symbol asyncOperation = (Symbol)operation.expectProperty(ServerSymbolProperties.ASYNC_STUB_OPERATION);
                Symbol apiOperation = (Symbol)operation.expectProperty(ServerSymbolProperties.API_OPERATION);
                writer.pushState();
                String template = "@Override\npublic ${nextStage:L} add${operation:T}Operation(${asyncOperationType:T} operation) {\n    this.${operationFieldName:L} = s -> ${operationClass:T}.ofAsync(\"${operation:T}\", operation::${operationFieldName:L}, ${apiOperationClass:T}.instance(), s);\n    return this;\n}\n\n@Override\npublic ${nextStage:L} add${operation:T}Operation(${syncOperationType:T} operation) {\n    this.${operationFieldName:L} = s -> ${operationClass:T}.of(\"${operation:T}\", operation::${operationFieldName:L}, ${apiOperationClass:T}.instance(), s);\n    return this;\n}\n";
                writer.putContext("operationFieldName", (Object)operationFieldName);
                writer.putContext("nextStage", (Object)nextStage);
                writer.putContext("operation", (Object)operation);
                writer.putContext("asyncOperationType", (Object)asyncOperation);
                writer.putContext("syncOperationType", (Object)syncOperation);
                writer.putContext("apiOperationClass", (Object)apiOperation);
                writer.putContext("operationClass", Operation.class);
                writer.write((Object)template, new Object[0]);
                writer.popState();
            }
        }
    }

    private record GetOperationGenerator(JavaWriter writer, ServiceShape serviceShape, SymbolProvider symbolProvider, List<Symbol> operations) implements Runnable
    {
        @Override
        public void run() {
            this.writer.openBlock("return switch (operationName) {", "};", () -> {
                for (Symbol operation : this.operations) {
                    this.writer.write((Object)"case $S -> (Operation<I, O>) $L;", new Object[]{operation.getName(), operation.expectProperty(ServerSymbolProperties.OPERATION_FIELD_NAME)});
                }
                this.writer.write((Object)"default -> throw $T.builder().message(\"Unknown operation name: \" + operationName).build();", new Object[]{UnknownOperationException.class});
            });
        }
    }

    private record OperationInfo(Symbol symbol, OperationShape operationShape, Symbol inputSymbol, Symbol outputSymbol) {
    }
}

