/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.chartjs.model.charts;

import software.xdev.chartjs.model.charts.HomogeneousChart;
import software.xdev.chartjs.model.data.BarData;
import software.xdev.chartjs.model.dataset.BarDataset;
import software.xdev.chartjs.model.options.BarOptions;

public class BarChart
extends HomogeneousChart<BarChart, BarOptions, BarData> {
    public BarChart() {
    }

    public BarChart(BarData data) {
        super(data);
    }

    public BarChart(BarData data, BarOptions options) {
        super(data, options);
    }

    public static BarData data() {
        return new BarData();
    }

    public static BarOptions options() {
        return new BarOptions();
    }

    @Override
    public String getType() {
        return "bar";
    }

    @Override
    public boolean isDrawable() {
        if (((BarData)this.getData()).getLabels().isEmpty()) {
            return false;
        }
        boolean sufficientData = false;
        for (BarDataset dataset : ((BarData)this.getData()).getDatasets()) {
            if (dataset.getXAxisID() != null && !this.hasScaleWithId(dataset.getXAxisID())) {
                return false;
            }
            if (dataset.getYAxisID() != null && !this.hasScaleWithId(dataset.getYAxisID())) {
                return false;
            }
            if (dataset.getData().isEmpty()) continue;
            sufficientData = true;
        }
        return sufficientData;
    }

    private boolean hasScaleWithId(String id) {
        if (this.getOptions() != null && ((BarOptions)this.getOptions()).getScales() != null && ((BarOptions)this.getOptions()).getScales().getScalesList() != null) {
            return ((BarOptions)this.getOptions()).getScales().getScalesList().get(id) != null;
        }
        return false;
    }
}

