/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.chartjs.model.objects;

import java.util.ArrayList;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.annotation.JsonSerialize;
import tools.jackson.databind.ser.std.StdSerializer;

@JsonSerialize(using=Serializer.class)
public class OptionalArray<E>
extends ArrayList<E> {

    public static class Serializer<T>
    extends StdSerializer<OptionalArray<T>> {
        public Serializer() {
            super(OptionalArray.class);
        }

        public boolean isEmpty(SerializationContext ctxt, OptionalArray<T> value) {
            return value == null || value.isEmpty();
        }

        public void serialize(OptionalArray<T> value, JsonGenerator gen, SerializationContext provider) {
            if (value != null && !value.isEmpty()) {
                if (value.size() == 1) {
                    gen.writePOJO(value.get(0));
                } else {
                    gen.writeStartArray();
                    for (Object t : value) {
                        gen.writePOJO(t);
                    }
                    gen.writeEndArray();
                }
            }
        }
    }
}

