/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.sessionize.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import software.xdev.sessionize.model.CategoryItem;

@JsonPropertyOrder(value={"id", "sort", "name", "categoryItems"})
public class CategorySession {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private Integer id;
    public static final String JSON_PROPERTY_SORT = "sort";
    @Nonnull
    private Integer sort;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_CATEGORY_ITEMS = "categoryItems";
    @Nonnull
    private List<CategoryItem> categoryItems = new ArrayList<CategoryItem>();

    public CategorySession id(@Nonnull Integer id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull Integer id) {
        this.id = id;
    }

    public CategorySession sort(@Nonnull Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nonnull
    @JsonProperty(value="sort", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSort(@Nonnull Integer sort) {
        this.sort = sort;
    }

    public CategorySession name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public CategorySession categoryItems(@Nonnull List<CategoryItem> categoryItems) {
        this.categoryItems = categoryItems;
        return this;
    }

    public CategorySession addCategoryItemsItem(CategoryItem categoryItemsItem) {
        if (this.categoryItems == null) {
            this.categoryItems = new ArrayList<CategoryItem>();
        }
        this.categoryItems.add(categoryItemsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="categoryItems", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<CategoryItem> getCategoryItems() {
        return this.categoryItems;
    }

    @JsonProperty(value="categoryItems", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCategoryItems(@Nonnull List<CategoryItem> categoryItems) {
        this.categoryItems = categoryItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategorySession categorySession = (CategorySession)o;
        return Objects.equals(this.id, categorySession.id) && Objects.equals(this.sort, categorySession.sort) && Objects.equals(this.name, categorySession.name) && Objects.equals(this.categoryItems, categorySession.categoryItems);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.sort, this.name, this.categoryItems);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CategorySession {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    categoryItems: ").append(this.toIndentedString(this.categoryItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSort() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%ssort%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSort()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getName() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCategoryItems() != null) {
            for (int i = 0; i < this.getCategoryItems().size(); ++i) {
                if (this.getCategoryItems().get(i) == null) continue;
                joiner.add(this.getCategoryItems().get(i).toUrlQueryString(String.format(Locale.ROOT, "%scategoryItems%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format(Locale.ROOT, "%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

