/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr;

import dev.argon.esexpr.BinToken;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.StringTable;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ESExprBinaryWriter {
    private final List<String> symbolTable;
    private final Set<String> symbolSet;
    private final OutputStream os;

    public ESExprBinaryWriter(List<? extends String> symbolTable, OutputStream os) {
        this.symbolTable = new ArrayList<String>(symbolTable);
        this.symbolSet = new HashSet<String>(symbolTable);
        this.os = os;
    }

    public ESExprBinaryWriter(OutputStream os) {
        this.symbolTable = new ArrayList<String>();
        this.symbolSet = new HashSet<String>();
        this.os = os;
    }

    public void write(ESExpr expr) throws IOException {
        int oldSize = this.symbolTable.size();
        this.addSymbols(expr);
        if (this.symbolTable.size() > oldSize) {
            this.writeToken(BinToken.Fixed.APPEND_STRING_TABLE);
            if (oldSize + 1 == this.symbolTable.size()) {
                this.writeExprRaw(new ESExpr.Str(this.symbolTable.get(oldSize)));
            } else {
                StringTable appendTable = new StringTable(this.symbolTable.subList(oldSize, this.symbolTable.size()));
                this.writeExprRaw(StringTable.codec().encode(appendTable));
            }
        }
        this.writeExprRaw(expr);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void writeExprRaw(ESExpr expr) throws IOException {
        block52: {
            v0 = expr;
            Objects.requireNonNull(v0);
            var2_2 = v0;
            var3_4 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ESExpr.Constructor.class, ESExpr.Bool.class, ESExpr.Int.class, ESExpr.Str.class, ESExpr.Float16.class, ESExpr.Float32.class, ESExpr.Float64.class, ESExpr.Array8.class, ESExpr.Array16.class, ESExpr.Array32.class, ESExpr.Array64.class, ESExpr.Array128.class, ESExpr.Null.class}, (Object)var2_2, var3_4)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    var4_5 = (ESExpr.Constructor)var2_2;
                    var8_6 = var4_5.constructor();
                    constructor = var8_6;
                    var8_6 = var4_5.args();
                    args = var8_6;
                    var8_6 = var4_5.kwargs();
                    kwargs = var8_6;
                    var8_6 = constructor;
                    var9_11 = -1;
                    switch (var8_6.hashCode()) {
                        case -1007575278: {
                            if (!var8_6.equals("string-table")) break;
                            var9_11 = 0;
                            break;
                        }
                        case 3322014: {
                            if (!var8_6.equals("list")) break;
                            var9_11 = 1;
                        }
                    }
                    switch (var9_11) {
                        case 0: {
                            this.writeToken(BinToken.Fixed.CONSTRUCTOR_START_STRING_TABLE);
                            break;
                        }
                        case 1: {
                            this.writeToken(BinToken.Fixed.CONSTRUCTOR_START_LIST);
                            break;
                        }
                        default: {
                            index = this.getSymbolIndex(constructor);
                            this.writeToken(new BinToken.WithInteger(BinToken.WithIntegerType.CONSTRUCTOR, index));
                        }
                    }
                    var8_6 = args.iterator();
                    while (var8_6.hasNext()) {
                        arg = (ESExpr)var8_6.next();
                        this.writeExprRaw(arg);
                    }
                    for (Map.Entry pair : kwargs.entrySet()) {
                        index = this.getSymbolIndex((String)pair.getKey());
                        this.writeToken(new BinToken.WithInteger(BinToken.WithIntegerType.KEYWORD, index));
                        this.writeExprRaw((ESExpr)pair.getValue());
                    }
                    this.writeToken(BinToken.Fixed.CONSTRUCTOR_END);
                    break;
                }
                case 1: {
                    var8_7 = (ESExpr.Bool)var2_2;
                    b = var10_16 = var8_7.b();
                    if (!b) ** GOTO lbl59
                    this.writeToken(BinToken.Fixed.TRUE);
                    break;
lbl59:
                    // 1 sources

                    this.writeToken(BinToken.Fixed.FALSE);
                    break;
                }
                case 2: {
                    var10_17 = (ESExpr.Int)var2_2;
                    i = var12_18 = var10_17.n();
                    if (i.signum() >= 0) ** GOTO lbl68
                    this.writeToken(new BinToken.WithInteger(BinToken.WithIntegerType.NEG_INT, i.negate().subtract(BigInteger.ONE)));
                    break;
lbl68:
                    // 1 sources

                    this.writeToken(new BinToken.WithInteger(BinToken.WithIntegerType.INT, i));
                    break;
                }
                case 3: {
                    var12_19 = (ESExpr.Str)var2_2;
                    s = var14_21 = var12_19.s();
                    b = s.getBytes(StandardCharsets.UTF_8);
                    this.writeToken(new BinToken.WithInteger(BinToken.WithIntegerType.STRING, BigInteger.valueOf(b.length)));
                    this.os.write(b);
                    break;
                }
                case 4: {
                    var14_22 = (ESExpr.Float16)var2_2;
                    f = var16_24 = var14_22.f();
                    this.writeToken(BinToken.Fixed.FLOAT16);
                    bits = Short.toUnsignedInt(f);
                    for (i = 0; i < 2; ++i) {
                        this.os.write(bits & 255);
                        bits >>>= 8;
                    }
                    break block52;
                }
                case 5: {
                    var16_25 = (ESExpr.Float32)var2_2;
                    f = var18_29 = var16_25.f();
                    this.writeToken(BinToken.Fixed.FLOAT32);
                    bits = Float.floatToRawIntBits(f);
                    for (i = 0; i < 4; ++i) {
                        this.os.write(bits & 255);
                        bits >>>= 8;
                    }
                    break block52;
                }
                case 6: {
                    var18_31 = (ESExpr.Float64)var2_2;
                    d = var21_34 = var18_31.d();
                    this.writeToken(BinToken.Fixed.FLOAT64);
                    bits = Double.doubleToRawLongBits(d);
                    for (i = 0; i < 8; ++i) {
                        this.os.write((int)bits & 255);
                        bits >>>= 8;
                    }
                    break block52;
                }
                case 7: {
                    var21_36 = (ESExpr.Array8)var2_2;
                    b = i = var21_36.b();
                    this.writeToken(new BinToken.WithInteger(BinToken.WithIntegerType.ARRAY8, BigInteger.valueOf(b.size())));
                    for (i = 0; i < b.size(); ++i) {
                        this.os.write(b.get(i) & 255);
                    }
                    break block52;
                }
                case 8: {
                    var23_40 = (ESExpr.Array16)var2_2;
                    b = var25_42 = var23_40.b();
                    this.writeToken(BinToken.Fixed.ARRAY16);
                    this.writeInt(BigInteger.valueOf(b.size()));
                    for (i = 0; i < b.size(); ++i) {
                        value = b.get(i);
                        this.os.write(value & 255);
                        this.os.write(value >> 8 & 255);
                    }
                    break block52;
                }
                case 9: {
                    var25_44 = (ESExpr.Array32)var2_2;
                    b = var27_48 = var25_44.b();
                    this.writeToken(BinToken.Fixed.ARRAY32);
                    this.writeInt(BigInteger.valueOf(b.size()));
                    for (i = 0; i < b.size(); ++i) {
                        value = b.get(i);
                        this.os.write(value & 255);
                        this.os.write(value >> 8 & 255);
                        this.os.write(value >> 16 & 255);
                        this.os.write(value >> 24 & 255);
                    }
                    break block52;
                }
                case 10: {
                    var27_50 = (ESExpr.Array64)var2_2;
                    b = var29_53 = var27_50.b();
                    this.writeToken(BinToken.Fixed.ARRAY64);
                    this.writeInt(BigInteger.valueOf(b.size()));
                    for (i = 0; i < b.size(); ++i) {
                        value = b.get(i);
                        this.os.write((int)value & 255);
                        this.os.write((int)(value >> 8) & 255);
                        this.os.write((int)(value >> 16) & 255);
                        this.os.write((int)(value >> 24) & 255);
                        this.os.write((int)(value >> 32) & 255);
                        this.os.write((int)(value >> 40) & 255);
                        this.os.write((int)(value >> 48) & 255);
                        this.os.write((int)(value >> 56) & 255);
                    }
                    break block52;
                }
                case 11: {
                    var29_55 = (ESExpr.Array128)var2_2;
                    b = var31_58 = var29_55.b();
                    if (b.size() % 2 != 0) {
                        throw new IllegalArgumentException("Array128 must have even length");
                    }
                    this.writeToken(BinToken.Fixed.ARRAY128);
                    this.writeInt(BigInteger.valueOf(b.size() / 2));
                    for (i = 0; i < b.size(); ++i) {
                        value = b.get(i);
                        this.os.write((int)value & 255);
                        this.os.write((int)(value >> 8) & 255);
                        this.os.write((int)(value >> 16) & 255);
                        this.os.write((int)(value >> 24) & 255);
                        this.os.write((int)(value >> 32) & 255);
                        this.os.write((int)(value >> 40) & 255);
                        this.os.write((int)(value >> 48) & 255);
                        this.os.write((int)(value >> 56) & 255);
                    }
                    break block52;
                }
                case 12: {
                    var31_60 = (ESExpr.Null)var2_2;
                    level = var33_63 = var31_60.level();
                    if (!level.equals(BigInteger.ZERO)) ** GOTO lbl191
                    this.writeToken(BinToken.Fixed.NULL0);
                    break;
lbl191:
                    // 1 sources

                    if (level.equals(BigInteger.ONE)) {
                        this.writeToken(BinToken.Fixed.NULL1);
                        break;
                    }
                    if (level.equals(BigInteger.valueOf(2L))) {
                        this.writeToken(BinToken.Fixed.NULL2);
                        break;
                    }
                    this.writeToken(BinToken.Fixed.NULLN);
                    this.writeInt(level.subtract(BigInteger.valueOf(3L)));
                }
            }
            break block52;
            catch (Throwable var2_3) {
                throw new MatchException(var2_3.toString(), var2_3);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeToken(BinToken token) throws IOException {
        BinToken binToken = token;
        Objects.requireNonNull(binToken);
        BinToken binToken2 = binToken;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BinToken.WithInteger.class, BinToken.Fixed.class}, (Object)binToken2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                boolean isPos;
                Object value;
                BinToken.WithIntegerType type;
                BinToken.WithInteger withInteger = (BinToken.WithInteger)binToken2;
                try {
                    Object object = withInteger.type();
                    type = object;
                    value = object = withInteger.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                int b = switch (type) {
                    default -> throw new MatchException(null, null);
                    case BinToken.WithIntegerType.CONSTRUCTOR -> 0;
                    case BinToken.WithIntegerType.INT -> 32;
                    case BinToken.WithIntegerType.NEG_INT -> 64;
                    case BinToken.WithIntegerType.STRING -> 96;
                    case BinToken.WithIntegerType.STRING_POOL_INDEX -> 128;
                    case BinToken.WithIntegerType.ARRAY8 -> 160;
                    case BinToken.WithIntegerType.KEYWORD -> 192;
                };
                b |= ((Number)value).byteValue() & 0xF;
                value = ((BigInteger)value).shiftRight(4);
                boolean bl = isPos = ((BigInteger)value).signum() > 0;
                if (isPos) {
                    b |= 0x10;
                }
                this.os.write(b);
                if (!isPos) return;
                this.writeInt((BigInteger)value);
                return;
            }
            case 1: 
        }
        BinToken.Fixed fixed = (BinToken.Fixed)binToken2;
        int b = switch (fixed) {
            default -> throw new MatchException(null, null);
            case BinToken.Fixed.CONSTRUCTOR_END -> 224;
            case BinToken.Fixed.TRUE -> 225;
            case BinToken.Fixed.FALSE -> 226;
            case BinToken.Fixed.NULL0 -> 227;
            case BinToken.Fixed.NULL1 -> 232;
            case BinToken.Fixed.NULL2 -> 233;
            case BinToken.Fixed.NULLN -> 234;
            case BinToken.Fixed.FLOAT16 -> 236;
            case BinToken.Fixed.FLOAT32 -> 228;
            case BinToken.Fixed.FLOAT64 -> 229;
            case BinToken.Fixed.CONSTRUCTOR_START_STRING_TABLE -> 230;
            case BinToken.Fixed.CONSTRUCTOR_START_LIST -> 231;
            case BinToken.Fixed.APPEND_STRING_TABLE -> 235;
            case BinToken.Fixed.ARRAY16 -> 237;
            case BinToken.Fixed.ARRAY32 -> 238;
            case BinToken.Fixed.ARRAY64 -> 239;
            case BinToken.Fixed.ARRAY128 -> 240;
        };
        this.os.write(b);
    }

    private BigInteger getSymbolIndex(String symbol) throws IOException {
        int index = this.symbolTable.indexOf(symbol);
        if (index < 0) {
            index = this.symbolTable.size();
            this.writeToken(BinToken.Fixed.APPEND_STRING_TABLE);
            this.writeExprRaw(new ESExpr.Str(symbol));
        }
        return BigInteger.valueOf(index);
    }

    private void writeInt(BigInteger value) throws IOException {
        do {
            int b = value.byteValue() & 0x7F;
            if ((value = value.shiftRight(7)).signum() > 0) {
                b |= 0x80;
            }
            this.os.write(b);
        } while (value.signum() > 0);
    }

    private void addSymbols(ESExpr expr) {
        if (expr instanceof ESExpr.Constructor) {
            Map<String, ESExpr> kwargs;
            ESExpr.Constructor constructor = (ESExpr.Constructor)expr;
            Iterator<Map.Entry<String, ESExpr>> iterator = constructor.constructor();
            String name = iterator;
            iterator = constructor.args();
            Map<String, ESExpr> args = iterator;
            try {
                iterator = constructor.kwargs();
                kwargs = iterator;
                if (!name.equals("string-table") && !name.equals("list")) {
                    this.addSymbol(name);
                }
                iterator = args.iterator();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            while (iterator.hasNext()) {
                ESExpr arg = (ESExpr)iterator.next();
                this.addSymbols(arg);
            }
            for (Map.Entry<String, ESExpr> kwarg : kwargs.entrySet()) {
                this.addSymbol(kwarg.getKey());
                this.addSymbols(kwarg.getValue());
            }
        }
    }

    private void addSymbol(String symbol) {
        if (this.symbolSet.add(symbol)) {
            this.symbolTable.add(symbol);
        }
    }
}

