/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import java.util.ArrayList;

public abstract class Observable<T> {
    protected final ArrayList<T> mObservers = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObserver(T observer) {
        if (observer == null) {
            throw new IllegalArgumentException("The observer is null.");
        }
        ArrayList<T> arrayList = this.mObservers;
        synchronized (arrayList) {
            if (this.mObservers.contains(observer)) {
                throw new IllegalStateException("Observer " + String.valueOf(observer) + " is already registered.");
            }
            this.mObservers.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterObserver(T observer) {
        if (observer == null) {
            throw new IllegalArgumentException("The observer is null.");
        }
        ArrayList<T> arrayList = this.mObservers;
        synchronized (arrayList) {
            int index = this.mObservers.indexOf(observer);
            if (index == -1) {
                throw new IllegalStateException("Observer " + String.valueOf(observer) + " was not registered.");
            }
            this.mObservers.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAll() {
        ArrayList<T> arrayList = this.mObservers;
        synchronized (arrayList) {
            this.mObservers.clear();
        }
    }
}

