/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content;

import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.OperationCanceledException;
import androidx.core.os.CancellationSignal;

public final class ContentResolverCompat {
    private ContentResolverCompat() {
    }

    public static Cursor query(ContentResolver resolver, Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
        if (Build.VERSION.SDK_INT >= 16) {
            try {
                android.os.CancellationSignal cancellationSignalObj = (android.os.CancellationSignal)(cancellationSignal != null ? cancellationSignal.getCancellationSignalObject() : null);
                return resolver.query(uri, projection, selection, selectionArgs, sortOrder, cancellationSignalObj);
            }
            catch (Exception e) {
                if (e instanceof OperationCanceledException) {
                    throw new androidx.core.os.OperationCanceledException();
                }
                throw e;
            }
        }
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        return resolver.query(uri, projection, selection, selectionArgs, sortOrder);
    }
}

