/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.AndroidUtilsLight;
import com.google.android.gms.common.util.Hex;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseException;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.appcheck.FirebaseAppCheck;
import com.google.firebase.appcheck.internal.AppCheckTokenResponse;
import com.google.firebase.appcheck.internal.DefaultFirebaseAppCheck;
import com.google.firebase.appcheck.internal.HttpErrorResponse;
import com.google.firebase.appcheck.internal.RetryManager;
import com.google.firebase.heartbeatinfo.HeartBeatController;
import com.google.firebase.inject.Provider;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONException;

public class NetworkClient {
    private static final String TAG = NetworkClient.class.getName();
    private static final String SAFETY_NET_EXCHANGE_URL_TEMPLATE = "https://firebaseappcheck.googleapis.com/v1/projects/%s/apps/%s:exchangeSafetyNetToken?key=%s";
    private static final String DEBUG_EXCHANGE_URL_TEMPLATE = "https://firebaseappcheck.googleapis.com/v1/projects/%s/apps/%s:exchangeDebugToken?key=%s";
    private static final String PLAY_INTEGRITY_EXCHANGE_URL_TEMPLATE = "https://firebaseappcheck.googleapis.com/v1/projects/%s/apps/%s:exchangePlayIntegrityToken?key=%s";
    private static final String PLAY_INTEGRITY_CHALLENGE_URL_TEMPLATE = "https://firebaseappcheck.googleapis.com/v1/projects/%s/apps/%s:generatePlayIntegrityChallenge?key=%s";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON = "application/json";
    private static final String UTF_8 = "UTF-8";
    @VisibleForTesting
    static final String X_FIREBASE_CLIENT = "X-Firebase-Client";
    @VisibleForTesting
    static final String X_ANDROID_PACKAGE = "X-Android-Package";
    @VisibleForTesting
    static final String X_ANDROID_CERT = "X-Android-Cert";
    private final Context context;
    private final String apiKey;
    private final String appId;
    private final String projectId;
    private final Provider<HeartBeatController> heartBeatControllerProvider;
    public static final int UNKNOWN = 0;
    public static final int SAFETY_NET = 1;
    public static final int DEBUG = 2;
    public static final int PLAY_INTEGRITY = 3;

    public NetworkClient(@NonNull FirebaseApp firebaseApp) {
        this(firebaseApp.getApplicationContext(), firebaseApp.getOptions(), ((DefaultFirebaseAppCheck)FirebaseAppCheck.getInstance(firebaseApp)).getHeartbeatControllerProvider());
    }

    @VisibleForTesting
    NetworkClient(@NonNull Context context, @NonNull FirebaseOptions firebaseOptions, @NonNull Provider<HeartBeatController> heartBeatControllerProvider) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(firebaseOptions);
        Preconditions.checkNotNull(heartBeatControllerProvider);
        this.context = context;
        this.apiKey = firebaseOptions.getApiKey();
        this.appId = firebaseOptions.getApplicationId();
        this.projectId = firebaseOptions.getProjectId();
        if (this.projectId == null) {
            throw new IllegalArgumentException("FirebaseOptions#getProjectId cannot be null.");
        }
        this.heartBeatControllerProvider = heartBeatControllerProvider;
    }

    @NonNull
    public AppCheckTokenResponse exchangeAttestationForAppCheckToken(@NonNull byte[] requestBytes, int tokenType, @NonNull RetryManager retryManager) throws FirebaseException, IOException, JSONException {
        if (!retryManager.canRetry()) {
            throw new FirebaseException("Too many attempts.");
        }
        URL url = new URL(String.format(NetworkClient.getUrlTemplate(tokenType), this.projectId, this.appId, this.apiKey));
        String response = this.makeNetworkRequest(url, requestBytes, retryManager, true);
        return AppCheckTokenResponse.fromJsonString(response);
    }

    @NonNull
    public String generatePlayIntegrityChallenge(@NonNull byte[] requestBytes, @NonNull RetryManager retryManager) throws FirebaseException, IOException, JSONException {
        if (!retryManager.canRetry()) {
            throw new FirebaseException("Too many attempts.");
        }
        URL url = new URL(String.format(PLAY_INTEGRITY_CHALLENGE_URL_TEMPLATE, this.projectId, this.appId, this.apiKey));
        return this.makeNetworkRequest(url, requestBytes, retryManager, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String makeNetworkRequest(@NonNull URL url, @NonNull byte[] requestBytes, @NonNull RetryManager retryManager, boolean resetRetryManagerOnSuccess) throws FirebaseException, IOException, JSONException {
        HttpURLConnection urlConnection = this.createHttpUrlConnection(url);
        try {
            urlConnection.setDoOutput(true);
            urlConnection.setFixedLengthStreamingMode(requestBytes.length);
            urlConnection.setRequestProperty(CONTENT_TYPE, APPLICATION_JSON);
            String heartBeatHeader = this.getHeartBeat();
            if (heartBeatHeader != null) {
                urlConnection.setRequestProperty(X_FIREBASE_CLIENT, heartBeatHeader);
            }
            urlConnection.setRequestProperty(X_ANDROID_PACKAGE, this.context.getPackageName());
            urlConnection.setRequestProperty(X_ANDROID_CERT, this.getFingerprintHashForPackage());
            try (BufferedOutputStream out = new BufferedOutputStream(urlConnection.getOutputStream(), requestBytes.length);){
                ((OutputStream)out).write(requestBytes, 0, requestBytes.length);
            }
            int responseCode = urlConnection.getResponseCode();
            InputStream in = NetworkClient.isResponseSuccess(responseCode) ? urlConnection.getInputStream() : urlConnection.getErrorStream();
            StringBuilder response = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            }
            String responseBody = response.toString();
            if (!NetworkClient.isResponseSuccess(responseCode)) {
                retryManager.updateBackoffOnFailure(responseCode);
                HttpErrorResponse httpErrorResponse = HttpErrorResponse.fromJsonString(responseBody);
                throw new FirebaseException("Error returned from API. code: " + httpErrorResponse.getErrorCode() + " body: " + httpErrorResponse.getErrorMessage());
            }
            if (resetRetryManagerOnSuccess) {
                retryManager.resetBackoffOnSuccess();
            }
            String string = responseBody;
            return string;
        }
        finally {
            urlConnection.disconnect();
        }
    }

    @VisibleForTesting
    String getHeartBeat() {
        HeartBeatController controller = this.heartBeatControllerProvider.get();
        if (controller != null) {
            try {
                return Tasks.await(controller.getHeartBeatsHeader());
            }
            catch (Exception e) {
                Log.w(TAG, "Unable to get heartbeats!");
                return null;
            }
        }
        return null;
    }

    private String getFingerprintHashForPackage() {
        try {
            byte[] hash = AndroidUtilsLight.getPackageCertificateHashBytes(this.context, this.context.getPackageName());
            if (hash == null) {
                Log.e(TAG, "Could not get fingerprint hash for package: " + this.context.getPackageName());
                return null;
            }
            return Hex.bytesToStringUppercase(hash, false);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "No such package: " + this.context.getPackageName(), e);
            return null;
        }
    }

    private static String getUrlTemplate(int tokenType) {
        switch (tokenType) {
            case 1: {
                return SAFETY_NET_EXCHANGE_URL_TEMPLATE;
            }
            case 2: {
                return DEBUG_EXCHANGE_URL_TEMPLATE;
            }
            case 3: {
                return PLAY_INTEGRITY_EXCHANGE_URL_TEMPLATE;
            }
        }
        throw new IllegalArgumentException("Unknown token type.");
    }

    @VisibleForTesting
    HttpURLConnection createHttpUrlConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    private static final boolean isResponseSuccess(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AttestationTokenType {
    }
}

